/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database.pool;

import edu.stanford.smi.protege.storage.database.pool.ConnectionInfo;
import edu.stanford.smi.protege.storage.database.pool.DatabaseParam;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionPool {
    private static Logger log = Log.getLogger(ConnectionPool.class);
    private static Map<DatabaseParam, ConnectionPool> connectionPoolMap = new HashMap<DatabaseParam, ConnectionPool>();
    public static final String PROPERTY_REFRESH_CONNECTIONS_TIME = "Database.refresh.connections.interval";
    public static final String PROPERTY_MAX_DB_CONNECTIONS = "Database.max.connections";
    public static final String PROPERTY_LONG_RUNNING_CONNECTIONS = "Database.long.running.connection.time";
    private static long connectionRefreshInterval;
    private static int maxOpenConnections;
    private static long connectionLongTime;
    private String driver;
    private String url;
    private String username;
    private String password;
    private int referenceCount = 0;
    private Set<Connection> idleConnections = new HashSet<Connection>();
    private Map<Connection, ConnectionInfo> connectionInfoMap = new HashMap<Connection, ConnectionInfo>();
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, "Protege Connection Reaper");
            th.setDaemon(true);
            return th;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionPool getConnectionPool(String driver, String url, String username, String password) {
        ConnectionPool pool;
        Map<DatabaseParam, ConnectionPool> map = connectionPoolMap;
        synchronized (map) {
            DatabaseParam dp = new DatabaseParam(driver, url, username, password);
            pool = connectionPoolMap.get(dp);
            if (pool == null) {
                pool = new ConnectionPool(driver, url, username, password);
                connectionPoolMap.put(dp, pool);
            }
        }
        pool.reference();
        return pool;
    }

    private ConnectionPool(String driver, String url, String username, String password) {
        Class clas = SystemUtilities.forName(driver);
        if (clas == null) {
            throw new RuntimeException("class not found: " + driver);
        }
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.executor.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ConnectionPool.this.cleanup();
                ConnectionPool.this.setReaperThreadName();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(Connection connection) {
        ConnectionInfo ci;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ci = this.connectionInfoMap.get(connection);
        }
        return ci != null ? ci.getId() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Object ci;
        Connection connection = null;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (!this.idleConnections.isEmpty()) {
                connection = this.idleConnections.iterator().next();
                this.idleConnections.remove(connection);
            }
        }
        if (connection == null) {
            connection = DriverManager.getConnection(this.url, this.username, this.password);
            ci = new ConnectionInfo(connection);
            ConnectionPool connectionPool2 = this;
            synchronized (connectionPool2) {
                this.connectionInfoMap.put(connection, (ConnectionInfo)ci);
            }
        }
        ci = this;
        synchronized (ci) {
            ConnectionInfo ci2 = this.connectionInfoMap.get(connection);
            ci2.touch();
            if (connectionLongTime > 0L) {
                ci2.setInformedUserOfLongConnectionTime(false);
                ci2.setConnectionCallStack(new Exception("getConnection stack trace"));
            }
        }
        if (log.isLoggable(Level.FINE)) {
            ci = this.connectionInfoMap.get(connection);
            log.fine("Thread " + Thread.currentThread() + " caller allocated Connection with id = " + ((ConnectionInfo)ci).getId());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetConnection(Connection connection) {
        ConnectionInfo ci;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ci = this.connectionInfoMap.get(connection);
            if (ci == null) {
                throw new IllegalStateException("Returning connection to the wrong pool");
            }
            this.idleConnections.add(connection);
            ci.touch();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Thread " + Thread.currentThread() + " deallocated connection with id = " + ci.getId());
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement(Connection connection) throws SQLException {
        ConnectionInfo ci;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ci = this.connectionInfoMap.get(connection);
            if (ci == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
            ci.touch();
        }
        return ci.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(Connection connection, String text) throws SQLException {
        ConnectionInfo ci;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ci = this.connectionInfoMap.get(connection);
            if (ci == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
            ci.touch();
        }
        return ci.getPreparedStatement(text);
    }

    public void reference() {
        ++this.referenceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dereference() throws SQLException {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            Map<DatabaseParam, ConnectionPool> map = connectionPoolMap;
            synchronized (map) {
                DatabaseParam dp = new DatabaseParam(this.driver, this.url, this.username, this.password);
                connectionPoolMap.remove(dp);
            }
            this.executor.shutdownNow();
            for (ConnectionInfo ci : this.connectionInfoMap.values()) {
                ci.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatements(Connection connection) throws SQLException {
        ConnectionInfo ci;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ci = this.connectionInfoMap.get(connection);
            if (ci == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
        }
        ci.closeStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblem(Connection connection) throws SQLException {
        ConnectionInfo ci;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ci = this.connectionInfoMap.remove(connection);
            if (ci == null) {
                throw new IllegalStateException("Connection not managed by this pool");
            }
            this.idleConnections.remove(connection);
        }
        ci.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long now = System.currentTimeMillis();
        ArrayList<ConnectionInfo> myIdleConnections = new ArrayList<ConnectionInfo>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (Connection connection : this.idleConnections) {
                myIdleConnections.add(this.connectionInfoMap.get(connection));
            }
            Collections.sort(myIdleConnections, new Comparator<ConnectionInfo>(){

                @Override
                public int compare(ConnectionInfo o1, ConnectionInfo o2) {
                    return (int)(o1.getLastAccessTime() - o2.getLastAccessTime());
                }
            });
        }
        for (ConnectionInfo ci : myIdleConnections) {
            ConnectionPool connectionPool2 = this;
            synchronized (connectionPool2) {
                if (now - ci.getLastAccessTime() <= connectionRefreshInterval) {
                    break;
                }
                if (!this.idleConnections.contains(ci.getConnection())) {
                    continue;
                }
                this.idleConnections.remove(ci.getConnection());
                this.connectionInfoMap.remove(ci.getConnection());
            }
            try {
                ci.close();
            }
            catch (Throwable throwable) {
                if (!log.isLoggable(Level.WARNING)) continue;
                log.log(Level.WARNING, "Exception caught closing connection during cleanup", throwable);
            }
        }
        for (ConnectionInfo ci : myIdleConnections) {
            ConnectionPool connectionPool3 = this;
            synchronized (connectionPool3) {
                if (this.idleConnections.size() <= maxOpenConnections) {
                    break;
                }
                if (!this.idleConnections.contains(ci.getConnection())) {
                    continue;
                }
                this.idleConnections.remove(ci.getConnection());
                this.connectionInfoMap.remove(ci.getConnection());
            }
            try {
                ci.close();
            }
            catch (Throwable throwable) {
                if (!log.isLoggable(Level.WARNING)) continue;
                log.log(Level.WARNING, "Exception caught closing connection during cleanup", throwable);
            }
        }
        if (connectionLongTime > 0L) {
            this.checkLongRunningConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLongRunningConnections() {
        long now = System.currentTimeMillis();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (Map.Entry<Connection, ConnectionInfo> entry : this.connectionInfoMap.entrySet()) {
                Connection connection = entry.getKey();
                ConnectionInfo ci = entry.getValue();
                if (ci.getInformedUserOfLongConnectionTime() || now - ci.getLastAccessTime() <= connectionLongTime || this.idleConnections.contains(connection)) continue;
                log.log(Level.WARNING, "Connection has been reserved but idle for a long time (" + (now - ci.getLastAccessTime()) + "ms).  Call stack follows.", ci.getConnectionCallStack());
                ci.setInformedUserOfLongConnectionTime(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReaperThreadName() {
        int idleCount;
        int connectionCount;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connectionCount = this.connectionInfoMap.size();
            idleCount = this.idleConnections.size();
        }
        Thread.currentThread().setName("Connection Reaper [" + connectionCount + ", " + idleCount + "]");
    }

    static {
        int minutes = ApplicationProperties.getIntegerProperty(PROPERTY_REFRESH_CONNECTIONS_TIME, 5);
        connectionRefreshInterval = minutes * 60 * 1000;
        maxOpenConnections = ApplicationProperties.getIntegerProperty(PROPERTY_MAX_DB_CONNECTIONS, 3);
        int longTime = ApplicationProperties.getIntegerProperty(PROPERTY_LONG_RUNNING_CONNECTIONS, -1);
        connectionLongTime = longTime * 60 * 1000;
    }
}

