/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class Element {
    private String name;
    private Attributes attributes;
    private String value;
    private List subelements;

    Element(String name, Attributes attributes) {
        this.name = name;
        this.attributes = new AttributesImpl(attributes);
    }

    public void addCharacters(String s) {
        this.value = this.value == null ? s : this.value + s;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void addElement(Element element) {
        if (this.subelements == null) {
            this.subelements = new ArrayList();
        }
        this.subelements.add(element);
    }

    public String getAttributeValue(String type) {
        return this.attributes.getValue(type);
    }

    public Element getSubelement(int index) {
        return (Element)this.subelements.get(index);
    }

    public Collection getSubelements() {
        return this.subelements;
    }

    public String getSubelementValue(String tag) {
        return (String)CollectionUtilities.getFirstItem(this.getSubelementValues(tag));
    }

    public Collection getSubelementValues(String tag) {
        ArrayList<String> values = new ArrayList<String>();
        for (Element element : this.subelements) {
            if (!element.getName().equals(tag)) continue;
            values.add(element.getValue());
        }
        return values;
    }

    public Collection getSubelements(String tag) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element element : this.subelements) {
            if (!element.getName().equals(tag)) continue;
            elements.add(element);
        }
        return elements;
    }
}

