/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.storage.xml.Element;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHandler
extends DefaultHandler {
    private KnowledgeBase kb;
    private boolean isIncluded;
    private Collection errors;
    private LinkedList openElements = new LinkedList();

    public XMLHandler(KnowledgeBase kb, boolean isIncluded, Collection errors) {
        this.kb = kb;
        this.errors = errors;
        this.isIncluded = isIncluded;
    }

    public void error(SAXParseException exception) {
        this.handle(exception);
    }

    public void fatalError(SAXParseException exception) {
        this.handle(exception);
    }

    public void warning(SAXParseException exception) {
        this.handle(exception);
    }

    private void handle(Exception e) {
        String message = "Error at parsing ";
        message = e instanceof SAXParseException ? message + "token ar line " + ((SAXParseException)e).getLineNumber() + " column " + ((SAXParseException)e).getColumnNumber() : message + "XML file";
        this.errors.add(new MessageError(e, message));
        Log.getLogger().log(Level.SEVERE, message, e);
    }

    private Element getCurrentElement() {
        return this.openElements.isEmpty() ? null : (Element)this.openElements.get(this.openElements.size() - 1);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (!qName.equals("knowledge_base")) {
            Element element = new Element(qName, atts);
            if (this.openElements.isEmpty()) {
                this.openElements.add(element);
            } else {
                this.getCurrentElement().addElement(element);
                this.openElements.add(element);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (!qName.equals("knowledge_base")) {
            Element lastElement = (Element)this.openElements.remove(this.openElements.size() - 1);
            if (this.openElements.isEmpty()) {
                this.createFrame(lastElement);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        Element currentElement = this.getCurrentElement();
        if (currentElement != null) {
            currentElement.addCharacters(new String(ch, start, length));
        }
    }

    private Collection getElementClsValues(Element root, String tag) {
        ArrayList<Cls> clses = new ArrayList<Cls>();
        for (String clsName : root.getSubelementValues(tag)) {
            clses.add(this.getCls(clsName));
        }
        return clses;
    }

    private Collection getElementSlotValues(Element root, String tag) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (String slotName : root.getSubelementValues(tag)) {
            slots.add(this.getSlot(slotName));
        }
        return slots;
    }

    private Cls getCls(String name) {
        Cls cls = this.kb.getCls(name);
        if (cls == null) {
            cls = this.kb.createCls(new FrameID(name), (Collection)Collections.EMPTY_LIST, Collections.EMPTY_LIST, false);
        }
        return cls;
    }

    private Slot getSlot(String name) {
        Slot slot = this.kb.getSlot(name);
        if (slot == null) {
            slot = this.kb.createSlot(name, null, Collections.EMPTY_LIST, false);
        }
        return slot;
    }

    private Facet getFacet(String name) {
        Facet facet = this.kb.getFacet(name);
        if (facet == null) {
            facet = this.kb.createFacet(name, null, false);
        }
        return facet;
    }

    private SimpleInstance getSimpleInstance(String name) {
        SimpleInstance simpleInstance = this.kb.getSimpleInstance(name);
        if (simpleInstance == null) {
            simpleInstance = this.kb.createSimpleInstance(new FrameID(name), Collections.EMPTY_LIST, false);
        }
        return simpleInstance;
    }

    private void createFrame(Element root) {
        Instance frame;
        String kind = root.getName();
        String name = root.getSubelementValue("name");
        Collection types = this.getElementClsValues(root, "type");
        if (kind.equals("class")) {
            frame = this.createCls(name, types, root);
        } else if (kind.equals("slot")) {
            frame = this.createSlot(name, types, root);
        } else if (kind.equals("facet")) {
            frame = this.createFacet(name, types, root);
        } else if (kind.equals("simple_instance")) {
            frame = this.createSimpleInstance(name, types, root);
        } else {
            Log.getLogger().warning("bad frame type: " + kind);
            frame = null;
        }
        if (frame != null) {
            this.addOwnSlotValues(frame, root);
        }
    }

    private void addTemplateFacetValues(Cls cls, Element root) {
        for (Element node : root.getSubelements("template_facet_value")) {
            this.addTemplateFacetValue(cls, node);
        }
    }

    private void addTemplateFacetValue(Cls cls, Element node) {
        Slot slot = null;
        Facet facet = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Element element : node.getSubelements()) {
            String elementName = element.getName();
            if (elementName.equals("slot_reference")) {
                slot = this.getSlot(element.getValue());
                continue;
            }
            if (elementName.equals("facet_reference")) {
                facet = this.getFacet(element.getValue());
                continue;
            }
            Object value = this.getValue(element);
            if (value == null) continue;
            values.add(value);
        }
        cls.setTemplateFacetValues(slot, facet, values);
    }

    private void addOwnSlotValues(Frame frame, Element root) {
        for (Element node : root.getSubelements("own_slot_value")) {
            this.addOwnSlotValue(frame, node);
        }
    }

    private void addOwnSlotValue(Frame frame, Element node) {
        Slot slot = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Element element : node.getSubelements()) {
            if (element.getName().equals("slot_reference")) {
                slot = this.getSlot(element.getValue());
                continue;
            }
            Object value = this.getValue(element);
            if (value == null) continue;
            values.add(value);
        }
        frame.setOwnSlotValues(slot, values);
    }

    private Object getValue(Element element) {
        Object value;
        String valueString = element.getValue();
        String type = element.getAttributeValue("value_type");
        if (type.equals("class")) {
            value = this.getCls(valueString);
        } else if (type.equals("slot")) {
            value = this.getSlot(valueString);
        } else if (type.equals("facet")) {
            value = this.getFacet(valueString);
        } else if (type.equals("simple_instance")) {
            value = this.getSimpleInstance(valueString);
        } else if (type.equals("string")) {
            value = valueString;
        } else if (type.equals("boolean")) {
            value = Boolean.valueOf(valueString);
        } else if (type.equals("integer")) {
            value = new Integer(valueString);
        } else if (type.equals("float")) {
            value = new Float(valueString);
        } else {
            Log.getLogger().warning("bad value type: " + type);
            value = null;
        }
        return value;
    }

    private static void addSuperclasses(Cls cls, Collection superclasses) {
        if (!superclasses.isEmpty()) {
            Collection<Cls> currentSuperclasses = cls.getDirectSuperclasses();
            for (Cls superclass : superclasses) {
                if (currentSuperclasses.contains(superclass)) continue;
                cls.addDirectSuperclass(superclass);
            }
        }
    }

    private static void addTypes(Instance instance, Collection types) {
        if (!types.isEmpty()) {
            Collection currentTypes = instance.getDirectTypes();
            for (Cls type : types) {
                if (currentTypes.contains(type)) continue;
                instance.addDirectType(type);
            }
        }
    }

    private Cls createCls(String name, Collection types, Element root) {
        Collection superclasses = this.getElementClsValues(root, "superclass");
        Cls cls = this.kb.getCls(name);
        if (cls == null) {
            cls = this.kb.createCls(new FrameID(name), superclasses, types, false);
            this.setIncluded(cls);
        } else {
            XMLHandler.addTypes(cls, types);
            XMLHandler.addSuperclasses(cls, superclasses);
        }
        Collection slots = this.getElementSlotValues(root, "template_slot");
        for (Slot slot : slots) {
            cls.addDirectTemplateSlot(slot);
        }
        this.addTemplateFacetValues(cls, root);
        return cls;
    }

    private Slot createSlot(String name, Collection types, Element root) {
        Slot slot = this.kb.getSlot(name);
        if (slot == null) {
            Cls type = (Cls)CollectionUtilities.getFirstItem(types);
            slot = this.kb.createSlot(name, type, Collections.EMPTY_LIST, false);
            this.setIncluded(slot);
        } else {
            XMLHandler.addTypes(slot, types);
        }
        return slot;
    }

    private Facet createFacet(String name, Collection types, Element root) {
        Facet facet = this.kb.getFacet(name);
        if (facet == null) {
            Cls type = (Cls)CollectionUtilities.getFirstItem(types);
            facet = this.kb.createFacet(name, type, false);
            this.setIncluded(facet);
        } else {
            XMLHandler.addTypes(facet, types);
        }
        return facet;
    }

    private SimpleInstance createSimpleInstance(String name, Collection types, Element root) {
        SimpleInstance simpleInstance = (SimpleInstance)this.kb.getInstance(name);
        if (simpleInstance == null) {
            simpleInstance = this.kb.createSimpleInstance(new FrameID(name), types, false);
            this.setIncluded(simpleInstance);
        } else {
            XMLHandler.addTypes(simpleInstance, types);
        }
        return simpleInstance;
    }

    private void setIncluded(Frame frame) {
        if (this.isIncluded) {
            frame.setIncluded(true);
        }
    }
}

