/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.model.AbstractKnowledgeBaseFactory;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.storage.xml.FileSourcesPanel;
import edu.stanford.smi.protege.storage.xml.XMLLoader;
import edu.stanford.smi.protege.storage.xml.XMLStorer;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;

public class XMLKnowledgeBaseFactory
extends AbstractKnowledgeBaseFactory {
    public static final String DESCRIPTION = "Experimental XML File (.xml)";
    private static final String SOURCE_FILE_NAME = "source_file_name";

    public KnowledgeBase createKnowledgeBase(Collection errors) {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase(this);
        return kb;
    }

    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String project, PropertyList list) {
        return new FileSourcesPanel(project, list);
    }

    public static String getSourceFile(PropertyList sources) {
        return sources.getString(SOURCE_FILE_NAME);
    }

    public static URI getSourceRelativeURI(PropertyList sources) {
        return URIUtilities.createURI(XMLKnowledgeBaseFactory.getSourceFile(sources));
    }

    public BufferedReader getSourceReader(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String name = XMLKnowledgeBaseFactory.getSourceFile(sources);
        return name == null ? null : this.createReader(kb, name, errors);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public boolean isComplete(PropertyList sources) {
        return true;
    }

    protected void loadKnowledgeBase(KnowledgeBase kb, PropertyList sources, boolean isInclude, Collection errors) {
        BufferedReader reader = this.getSourceReader(kb, sources, errors);
        XMLKnowledgeBaseFactory.loadKnowledgeBase(kb, reader, isInclude, errors);
        this.close(reader);
    }

    public static void loadKnowledgeBase(KnowledgeBase kb, BufferedReader reader, boolean isInclude, Collection errors) {
        boolean cachingEnabled = kb.setCallCachingEnabled(false);
        boolean eventsEnabled = kb.setGenerateEventsEnabled(false);
        new XMLLoader(kb, reader, isInclude, errors).load();
        kb.setGenerateEventsEnabled(eventsEnabled);
        kb.setCallCachingEnabled(cachingEnabled);
    }

    public void loadKnowledgeBase(KnowledgeBase kb, String sourceName, boolean isInclude, Collection errors) {
        BufferedReader reader = this.createReader(kb, sourceName, errors);
        XMLKnowledgeBaseFactory.loadKnowledgeBase(kb, reader, isInclude, errors);
        FileUtilities.close(reader);
    }

    public KnowledgeBase loadKnowledgeBase(BufferedReader reader, Collection errors) {
        KnowledgeBase kb = this.createKnowledgeBase(errors);
        XMLKnowledgeBaseFactory.loadKnowledgeBase(kb, reader, false, errors);
        return kb;
    }

    public KnowledgeBase loadKnowledgeBase(String filename, Collection errors) {
        KnowledgeBase kb = this.createKnowledgeBase(errors);
        this.loadKnowledgeBase(kb, filename, false, errors);
        return kb;
    }

    public void saveKnowledgeBase(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String projectBaseName = kb.getProject().getProjectName();
        String sourceName = XMLKnowledgeBaseFactory.getSourceFile(sources);
        if (sourceName == null) {
            sourceName = projectBaseName + ".xml";
            XMLKnowledgeBaseFactory.setSourceFile(sources, sourceName);
        }
        this.saveKnowledgeBase(kb, sourceName, errors);
    }

    public static void saveKnowledgeBase(KnowledgeBase kb, Writer writer, Collection errors) {
        new XMLStorer(kb, writer, errors).store();
    }

    public void saveKnowledgeBase(KnowledgeBase kb, String filename, Collection errors) {
        BufferedWriter writer = null;
        try {
            File file = this.createTempFile(kb, filename);
            writer = this.createWriter(file);
            XMLKnowledgeBaseFactory.saveKnowledgeBase(kb, writer, errors);
            this.close(writer);
            if (errors.isEmpty()) {
                this.makeTempFilePermanent(file);
            }
        }
        catch (Exception e) {
            String message = "Errors saving file " + filename;
            errors.add(new MessageError(e, message));
            Log.getLogger().log(Level.SEVERE, message, e);
            this.close(writer);
        }
    }

    public static void setSourceFile(PropertyList sources, String filename) {
        XMLKnowledgeBaseFactory.setProperty(sources, SOURCE_FILE_NAME, filename);
    }

    public static void setSourceURIs(PropertyList sources, URI relativeURI) {
        XMLKnowledgeBaseFactory.setSourceFile(sources, XMLKnowledgeBaseFactory.toString(relativeURI));
    }

    private static String toString(URI uri) {
        return uri == null ? null : uri.toString();
    }

    private static void setProperty(PropertyList sources, String propertyName, String value) {
        sources.setString(propertyName, value);
    }
}

