/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.storage.xml.XMLHandler;
import edu.stanford.smi.protege.util.Log;
import java.io.BufferedReader;
import java.util.Collection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLoader {
    private KnowledgeBase kb;
    private Collection errors;
    private BufferedReader reader;
    private boolean isIncluded;

    public XMLLoader(KnowledgeBase kb, BufferedReader reader, boolean isIncluded, Collection errors) {
        this.kb = kb;
        this.reader = reader;
        this.errors = errors;
        this.isIncluded = isIncluded;
    }

    public void load() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(this.reader), (DefaultHandler)new XMLHandler(this.kb, this.isIncluded, this.errors));
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
    }
}

