/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.storage.xml.XMLUtil;
import edu.stanford.smi.protege.util.Log;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XMLStorer {
    private KnowledgeBase kb;
    private PrintWriter writer;
    private Collection excludeSlots = new HashSet();
    private int indentLevel = 0;
    private NarrowFrameStore activeFrameStore;
    private Collection activeFrames;

    public XMLStorer(KnowledgeBase kb, Writer writer, Collection errors) {
        this.kb = kb;
        this.writer = new PrintWriter(writer);
        this.initializeExcludeSlots();
        this.activeFrameStore = MergingNarrowFrameStore.get(kb).getActiveFrameStore();
        this.activeFrames = this.activeFrameStore.getFrames();
    }

    private void initializeExcludeSlots() {
        this.exclude(":NAME");
        this.exclude(":DIRECT-INSTANCES");
        this.exclude(":DIRECT-TEMPLATE-SLOTS");
        this.exclude(":DIRECT-SUPERCLASSES");
        this.exclude(":DIRECT-SUBCLASSES");
        this.exclude(":DIRECT-TYPE");
        this.exclude(":DIRECT-INSTANCES");
        this.exclude(":DIRECT-SUBSLOTS");
        this.exclude(":DIRECT-SUPERSLOTS");
        this.exclude(":DIRECT-DOMAIN");
        this.exclude(":ASSOCIATED-SLOT");
    }

    private void exclude(String slotName) {
        this.excludeSlots.add(this.kb.getSlot(slotName));
    }

    private void indent() {
        ++this.indentLevel;
    }

    private void unindent() {
        --this.indentLevel;
    }

    public void store() {
        this.preamble();
        this.indent();
        this.storeClses();
        this.storeSlots();
        this.storeFacets();
        this.storeSimpleInstances();
        this.unindent();
        this.postscript();
        this.writer.flush();
    }

    private void storeClses() {
        this.storeCls(this.kb.getRootCls(), new HashSet());
    }

    private void storeSlots() {
        ArrayList slots = new ArrayList(this.kb.getSlots());
        Collections.sort(slots);
        for (Slot slot : slots) {
            this.storeSlot(slot);
        }
    }

    private void storeFacets() {
        ArrayList facets = new ArrayList(this.kb.getFacets());
        Collections.sort(facets);
        for (Facet facet : facets) {
            this.storeFacet(facet);
        }
    }

    private void storeSimpleInstances() {
        HashSet storedInstances = new HashSet();
        for (Cls cls : this.kb.getClses()) {
            this.storeSimpleInstances(cls, storedInstances);
        }
    }

    private void storeSimpleInstances(Cls cls, Set storedInstances) {
        for (Instance instance : cls.getDirectInstances()) {
            if (!(instance instanceof SimpleInstance) || storedInstances.contains(instance)) continue;
            this.storeSimpleInstance((SimpleInstance)instance);
            storedInstances.add(instance);
        }
    }

    private void printHeader() {
        this.println("<?xml version=\"1.0\" ?>");
    }

    private void preamble() {
        this.printHeader();
        String[] attributes = new String[]{"xmlns=\"http://protege.stanford.edu/xml\"", "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "xsi:schemaLocation=\"http://protege.stanford.edu/xml http://protege.stanford.edu/xml/schema/protege.xsd\""};
        this.println();
        this.printStartTag("knowledge_base", attributes);
    }

    private void postscript() {
        this.printEndTag("knowledge_base");
    }

    private void println(String s) {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writer.print("\t");
        }
        this.writer.println(s);
    }

    private void println() {
        this.writer.println();
    }

    private static String escape(String value) {
        return XMLUtil.escape(value);
    }

    private void printValue(String element, String value) {
        this.println("<" + element + ">" + XMLStorer.escape(value) + "</" + element + ">");
    }

    private void printValue(String element, String elementValue, String attribute, String value) {
        this.println("<" + element + " " + attribute + "=\"" + value + "\">" + XMLStorer.escape(elementValue) + "</" + element + ">");
    }

    private void printFrameReference(String tag, Frame frame) {
        this.printValue(tag, frame.getName());
    }

    private void printStartTag(String element) {
        this.printStartTag(element, null);
    }

    private void printStartTag(String element, String[] attribute) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(element);
        if (attribute != null) {
            for (int i = 0; i < attribute.length; ++i) {
                if (attribute.length == 1) {
                    buffer.append(" ");
                } else {
                    buffer.append("\n\t");
                }
                buffer.append(attribute[i]);
            }
        }
        buffer.append(">");
        this.println(buffer.toString());
    }

    private void printEndTag(String element) {
        this.println("</" + element + ">");
    }

    private void printOwnSlotValues(Frame frame) {
        for (Slot slot : frame.getOwnSlots()) {
            if (!this.printOwnSlot(frame, slot)) continue;
            this.printOwnSlotValues(frame, slot);
        }
    }

    private boolean printOwnSlot(Frame frame, Slot slot) {
        return !this.excludeSlots.contains(slot);
    }

    private void printOwnSlotValues(Frame frame, Slot slot) {
        List values = frame.getDirectOwnSlotValues(slot);
        if (!values.isEmpty()) {
            this.printStartTag("own_slot_value");
            this.indent();
            this.printValue("slot_reference", slot.getName());
            this.printValues(frame.getDirectOwnSlotValues(slot));
            this.unindent();
            this.printEndTag("own_slot_value");
        }
    }

    private void printValues(Collection values) {
        for (Object o : values) {
            this.printValue(o);
        }
    }

    private void printValue(Object o) {
        String value;
        String attribute;
        String tag;
        if (o instanceof Frame) {
            tag = "value";
            attribute = XMLStorer.frameAttribute(o);
            value = XMLStorer.frameValue(o);
        } else {
            tag = "value";
            if (o instanceof String) {
                attribute = "string";
                value = (String)o;
            } else if (o instanceof Integer) {
                attribute = "integer";
                value = o.toString();
            } else if (o instanceof Float) {
                attribute = "float";
                value = o.toString();
            } else if (o instanceof Boolean) {
                attribute = "boolean";
                value = o.toString();
            } else {
                Log.getLogger().warning("Unexpected object: " + o);
                attribute = "string";
                value = o.toString();
            }
        }
        this.printValue(tag, value, "value_type", attribute);
    }

    private static String frameValue(Object o) {
        return ((Frame)o).getName();
    }

    private static String frameAttribute(Object o) {
        String attribute = o instanceof Cls ? "class" : (o instanceof Slot ? "slot" : (o instanceof Facet ? "facet" : "simple_instance"));
        return attribute;
    }

    private void endInstance(String frameType, Instance instance) {
        this.printEndTag(frameType);
    }

    private void beginInstance(String frameType, Instance instance) {
        this.println();
        this.printStartTag(frameType);
        this.indent();
        this.printValue("name", instance.getName());
        this.printFrameValues("type", instance.getDirectTypes());
        this.printOwnSlotValues(instance);
        this.unindent();
    }

    private void printFrameValues(String tag, Collection frames) {
        for (Frame frame : frames) {
            this.printFrameReference(tag, frame);
        }
    }

    private void storeCls(Cls cls, Set storedClses) {
        if (this.shouldPrintFrame(cls)) {
            this.beginInstance("class", cls);
            this.indent();
            this.printFrameValues("superclass", cls.getDirectSuperclasses());
            this.printFrameValues("template_slot", cls.getDirectTemplateSlots());
            this.printTemplateFacetValues(cls);
            this.unindent();
            this.endInstance("class", cls);
        }
        storedClses.add(cls);
        this.storeSubclasses(cls, storedClses);
    }

    private boolean shouldPrintFrame(Frame frame) {
        boolean shouldPrintFrame = this.activeFrames.contains(frame);
        if (frame.getName().equals("label")) {
            Log.getLogger().info("label: " + shouldPrintFrame);
        }
        if (shouldPrintFrame) {
            shouldPrintFrame = false;
            for (Slot slot : frame.getOwnSlots()) {
                if (!this.shouldStoreSlot(slot)) continue;
                shouldPrintFrame = true;
                break;
            }
        }
        return shouldPrintFrame;
    }

    private boolean shouldStoreSlot(Slot slot) {
        return !this.excludeSlots.contains(slot);
    }

    private void storeSubclasses(Cls cls, Set storedClses) {
        for (Cls subclass : cls.getDirectSubclasses()) {
            if (storedClses.contains(subclass)) continue;
            this.storeCls(subclass, storedClses);
        }
    }

    private void printTemplateFacetValues(Cls cls) {
        for (Slot slot : cls.getTemplateSlots()) {
            this.printTemplateFacetValues(cls, slot);
        }
    }

    private void printTemplateFacetValues(Cls cls, Slot slot) {
        for (Facet facet : cls.getTemplateFacets(slot)) {
            List values = cls.getDirectTemplateFacetValues(slot, facet);
            if (values.isEmpty()) continue;
            this.printTemplateFacetValues(slot, facet, values);
        }
    }

    private void printTemplateFacetValues(Slot slot, Facet facet, Collection values) {
        this.printStartTag("template_facet_value");
        this.indent();
        this.printFrameReference("slot_reference", slot);
        this.printFrameReference("facet_reference", facet);
        this.printValues(values);
        this.unindent();
        this.printEndTag("template_facet_value");
    }

    private void storeSlot(Slot slot) {
        if (this.shouldPrintFrame(slot)) {
            this.beginInstance("slot", slot);
            this.printFrameValues("superslot", slot.getDirectSuperslots());
            this.endInstance("slot", slot);
        }
    }

    private void storeFacet(Facet facet) {
        if (this.shouldPrintFrame(facet)) {
            this.beginInstance("facet", facet);
            this.endInstance("facet", facet);
        }
    }

    private void storeSimpleInstance(SimpleInstance simpleInstance) {
        if (this.shouldPrintFrame(simpleInstance)) {
            this.beginInstance("simple_instance", simpleInstance);
            this.endInstance("simple_instance", simpleInstance);
        }
    }
}

