/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

public class XMLUtil {
    private static final int FIRST_PRINTABLE = 32;
    private static final int LAST_PRINTABLE = 126;

    private static String getEntityRef(char ch) {
        String ref;
        switch (ch) {
            case '<': {
                ref = "&lt;";
                break;
            }
            case '>': {
                ref = "&gt;";
                break;
            }
            case '\"': {
                ref = "&quot;";
                break;
            }
            case '\'': {
                ref = "&apos;";
                break;
            }
            case '&': {
                ref = "&amp;";
                break;
            }
            default: {
                ref = null;
            }
        }
        return ref;
    }

    public static String escape(char ch) {
        String charRef = XMLUtil.getEntityRef(ch);
        if (charRef == null) {
            charRef = XMLUtil.isPrintable(ch) ? "" + ch : "&#" + Integer.toString(ch) + ";";
        }
        return charRef;
    }

    private static boolean isPrintable(char ch) {
        return ' ' <= ch && ch <= '~' && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    public static String escape(String source) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            buffer.append(XMLUtil.escape(source.charAt(i)));
        }
        return buffer.toString();
    }
}

