/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AboutBox
extends JPanel {
    private static final long serialVersionUID = 644756887038597032L;

    public AboutBox(URL url, Dimension preferredSize) {
        this.setLayout(new BorderLayout());
        JEditorPane pane = ComponentFactory.createHTMLBrowser(url);
        AboutBox.substitute(pane);
        pane.setEditable(false);
        if (preferredSize != null) {
            this.setPreferredSize(preferredSize);
        } else {
            this.setPreferredSize(new Dimension(535, 550));
        }
        JScrollPane scrollPane = new JScrollPane(pane);
        this.add(scrollPane);
    }

    private static void substitute(JEditorPane pane) {
        String text = AboutBox.getText(pane);
        text = AboutBox.replace(text, "{0}", Text.getVersion());
        text = AboutBox.replace(text, "{1}", Text.getStatus());
        text = AboutBox.replace(text, "{2}", Text.getBuildInfo());
        text = AboutBox.replace(text, "{3}", Text.getCopyright());
        pane.setText(text);
    }

    private static String getText(JEditorPane pane) {
        String text = null;
        for (int i = 0; i < 100 && ((text = pane.getText()).indexOf("Stanford") == -1 || text.indexOf("</html>") == -1); ++i) {
            SystemUtilities.sleepMsec(100);
        }
        SystemUtilities.sleepMsec(100);
        return text;
    }

    private static String replace(String text, String macro, String replaceString) {
        return StringUtilities.replace(text, macro, replaceString);
    }
}

