/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SimpleListModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;

public class AboutPluginsBox
extends JPanel {
    private static final long serialVersionUID = -6678212119027124508L;
    private JList pluginsList = this.createPluginsList();
    private JEditorPane aboutViewer = AboutPluginsBox.createAboutViewer();

    public AboutPluginsBox() {
        this.layoutComponents();
    }

    private JList createPluginsList() {
        SelectableList list = ComponentFactory.createSelectableList(null);
        ListModel model = AboutPluginsBox.createPluginsModel();
        list.setModel(model);
        list.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                String componentName = (String)AboutPluginsBox.this.pluginsList.getSelectedValue();
                if (componentName != null) {
                    URL url = PluginUtilities.getPluginComponentAboutURL(componentName);
                    try {
                        AboutPluginsBox.this.aboutViewer.setPage(url);
                    }
                    catch (IOException e) {
                        Log.getLogger().warning(e.toString());
                    }
                }
            }
        });
        list.setPreferredSize(new Dimension(150, 150));
        return list;
    }

    private static ListModel createPluginsModel() {
        ArrayList<String> names = new ArrayList<String>(PluginUtilities.getPluginComponentNames());
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            URL url = PluginUtilities.getPluginComponentAboutURL(name);
            if (url != null) continue;
            i.remove();
        }
        Collections.sort(names);
        return new SimpleListModel(names);
    }

    private static JEditorPane createAboutViewer() {
        JEditorPane pane = ComponentFactory.createHTMLBrowser(null);
        pane.setPreferredSize(new Dimension(600, 600));
        return pane;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        LabeledComponent left = new LabeledComponent("Installed Plugins", new JScrollPane(this.pluginsList));
        LabeledComponent right = new LabeledComponent("About Selected Plugin", new JScrollPane(this.aboutViewer));
        JSplitPane pane = ComponentFactory.createLeftRightSplitPane(left, right);
        this.add(pane);
    }
}

