/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserTextListFinder
extends ListFinder {
    private static final long serialVersionUID = 3317904008378472274L;

    public BrowserTextListFinder(JList list, ResourceKey key) {
        super(list, key);
    }

    @Override
    protected List<Frame> getMatches(String text, int maxMatches) {
        if (!text.endsWith("*")) {
            text = text + "*";
        }
        SimpleStringMatcher matcher = new SimpleStringMatcher(text);
        ArrayList<Frame> matchingInstances = new ArrayList<Frame>();
        ListModel model = this._list.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            FrameWithBrowserText fbt = (FrameWithBrowserText)model.getElementAt(i);
            String browserText = fbt.getBrowserText();
            if (browserText == null || !matcher.isMatch(browserText = browserText.toLowerCase()) && !matcher.isMatch(StringUtilities.unquote(browserText))) continue;
            matchingInstances.add(fbt.getFrame());
        }
        return matchingInstances;
    }

    @Override
    protected void select(Object o) {
        if (o instanceof Frame) {
            this._list.setSelectedValue(new FrameWithBrowserText((Frame)o), true);
        } else if (o instanceof FrameWithBrowserText) {
            int ind = ((SimpleListModel)this._list.getModel()).indexOf(o);
            if (ind >= 0) {
                this._list.setSelectedIndex(ind);
            }
        } else {
            this._list.setSelectedIndex(0);
        }
    }
}

