/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;

public class CardinalityFacetRenderer
extends DefaultRenderer {
    private static final long serialVersionUID = 1215855408571379495L;
    private Facet _minCardinalityFacet;
    private Facet _maxCardinalityFacet;

    public CardinalityFacetRenderer(KnowledgeBase kb) {
        this._minCardinalityFacet = kb.getFacet(":MINIMUM-CARDINALITY");
        this._maxCardinalityFacet = kb.getFacet(":MAXIMUM-CARDINALITY");
    }

    private static Integer getFacetValue(Cls cls, Slot slot, Facet facet) {
        return (Integer)CollectionUtilities.getFirstItem(cls.getTemplateFacetValues(slot, facet));
    }

    public void load(Object o) {
        FrameSlotCombination combination = (FrameSlotCombination)o;
        Cls cls = (Cls)combination.getFrame();
        Slot slot = combination.getSlot();
        StringBuffer buffer = new StringBuffer();
        Integer min = CardinalityFacetRenderer.getFacetValue(cls, slot, this._minCardinalityFacet);
        int minValue = 0;
        if (min != null) {
            buffer.append("required ");
            minValue = min;
        }
        Integer max = CardinalityFacetRenderer.getFacetValue(cls, slot, this._maxCardinalityFacet);
        int maxValue = 0;
        if (max == null) {
            buffer.append("multiple");
        } else {
            maxValue = max;
            if (maxValue == 0) {
                buffer.append("none");
            } else if (maxValue == 1) {
                buffer.append("single");
            } else {
                buffer.append("multiple");
            }
        }
        if (minValue > 1 || maxValue > 1) {
            buffer.append("   (");
            buffer.append(minValue);
            buffer.append(":");
            if (maxValue == 0) {
                buffer.append("*");
            } else {
                buffer.append(maxValue);
            }
            buffer.append(")");
        }
        this.setMainText(buffer.toString());
        this.setGrayedText(!cls.isEditable());
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }
}

