/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;

public class ClsInverseRelationshipPanel
extends SelectableContainer {
    private static final long serialVersionUID = -2313695350432734056L;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private Project _project;
    private SelectableList _list;
    private Cls _viewedCls;
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSuperclassAdded(ClsEvent event) {
            ComponentUtilities.addListValue(ClsInverseRelationshipPanel.this._list, event.getSuperclass());
        }

        public void directSuperclassRemoved(ClsEvent event) {
            boolean wasEnabled = ClsInverseRelationshipPanel.this.setNotificationsEnabled(false);
            ComponentUtilities.removeListValue(ClsInverseRelationshipPanel.this._list, event.getSuperclass());
            ClsInverseRelationshipPanel.this.setNotificationsEnabled(wasEnabled);
        }
    };

    public ClsInverseRelationshipPanel(Project p) {
        this._project = p;
        this.setLayout(new BorderLayout());
        this._list = ClsInverseRelationshipPanel.createList();
        String superclassesLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_SUPERCLASSES_LABEL);
        LabeledComponent c = new LabeledComponent(superclassesLabel, ComponentFactory.createScrollPane(this._list));
        this.addHeaderButtons(c);
        this.add(c);
        this.setSelectable(this._list);
        this.setPreferredSize(new Dimension(0, 100));
    }

    protected void addHeaderButtons(LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton(this.getAddParentAction());
        labeledComponent.addHeaderButton(this.getRemoveParentAction());
    }

    private boolean canBeSuperclass(Cls cls) {
        boolean canBeSuperclass = true;
        if (cls == this._viewedCls || cls.hasSuperclass(this._viewedCls) || this._viewedCls.hasSuperclass(cls)) {
            canBeSuperclass = false;
            ModalDialog.showMessageDialog(this, cls.getName() + " can not be a superclass of " + this._viewedCls.getName());
        }
        return canBeSuperclass;
    }

    private static SelectableList createList() {
        SelectableList list = ComponentFactory.createSelectableList(null);
        list.setCellRenderer(FrameRenderer.createInstance());
        return list;
    }

    private void doRemoveSuperclasses(Collection superclasses) {
        for (Cls superclass : superclasses) {
            this._viewedCls.removeDirectSuperclass(superclass);
        }
    }

    private Action getAddParentAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD_SUPERCLASS){
            private static final long serialVersionUID = -3168791335270944513L;

            public void onAdd() {
                if (ClsInverseRelationshipPanel.this._viewedCls != null) {
                    ClsInverseRelationshipPanel.this.addSuperclass();
                }
            }
        };
        return this._addAction;
    }

    private void addSuperclass() {
        KnowledgeBase kb = this.getKnowledgeBase();
        Slot slot = kb.getSystemFrames().getDirectSuperclassesSlot();
        Cls type = this._viewedCls.getDirectType();
        Collection parents = type.getTemplateSlotAllowedParents(slot);
        for (Cls parent : DisplayUtilities.pickClses((Component)this, kb, parents)) {
            if (!this.canBeSuperclass(parent)) continue;
            this._viewedCls.addDirectSuperclass(parent);
        }
    }

    private KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    protected Project getProject() {
        return this._project;
    }

    private Action getRemoveParentAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE_SUPERCLASS, (Selectable)this){
            private static final long serialVersionUID = -1774220070697400829L;

            public void onRemove(Collection values) {
                if (ClsInverseRelationshipPanel.this._viewedCls != null) {
                    ClsInverseRelationshipPanel.this.removeSuperclasses(values);
                }
            }
        };
        return this._removeAction;
    }

    protected Cls getViewedCls() {
        return this._viewedCls;
    }

    public void onSelectionChange() {
        this.updateButtons();
    }

    private void reload() {
        List values = this._viewedCls == null ? Collections.EMPTY_LIST : this._viewedCls.getDirectSuperclasses();
        ComponentUtilities.setListValues(this._list, values);
    }

    private void removeSuperclasses(Collection superclasses) {
        HashSet<Cls> allSuperclasses = new HashSet<Cls>(this._viewedCls.getDirectSuperclasses());
        if (superclasses.size() != allSuperclasses.size()) {
            allSuperclasses.removeAll(superclasses);
            Cls newSelection = CollectionUtilities.getFirstItem(allSuperclasses);
            this.setSelection(newSelection);
            this.doRemoveSuperclasses(superclasses);
        }
    }

    public void setCls(Cls newCls, Cls parent) {
        if (!ClsInverseRelationshipPanel.equals(newCls, this._viewedCls)) {
            if (this._viewedCls != null) {
                this._viewedCls.removeClsListener(this._clsListener);
            }
            this._viewedCls = newCls;
            if (this._viewedCls != null) {
                this._viewedCls.addClsListener(this._clsListener);
            }
            this.reload();
        }
        boolean wasPosting = this.setNotificationsEnabled(false);
        this.setSelection(parent);
        this.setNotificationsEnabled(wasPosting);
        this.updateButtons();
    }

    protected void setSelection(Cls parent) {
        this._list.setSelectedValue(parent, true);
    }

    protected void updateButtons() {
        boolean canModify = this._viewedCls != null && this._viewedCls.isEditable();
        this._addAction.setEnabled(canModify);
        boolean canRemove = canModify && this.getSelection().size() < this._viewedCls.getDirectSuperclassCount();
        this._removeAction.setAllowed(canRemove);
    }
}

