/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.FrameTreeFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClsTreeFinder
extends FrameTreeFinder {
    private static final long serialVersionUID = 4059780789067261580L;

    public ClsTreeFinder(KnowledgeBase kb, JTree tree) {
        this(kb, tree, ResourceKey.CLASS_SEARCH_FOR);
    }

    public ClsTreeFinder(KnowledgeBase kb, JTree tree, ResourceKey key) {
        super(kb, tree, key);
    }

    public ClsTreeFinder(KnowledgeBase kb, JTree tree, String description) {
        this(kb, tree, description, Icons.getFindClsIcon());
    }

    public ClsTreeFinder(KnowledgeBase kb, JTree tree, String description, Icon icon) {
        super(kb, tree, description, icon);
    }

    @Override
    protected Collection getParents(Frame frame) {
        return ((Cls)frame).getDirectSuperclasses();
    }

    @Override
    protected Collection getAncestors(Frame frame) {
        return ((Cls)frame).getSuperclasses();
    }

    @Override
    protected boolean isCorrectType(Frame frame) {
        return frame instanceof Cls;
    }

    @Override
    protected Slot getBrowserSlot(KnowledgeBase kb) {
        Cls cls = kb.getDefaultClsMetaCls();
        Slot slot = cls == null ? kb.getNameSlot() : cls.getBrowserSlotPattern().getFirstSlot();
        return slot;
    }

    @Override
    protected Set<Frame> getMatchingFrames(String text, int maxMatches) {
        if (!text.endsWith("*")) {
            text = text + '*';
        }
        return new HashSet<Frame>(this.getKnowledgeBase().getClsesWithMatchingBrowserText(text, Collections.EMPTY_LIST, maxMatches));
    }
}

