/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ClsReferencersAction;
import edu.stanford.smi.protege.action.CreateClsAction;
import edu.stanford.smi.protege.action.DeleteClsAction;
import edu.stanford.smi.protege.action.ViewClsAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.Transaction;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.RelationshipPane;
import edu.stanford.smi.protege.ui.SubclassPane;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.StandardAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class ClsesPanel
extends SelectableContainer {
    private static final long serialVersionUID = -9219618830969730349L;
    protected Project _project;
    protected LabeledComponent _labeledComponent;
    protected AllowableAction _createAction;
    protected Action _viewAction;
    protected AllowableAction _deleteAction;
    protected SubclassPane _subclassPane;
    protected RelationshipPane _relationshipPane;
    protected HeaderComponent _clsBrowserHeader;
    protected static final String ResourcesKey = null;

    public ClsesPanel(Project project) {
        this._project = project;
        this._viewAction = this.getViewClsAction();
        this._createAction = this.getCreateClsAction();
        this._deleteAction = this.getDeleteClsAction();
        this.createPanes();
        String subclassesLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
        this._labeledComponent = new LabeledComponent(subclassesLabel, this._subclassPane, true);
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this._labeledComponent.addHeaderButton(this._viewAction);
        this._labeledComponent.addHeaderButton(new ClsReferencersAction(this));
        this._labeledComponent.addHeaderButton(this._createAction);
        this._labeledComponent.addHeaderButton(this._deleteAction);
        this._labeledComponent.addHeaderButton(this.createConfigureAction());
        this.add((Component)this._labeledComponent, "Center");
        this.add((Component)this.createClsBrowserHeader(), "North");
        this.setSelectable(this._subclassPane);
        this.updateDeleteActionState();
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    protected HeaderComponent createClsBrowserHeader() {
        JLabel label = ComponentFactory.createLabel(this._project.getName(), Icons.getProjectIcon(), 2);
        String forProject = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        String classBrowser = LocalizedText.getText(ResourceKey.CLASS_BROWSER_TITLE);
        return new HeaderComponent(classBrowser, forProject, label);
    }

    protected void createPanes() {
        this._subclassPane = this.createSubclassPane(this._viewAction, this.getKnowledgeBase().getRootCls(), this._createAction, this._deleteAction);
        this._relationshipPane = this.createRelationshipPane(this._viewAction);
    }

    protected RelationshipPane createRelationshipPane(Action viewAction) {
        return new RelationshipPane(viewAction);
    }

    protected SubclassPane createSubclassPane(Action viewAction, Cls root, Action createAction, Action action) {
        return new SubclassPane(viewAction, root, createAction, action);
    }

    protected void enableButton(AllowableAction action, boolean enabled) {
        if (action != null) {
            action.setAllowed(enabled);
        }
    }

    protected void enableButtons(boolean enable) {
        this.enableButton(this._createAction, enable);
    }

    public JTree getClsesTree() {
        return (JTree)this._subclassPane.getDropComponent();
    }

    protected AllowableAction getCreateClsAction() {
        return new CreateClsAction(){
            private static final long serialVersionUID = 3277804637350225009L;

            public void onCreate() {
                final Collection parents = ClsesPanel.this._subclassPane.getSelection();
                if (!parents.isEmpty()) {
                    Transaction<Cls> t = new Transaction<Cls>(ClsesPanel.this.getKnowledgeBase(), "Create Cls (random name)"){
                        private Cls cls;

                        @Override
                        public boolean doOperations() {
                            this.cls = this.getKnowledgeBase().createCls(null, parents);
                            return true;
                        }

                        @Override
                        public Cls getResult() {
                            return this.cls;
                        }
                    };
                    t.execute();
                    Cls cls = (Cls)t.getResult();
                    ClsesPanel.this._subclassPane.extendSelection(cls);
                }
            }
        };
    }

    protected AllowableAction getDeleteClsAction() {
        DeleteClsAction action = new DeleteClsAction((Selectable)this){
            private static final long serialVersionUID = 6453003201923978685L;

            public void onAboutToDelete(Object o) {
                ClsesPanel.this._subclassPane.removeSelection();
            }

            public void onSelectionChange() {
                ClsesPanel.this.updateDeleteActionState();
            }
        };
        action.setEnabled(true);
        return action;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){
            private static final long serialVersionUID = -6652137114510244586L;

            public void loadPopupMenu(JPopupMenu menu) {
                menu.add(ClsesPanel.this.createShowSubclassesAction());
                menu.add(ClsesPanel.this.createShowAllRelationsAction());
                for (Slot slot : ClsesPanel.this.getRelationSlots()) {
                    menu.add(ClsesPanel.this.createShowRelationAction(slot));
                }
            }
        };
    }

    public Collection getRelationSlots() {
        HashSet<Slot> slots = new HashSet<Slot>();
        Collection c = this.getSelection();
        if (c.size() == 1) {
            Frame selectedFrame = (Frame)c.iterator().next();
            if (selectedFrame instanceof Cls) {
                Cls selectedCls = (Cls)selectedFrame;
                for (Slot slot : selectedCls.getTemplateSlots()) {
                    ValueType type = selectedCls.getTemplateSlotValueType(slot);
                    if (type != ValueType.INSTANCE && type != ValueType.CLS) continue;
                    slots.add(slot);
                }
            }
            for (Slot slot : selectedFrame.getOwnSlots()) {
                ValueType type = selectedFrame.getOwnSlotValueType(slot);
                if (slot.isSystem() || type != ValueType.INSTANCE && type != ValueType.CLS) continue;
                slots.add(slot);
            }
        }
        return slots;
    }

    protected Action createShowSubclassesAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_SHOW_CLASS_HIERARCHY_MENU_ITEM){
            private static final long serialVersionUID = -6053068054586464749L;

            public void actionPerformed(ActionEvent event) {
                ClsesPanel.this._subclassPane.setSelectedClses(ClsesPanel.this.getSelection());
                ClsesPanel.this.loadComponent((Selectable)ClsesPanel.this._subclassPane, ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
                ClsesPanel.this.enableButtons(true);
            }
        };
    }

    protected Action createShowAllRelationsAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_SHOW_ALL_RELATIONS_MENU_ITEM){
            private static final long serialVersionUID = 8492644458387428370L;

            public void actionPerformed(ActionEvent event) {
                ClsesPanel.this._relationshipPane.load((Frame)ClsesPanel.this.getSoleSelection(), null);
                ClsesPanel.this.loadComponent((Selectable)ClsesPanel.this._relationshipPane, ResourceKey.CLASS_BROWSER_ALL_RELATIONS_LABEL);
                ClsesPanel.this.enableButtons(false);
            }
        };
    }

    protected Action createShowRelationAction(final Slot slot) {
        String showLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_SHOW_RELATION_MENU_ITEM, slot.getBrowserText());
        return new StandardAction(showLabel){
            private static final long serialVersionUID = 4732276505377236086L;

            public void actionPerformed(ActionEvent event) {
                ClsesPanel.this._relationshipPane.load((Frame)ClsesPanel.this.getSoleSelection(), slot);
                ClsesPanel.this.loadComponent((Selectable)ClsesPanel.this._relationshipPane, slot.getBrowserText());
                ClsesPanel.this.enableButtons(false);
            }
        };
    }

    protected JComponent getDisplayedComponent() {
        return (JComponent)this._labeledComponent.getCenterComponent();
    }

    public Cls getDisplayParent() {
        return this._subclassPane.getDisplayParent();
    }

    public JComponent getDropComponent() {
        return this._subclassPane.getDropComponent();
    }

    protected KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    public Project getProject() {
        return this._project;
    }

    protected Selectable getRelationshipPane() {
        return this._relationshipPane;
    }

    public Collection getSelection() {
        return ((Selectable)((Object)this.getDisplayedComponent())).getSelection();
    }

    public SubclassPane getSubclassPane() {
        return this._subclassPane;
    }

    protected Action getViewClsAction() {
        return new ViewClsAction((Selectable)this){
            private static final long serialVersionUID = -3017599880497954770L;

            public void onView(Object o) {
                ClsesPanel.this.showInstance((Cls)o);
            }
        };
    }

    protected boolean isDisplayingSubclasses() {
        return this._labeledComponent.getCenterComponent() == this._subclassPane;
    }

    protected void loadComponent(Selectable component) {
        this.loadComponent(component, "");
    }

    protected void loadComponent(Selectable component, ResourceKey key) {
        this.loadComponent(component, LocalizedText.getText(key));
    }

    protected void loadComponent(Selectable component, String title) {
        this._labeledComponent.setCenterComponent((JComponent)((Object)component));
        this._labeledComponent.setHeaderLabel(title);
        this.setSelectable(component);
    }

    private Component getView() {
        return this._labeledComponent.getCenterComponent();
    }

    public void setDisplayParent(Cls cls) {
        if (this.isDisplayingSubclasses()) {
            this._subclassPane.setDisplayParent(cls);
        }
    }

    public void setExpandedCls(Cls cls, boolean expanded) {
        if (this.isDisplayingSubclasses()) {
            this._subclassPane.setExpandedCls(cls, expanded);
        }
    }

    public void setFinderComponent(JComponent c) {
        this._subclassPane.setFinderComponent(c);
    }

    public void setRenderer(DefaultRenderer renderer) {
        this._subclassPane.setRenderer(renderer);
    }

    public void setSelectedCls(Cls cls) {
        if (this.isDisplayingSubclasses()) {
            this._subclassPane.setSelectedCls(cls);
        }
    }

    protected void showInstance(Instance instance) {
        this._project.show(instance);
    }

    protected void updateDeleteActionState() {
        if (this._deleteAction != null) {
            boolean isEditable = true;
            for (Frame frame : this.getSelection()) {
                if (frame.isEditable()) continue;
                isEditable = false;
                break;
            }
            boolean isCorrectView = this.getView() == this._subclassPane;
            this._deleteAction.setAllowed(isEditable && isCorrectView);
        }
    }
}

