/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.TreeTarget;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClsesTreeTarget
extends TreeTarget {
    public ClsesTreeTarget() {
        super(true);
    }

    private static boolean addSuperclass(Cls source, Cls parent) {
        boolean succeeded = false;
        if (parent != source && !parent.hasSuperclass(source) && !source.hasDirectSuperclass(parent)) {
            source.addDirectSuperclass(parent);
            succeeded = true;
        }
        return succeeded;
    }

    public boolean doDrop(JTree tree, Object source, int targetRow, Object area) {
        boolean succeeded = false;
        TreePath path = tree.getPathForRow(targetRow);
        LazyTreeNode targetNode = (LazyTreeNode)path.getLastPathComponent();
        if (source instanceof Cls) {
            succeeded = ClsesTreeTarget.dropCls(tree, targetNode, (Cls)source, area);
        } else if (source instanceof FrameSlotCombination) {
            Slot slot = ((FrameSlotCombination)source).getSlot();
            succeeded = ClsesTreeTarget.dropSlot(tree, targetNode, slot);
        }
        return succeeded;
    }

    private static boolean dropSlot(JTree tree, LazyTreeNode targetNode, Slot sourceSlot) {
        boolean succeeded = false;
        Cls cls = (Cls)targetNode.getUserObject();
        if (!cls.getDirectTemplateSlots().contains(sourceSlot)) {
            cls.addDirectTemplateSlot(sourceSlot);
            succeeded = true;
        }
        return succeeded;
    }

    private static boolean dropCls(JTree tree, LazyTreeNode targetNode, Cls sourceCls, Object area) {
        LazyTreeNode parentNode;
        boolean succeeded = false;
        boolean addedSuperclass = false;
        Cls targetCls = (Cls)targetNode.getUserObject();
        if (area == DefaultRenderer.DROP_TARGET_AREA_ON) {
            parentNode = targetNode;
            addedSuperclass = succeeded = ClsesTreeTarget.addSuperclass(sourceCls, targetCls);
        } else {
            parentNode = sourceCls.hasDirectSuperclass(targetCls) ? targetNode : targetNode.getLazyTreeNodeParent();
            Object parentObject = parentNode.getUserObject();
            if (!(parentObject instanceof Cls)) {
                return false;
            }
            Cls parentCls = (Cls)parentObject;
            boolean isOK = true;
            if (!sourceCls.hasDirectSuperclass(parentCls)) {
                addedSuperclass = isOK = ClsesTreeTarget.addSuperclass(sourceCls, parentCls);
            }
            if (isOK) {
                parentCls.moveDirectSubclass(sourceCls, targetCls);
                succeeded = true;
            }
        }
        if (succeeded) {
            int newIndex = parentNode.getUserObjectIndex(sourceCls);
            TreeNode newNode = parentNode.getChildAt(newIndex);
            ComponentUtilities.setSelectedNode(tree, newNode);
        }
        return succeeded && addedSuperclass;
    }

    public String toString() {
        return "ClsesTreeTarget";
    }
}

