/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.RedoAction;
import edu.stanford.smi.protege.action.UndoAction;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.framestore.undo.Command;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SimpleListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommandHistoryPanel
extends JPanel
implements Disposable {
    private static final long serialVersionUID = -5242899916645126654L;
    private static final String LINE = "------------------------------";
    private static final String INSERT_POINT = "------------------------------ Current Command Position ------------------------------";
    private CommandManager _manager;
    private JList _list;
    private JButton _undoButton;
    private JButton _redoButton;
    private ChangeListener _changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent event) {
            CommandHistoryPanel.this.updateModel();
        }
    };

    public CommandHistoryPanel(CommandManager manager) {
        this._manager = manager;
        this._manager.addChangeListener(this._changeListener);
        this._list = CommandHistoryPanel.createList();
        this._list.setCellRenderer(new CommandRenderer());
        this._undoButton = CommandHistoryPanel.createUndoButton();
        this._redoButton = CommandHistoryPanel.createRedoButton();
        this.layoutWidgets();
        this.setPreferredSize(new Dimension(800, 400));
        this.updateModel();
    }

    public void dispose() {
        this._manager.removeChangeListener(this._changeListener);
    }

    private static JList createList() {
        return ComponentFactory.createList(null);
    }

    private static JButton createRedoButton() {
        JButton button = ComponentFactory.createButton(new RedoAction(true));
        button.setText("Redo");
        return button;
    }

    private static JButton createUndoButton() {
        JButton button = ComponentFactory.createButton(new UndoAction(true));
        button.setText("Undo");
        return button;
    }

    public String getTitle() {
        return "Command History";
    }

    private void layoutWidgets() {
        JPanel innerPane = ComponentFactory.createPanel();
        innerPane.setLayout(new GridLayout(1, 2, 10, 10));
        innerPane.add(this._undoButton);
        innerPane.add(this._redoButton);
        JPanel buttonPane = ComponentFactory.createPanel();
        buttonPane.setLayout(new FlowLayout());
        buttonPane.add(innerPane);
        this.setLayout(new BorderLayout());
        this.add((Component)ComponentFactory.createScrollPane(this._list), "Center");
        this.add((Component)buttonPane, "South");
    }

    private void updateModel() {
        SimpleListModel model = new SimpleListModel();
        model.addValues(this._manager.getDoneCommands());
        model.addValue(INSERT_POINT);
        model.addValues(this._manager.getUndoneCommands());
        this._list.setModel(model);
    }

    private static class CommandRenderer
    extends DefaultRenderer {
        private static final long serialVersionUID = -8428061618792898673L;

        private CommandRenderer() {
        }

        public void load(Object o) {
            if (o instanceof Command) {
                this.setMainText(((Command)o).getDescription());
            } else {
                this.setMainText(o.toString());
            }
        }
    }
}

