/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import java.awt.BorderLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

class ConfigureOptionsPanel
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -4668195683507580909L;
    private Project _project;
    private JCheckBox _hiddenFramesComponent;
    private JCheckBox _confirmOnRemoveComponent;
    private JCheckBox _isEditableComponent;
    private JCheckBox _updateModificationSlotsComponent;
    private JCheckBox _journalingEnabledCheckBox;
    private JCheckBox _prettyPrintSlotWidgetLabelsCheckBox;
    private JCheckBox _tabbedInstanceFormCheckBox;
    private JCheckBox _enableUndoCheckBox;
    private JCheckBox _addNameOnInstanceFormCheckBox;
    private JCheckBox _trackChangesActiveComponent;
    private JCheckBox _suppressInstanceCountDisplayComponent;

    ConfigureOptionsPanel(Project project) {
        this._project = project;
        this.setLayout(new BorderLayout());
        Box c = new Box(1);
        c.add(this.createHiddenClassesComponent());
        c.add(this.createConfirmOnRemoveComponent());
        c.add(this.createIsEditableComponent());
        c.add(this.createUpdateModificationSlotsComponent());
        c.add(this.createChangeTrackingActiveComponent());
        c.add(this.createJournalingEnabledCheckBox());
        c.add(this.createPrettyPrintSlotWidgetLabelsCheckBox());
        c.add(this.createTabbedInstanceFormComponent());
        c.add(this.createEnableUndoCheckBox());
        c.add(this.createNameOnInstanceFormComponent());
        c.add(this.createSuppressInstanceCountingComponent());
        this.add(c);
    }

    private JComponent createEnableUndoCheckBox() {
        this._enableUndoCheckBox = ComponentFactory.createCheckBox();
        this._enableUndoCheckBox.setText("Enable Undo/Redo of operations");
        this._enableUndoCheckBox.setSelected(this._project.isUndoOptionEnabled());
        return this._enableUndoCheckBox;
    }

    private JComponent createJournalingEnabledCheckBox() {
        this._journalingEnabledCheckBox = ComponentFactory.createCheckBox();
        this._journalingEnabledCheckBox.setText("Enable Journaling");
        this._journalingEnabledCheckBox.setSelected(this._project.isJournalingEnabled());
        return this._journalingEnabledCheckBox;
    }

    private JComponent createPrettyPrintSlotWidgetLabelsCheckBox() {
        this._prettyPrintSlotWidgetLabelsCheckBox = ComponentFactory.createCheckBox();
        this._prettyPrintSlotWidgetLabelsCheckBox.setText("Capitalize Slot Widget Labels");
        this._prettyPrintSlotWidgetLabelsCheckBox.setSelected(this._project.getPrettyPrintSlotWidgetLabels());
        return this._prettyPrintSlotWidgetLabelsCheckBox;
    }

    private JComponent createConfirmOnRemoveComponent() {
        this._confirmOnRemoveComponent = ComponentFactory.createCheckBox("Display Confirmation Dialog on 'Remove' Operations");
        ConfigureOptionsPanel.setValue(this._confirmOnRemoveComponent, this._project.getDisplayConfirmationOnRemove());
        return this._confirmOnRemoveComponent;
    }

    private JComponent createHiddenClassesComponent() {
        this._hiddenFramesComponent = ComponentFactory.createCheckBox("Display Hidden Frames");
        ConfigureOptionsPanel.setValue(this._hiddenFramesComponent, this._project.getDisplayHiddenClasses());
        return this._hiddenFramesComponent;
    }

    private JComponent createIsEditableComponent() {
        this._isEditableComponent = ComponentFactory.createCheckBox("Allow Knowledge-Base Changes");
        ConfigureOptionsPanel.setValue(this._isEditableComponent, !this._project.isReadonly());
        return this._isEditableComponent;
    }

    private JComponent createUpdateModificationSlotsComponent() {
        this._updateModificationSlotsComponent = ComponentFactory.createCheckBox("Update modification slots");
        ConfigureOptionsPanel.setValue(this._updateModificationSlotsComponent, this._project.getUpdateModificationSlots());
        return this._updateModificationSlotsComponent;
    }

    private JComponent createChangeTrackingActiveComponent() {
        this._trackChangesActiveComponent = ComponentFactory.createCheckBox("Track changes");
        ConfigureOptionsPanel.setValue(this._trackChangesActiveComponent, this._project.getChangeTrackingActive());
        return this._trackChangesActiveComponent;
    }

    private JComponent createSuppressInstanceCountingComponent() {
        this._suppressInstanceCountDisplayComponent = ComponentFactory.createCheckBox("Suppress Instance Count Display");
        ConfigureOptionsPanel.setValue(this._suppressInstanceCountDisplayComponent, this._project.getSuppressInstanceCounting());
        return this._suppressInstanceCountDisplayComponent;
    }

    private JComponent createTabbedInstanceFormComponent() {
        this._tabbedInstanceFormCheckBox = ComponentFactory.createCheckBox("Used Tabbed Forms for Multi-Type Instances");
        ConfigureOptionsPanel.setValue(this._tabbedInstanceFormCheckBox, this._project.getTabbedInstanceFormLayout());
        return this._tabbedInstanceFormCheckBox;
    }

    private JComponent createNameOnInstanceFormComponent() {
        this._addNameOnInstanceFormCheckBox = ComponentFactory.createCheckBox("Add :NAME Slot on Instance Forms");
        ConfigureOptionsPanel.setValue(this._addNameOnInstanceFormCheckBox, this._project.getAddNameOnInstanceForm());
        return this._addNameOnInstanceFormCheckBox;
    }

    private static boolean getValue(JCheckBox box) {
        return box.isSelected();
    }

    public void saveContents() {
        this._project.setDisplayHiddenClasses(ConfigureOptionsPanel.getValue(this._hiddenFramesComponent));
        this._project.setDisplayConfirmationOnRemove(ConfigureOptionsPanel.getValue(this._confirmOnRemoveComponent));
        this._project.setIsReadonly(!ConfigureOptionsPanel.getValue(this._isEditableComponent));
        this._project.setUpdateModificationSlots(ConfigureOptionsPanel.getValue(this._updateModificationSlotsComponent));
        this._project.setChangeTrackingActive(ConfigureOptionsPanel.getValue(this._trackChangesActiveComponent));
        this._project.setJournalingEnabled(ConfigureOptionsPanel.getValue(this._journalingEnabledCheckBox));
        this._project.setPrettyPrintSlotWidgetLabels(ConfigureOptionsPanel.getValue(this._prettyPrintSlotWidgetLabelsCheckBox));
        this._project.setTabbedInstanceFormLayout(ConfigureOptionsPanel.getValue(this._tabbedInstanceFormCheckBox));
        this._project.setAddNameOnInstanceForm(ConfigureOptionsPanel.getValue(this._addNameOnInstanceFormCheckBox));
        this._project.setUndoOption(ConfigureOptionsPanel.getValue(this._enableUndoCheckBox));
        this._project.setSuppressInstanceCounting(ConfigureOptionsPanel.getValue(this._suppressInstanceCountDisplayComponent));
    }

    private static void setValue(JCheckBox box, boolean value) {
        box.setSelected(value);
    }

    public boolean validateContents() {
        return true;
    }
}

