/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ConfigureOptionsPanel;
import edu.stanford.smi.protege.ui.ConfigureTabsPanel;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.ValidatableTabComponent;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;

public class ConfigureProjectPanel
extends ValidatableTabComponent {
    private static final long serialVersionUID = 7204453275303618585L;
    private static ArrayList userDefinedConfigTabs = new ArrayList();
    private Project _project;

    public ConfigureProjectPanel(Project project) {
        this._project = project;
        this.addTab("Tab Widgets", new ConfigureTabsPanel(project));
        this.addTab("Options", new ConfigureOptionsPanel(project));
        this.addUserDefinedConfigTabs();
    }

    private void addUserDefinedConfigTabs() {
        for (TabNameClsPair tncp : userDefinedConfigTabs) {
            this.addConfigTab(tncp.getTabName(), tncp.getTabClsName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfigTab(String tabName, String tabClassName) {
        Component configTab;
        block25: {
            Class prjClass = SystemUtilities.forName("edu.stanford.smi.protege.model.Project");
            if (prjClass == null) {
                Log.getLogger().warning("Cannot find class Project");
                return;
            }
            Class tabClass = SystemUtilities.forName(tabClassName, true);
            if (tabClass == null) {
                Log.getLogger().warning("Cannot find class: " + tabClassName);
                return;
            }
            configTab = null;
            try {
                Constructor constructor = tabClass.getConstructor(prjClass);
                configTab = (Component)constructor.newInstance(this._project);
            }
            catch (Exception e) {
                if (configTab != null) break block25;
                try {
                    configTab = (Component)tabClass.newInstance();
                }
                catch (Exception e2) {
                }
                finally {
                    if (configTab == null) {
                        Log.getLogger().warning("Cannot initialize constructor for class " + tabClassName);
                    }
                }
            }
            finally {
                if (configTab == null) {
                    try {
                        configTab = (Component)tabClass.newInstance();
                    }
                    catch (Exception e) {
                    }
                    finally {
                        if (configTab == null) {
                            Log.getLogger().warning("Cannot initialize constructor for class " + tabClassName);
                        }
                    }
                }
            }
        }
        if (configTab != null) {
            this.addTab(tabName, configTab);
        }
    }

    public static void registerConfigureTab(String tabTitle, String clsName) {
        userDefinedConfigTabs.add(new TabNameClsPair(tabTitle, clsName));
    }

    public static void unregisterConfigureTab(String configTabName) {
        boolean found = false;
        Iterator iter = userDefinedConfigTabs.iterator();
        while (iter.hasNext() && !found) {
            TabNameClsPair tncp = (TabNameClsPair)iter.next();
            if (!tncp.getTabName().equals(configTabName)) continue;
            userDefinedConfigTabs.remove(tncp);
            found = true;
        }
    }

    static class TabNameClsPair {
        private String _tabName;
        private String _tabClsName;

        public TabNameClsPair(String tabName, String tabClsName) {
            this._tabName = tabName;
            this._tabClsName = tabClsName;
        }

        public String getTabName() {
            return this._tabName;
        }

        public String getTabClsName() {
            return this._tabClsName;
        }
    }
}

