/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.ProtegePropertiesComponent;
import java.awt.BorderLayout;
import java.io.File;
import java.util.Properties;
import javax.swing.JTabbedPane;

public class ConfigureProtegePropertiesPanel
extends AbstractValidatableComponent {
    private static final long serialVersionUID = 1829006876667647966L;
    private final String PROTEGE_LAX_FILE = "Protege.lax";
    private Project _project;
    private ProtegePropertiesComponent _protegeProp;
    private ProtegePropertiesComponent _protegeLax;
    private Properties _copyProtegeProperties;

    public ConfigureProtegePropertiesPanel(Project project) {
        this._project = project;
        this.buildGUI();
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        JTabbedPane _tabbedPane = ComponentFactory.createTabbedPane(true);
        this._copyProtegeProperties = new Properties();
        this.copyProperties(ApplicationProperties.getApplicationProperties(), this._copyProtegeProperties);
        this._protegeProp = new ProtegePropertiesComponent(this._copyProtegeProperties);
        this._protegeProp.setVisibleHeaderButton(this._protegeProp.getLoadAction(), false);
        _tabbedPane.addTab("protege.properties", this._protegeProp);
        File laxFile = this.getLaxFile();
        if (laxFile != null && laxFile.exists()) {
            this._protegeLax = new ProtegePropertiesComponent(laxFile);
            this._protegeLax.setVisibleHeaderButton(this._protegeLax.getLoadAction(), false);
            _tabbedPane.addTab("Protege.lax", this._protegeLax);
        }
        this.add(_tabbedPane);
    }

    private void copyProperties(Properties source, Properties target) {
        target.clear();
        for (String string : source.keySet()) {
            target.setProperty(string, source.getProperty(string));
        }
    }

    private File getLaxFile() {
        File appDir = ApplicationProperties.getApplicationDirectory();
        return new File(appDir, "Protege.lax");
    }

    public void saveContents() {
        this._protegeProp.stopCellEditing();
        if (this._protegeLax != null) {
            this._protegeLax.stopCellEditing();
        }
        this.copyProperties(this._copyProtegeProperties, ApplicationProperties.getApplicationProperties());
        ApplicationProperties.flush();
        File laxFile = this.getLaxFile();
        if (this._protegeLax != null && laxFile != null && laxFile.exists()) {
            this._protegeLax.savePropertyFile(laxFile, true);
        }
    }

    public boolean validateContents() {
        return true;
    }
}

