/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.CheckBoxRenderer;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protege.widget.WidgetDescriptorRenderer;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

class ConfigureTabsPanel
extends AbstractValidatableComponent {
    private static final long serialVersionUID = 230283792426972639L;
    private JTable _table;
    private Project _project;
    private boolean _dirty;

    private boolean canMoveUp(int index) {
        return index > 0 && this.isEnabled(index);
    }

    private boolean canMoveDown(int index) {
        boolean canMoveDown;
        boolean bl = canMoveDown = 0 <= index && index < this._table.getRowCount() - 1;
        if (canMoveDown) {
            canMoveDown = this.isEnabled(index) && this.canEnable(index + 1);
        }
        return canMoveDown;
    }

    private boolean isEnabled(int row) {
        Boolean b = (Boolean)this.getTabModel().getValueAt(row, 0);
        return b;
    }

    private void setEnabled(int row, boolean enabled) {
        this.getTabModel().setValueAt(enabled, row, 0);
    }

    private boolean isEditable(int row) {
        WidgetDescriptor d = this.getDescriptor(row);
        ArrayList strings = new ArrayList();
        return WidgetUtilities.isSuitableTab(d.getWidgetClassName(), this._project, strings);
    }

    protected ConfigureTabsPanel(Project project) {
        this.setLayout(new BorderLayout());
        this._project = project;
        this._table = ComponentFactory.createTable(this.getConfigureAction());
        this._table.setModel(this.createTableModel());
        ComponentUtilities.addColumn(this._table, new WidgetDescriptorEnableRenderer());
        this._table.getColumnModel().getColumn(0).setMaxWidth(50);
        ComponentUtilities.addColumn(this._table, new WidgetDescriptorRenderer(project));
        this._table.addMouseListener(new ClickListener());
        JScrollPane pane = ComponentFactory.createScrollPane(this._table);
        pane.setColumnHeaderView(this._table.getTableHeader());
        pane.setBackground(this._table.getBackground());
        LabeledComponent c = new LabeledComponent("Tabs", pane);
        c.addHeaderButton(new MoveTabUp());
        c.addHeaderButton(new MoveTabDown());
        this.add(c);
    }

    private TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Visible");
        model.addColumn("Tab Widget");
        boolean all = true;
        Collection<WidgetDescriptor> tabDescriptors = new ArrayList<WidgetDescriptor>(this._project.getTabWidgetDescriptors());
        tabDescriptors = this.sort(tabDescriptors);
        for (WidgetDescriptor d : tabDescriptors) {
            if (!all && !this.canEnable(d)) continue;
            model.addRow(new Object[]{d.isVisible(), d});
        }
        return model;
    }

    private Collection sort(Collection descriptors) {
        WidgetDescriptor d;
        ArrayList sortedDescriptors = new ArrayList(descriptors);
        for (int i = 0; i < sortedDescriptors.size() && (d = (WidgetDescriptor)sortedDescriptors.get(i)).isVisible(); ++i) {
        }
        Collections.sort(sortedDescriptors, new WidgetDescriptorComparator());
        return sortedDescriptors;
    }

    private Action getConfigureAction() {
        return new AbstractAction("Configure"){
            private static final long serialVersionUID = 900646780807779030L;

            public void actionPerformed(ActionEvent event) {
                int row = ConfigureTabsPanel.this._table.getSelectedRow();
                WidgetDescriptor d = ConfigureTabsPanel.this.getDescriptor(row);
                if (d.isVisible()) {
                    TabWidget widget = ProjectManager.getProjectManager().getCurrentProjectView().getTabByClassName(d.getWidgetClassName());
                    widget.configure();
                }
            }
        };
    }

    private DefaultTableModel getTabModel() {
        return (DefaultTableModel)this._table.getModel();
    }

    public void saveContents() {
        if (this._dirty) {
            ArrayList<WidgetDescriptor> tabWidgetDescriptors = new ArrayList<WidgetDescriptor>();
            for (int row = 0; row < this.getTabModel().getRowCount(); ++row) {
                boolean isEnabled = this.isEnabled(row);
                WidgetDescriptor descriptor = this.getDescriptor(row);
                descriptor.setVisible(isEnabled);
                tabWidgetDescriptors.add(descriptor);
            }
            this._project.setTabWidgetDescriptorOrder(tabWidgetDescriptors);
        }
    }

    public boolean validateContents() {
        return true;
    }

    private boolean canEnable(String className) {
        return WidgetUtilities.isSuitableTab(className, this._project, new ArrayList());
    }

    private WidgetDescriptor getDescriptor(int row) {
        return (WidgetDescriptor)this.getTabModel().getValueAt(row, 1);
    }

    private boolean canEnable(int row) {
        WidgetDescriptor d = this.getDescriptor(row);
        return this.canEnable(d);
    }

    private boolean canEnable(WidgetDescriptor d) {
        return this.canEnable(d.getWidgetClassName());
    }

    class WidgetDescriptorEnableRenderer
    extends CheckBoxRenderer {
        private static final long serialVersionUID = 6693202760974205518L;
        private final Component EMPTY = new JPanel(){
            private static final long serialVersionUID = -2060692706529621224L;

            public boolean isOpaque() {
                return false;
            }
        };

        WidgetDescriptorEnableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean b, int row, int col) {
            Component c = ConfigureTabsPanel.this.canEnable(row) ? super.getTableCellRendererComponent(table, value, isSelected, b, row, col) : this.EMPTY;
            return c;
        }
    }

    class WidgetDescriptorComparator
    implements Comparator {
        WidgetDescriptorComparator() {
        }

        public int compare(Object o1, Object o2) {
            int compare;
            WidgetDescriptor wd1 = (WidgetDescriptor)o1;
            WidgetDescriptor wd2 = (WidgetDescriptor)o2;
            boolean isEnabled1 = wd1.isVisible();
            boolean isEnabled2 = wd2.isVisible();
            if (isEnabled1) {
                compare = isEnabled2 ? 0 : -1;
            } else {
                int n = compare = isEnabled2 ? 1 : 0;
            }
            if (!isEnabled1 && !isEnabled2) {
                String n1 = wd1.getWidgetClassName();
                String n2 = wd2.getWidgetClassName();
                boolean canEnable1 = ConfigureTabsPanel.this.canEnable(n1);
                boolean canEnable2 = ConfigureTabsPanel.this.canEnable(n2);
                if (canEnable1) {
                    compare = canEnable2 ? 0 : -1;
                } else {
                    int n = compare = canEnable2 ? 1 : 0;
                }
                if (compare == 0) {
                    String sn1 = StringUtilities.getShortClassName(n1);
                    String sn2 = StringUtilities.getShortClassName(n2);
                    compare = sn1.compareToIgnoreCase(sn2);
                }
            }
            return compare;
        }
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        public void mousePressed(MouseEvent event) {
            int row;
            Point p = event.getPoint();
            int col = ConfigureTabsPanel.this._table.columnAtPoint(p);
            if (col == 0 && ConfigureTabsPanel.this.isEditable(row = ConfigureTabsPanel.this._table.rowAtPoint(p))) {
                boolean b = ConfigureTabsPanel.this.isEnabled(row);
                ConfigureTabsPanel.this.setEnabled(row, !b);
                ConfigureTabsPanel.this._dirty = true;
            }
        }
    }

    private class MoveTabDown
    extends AbstractAction {
        private static final long serialVersionUID = -7034589703352346373L;

        MoveTabDown() {
            super("Move selected tab down", Icons.getDownIcon());
        }

        public void actionPerformed(ActionEvent event) {
            int index = ConfigureTabsPanel.this._table.getSelectedRow();
            if (ConfigureTabsPanel.this.canMoveDown(index)) {
                ConfigureTabsPanel.this.getTabModel().moveRow(index, index, index + 1);
                int n = index + 1;
                ConfigureTabsPanel.this._table.getSelectionModel().setSelectionInterval(n, n);
                ConfigureTabsPanel.this._dirty = true;
            }
        }
    }

    private class MoveTabUp
    extends AbstractAction {
        private static final long serialVersionUID = 5052392705264419616L;

        MoveTabUp() {
            super("Move selected tab up", Icons.getUpIcon());
        }

        public void actionPerformed(ActionEvent event) {
            int index = ConfigureTabsPanel.this._table.getSelectedRow();
            if (ConfigureTabsPanel.this.canMoveUp(index)) {
                ConfigureTabsPanel.this.getTabModel().moveRow(index, index, index - 1);
                int n = index - 1;
                ConfigureTabsPanel.this._table.getSelectionModel().setSelectionInterval(n, n);
                ConfigureTabsPanel.this._dirty = true;
            }
        }
    }
}

