/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.MakeCopiesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.ui.MultiSlotPanel;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ConcurrentListModel;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectInstancesList
extends SelectableContainer
implements Disposable {
    private static final long serialVersionUID = 3123829893591425192L;
    public static final String SORT_LIMIT_PROPERTY = "ui.DirectInstancesList.sort_limit";
    public static final int SORT_LIMIT = ApplicationProperties.getIntegerProperty("ui.DirectInstancesList.sort_limit", 1000);
    private Collection<Cls> _clses = Collections.EMPTY_LIST;
    private SelectableList _list;
    private Project _project;
    private AllowableAction _createAction;
    private AllowableAction _copyAction;
    private AllowableAction _deleteAction;
    private HeaderComponent _header;
    private boolean _showSubclassInstances;
    private LabeledComponent _labeledComponent;
    private AddInstancesRunner background;
    private ClsListener _clsListener = new ClsAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void directInstanceAdded(ClsEvent event) {
            DirectInstancesList directInstancesList = DirectInstancesList.this;
            synchronized (directInstancesList) {
                if (DirectInstancesList.this.background != null && !event.isReplacementEvent()) {
                    DirectInstancesList.this.background.setDeferredSelection(event.getInstance());
                    DirectInstancesList.this.background.addChange(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void directInstanceRemoved(ClsEvent event) {
            DirectInstancesList directInstancesList = DirectInstancesList.this;
            synchronized (directInstancesList) {
                if (DirectInstancesList.this.background != null && !event.isReplacementEvent()) {
                    DirectInstancesList.this.background.addChange(event);
                }
            }
        }
    };
    private FrameListener _clsFrameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            super.ownSlotValueChanged(event);
            DirectInstancesList.this.background.addChange(event);
        }
    };
    private KnowledgeBaseListener kbListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent event) {
            Instance inst = (Instance)event.getNewFrame();
            Collection types = inst.getDirectTypes();
            for (Cls type : types) {
                if (!DirectInstancesList.this._clses.contains(type)) continue;
                DirectInstancesList.this.background.addChange(event);
                return;
            }
        }
    };

    public DirectInstancesList(Project project) {
        this._project = project;
        Action viewAction = this.createViewAction();
        this._list = ComponentFactory.createSelectableList(viewAction);
        this._list.setCellRenderer(FrameRenderer.createInstance());
        this._list.setModel(new ConcurrentListModel());
        this._labeledComponent = new LabeledComponent(null, ComponentFactory.createScrollPane(this._list));
        this.addButtons(viewAction, this._labeledComponent);
        this._labeledComponent.setFooterComponent(new ListFinder((JList)this._list, ResourceKey.INSTANCE_SEARCH_FOR));
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)this._labeledComponent, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createHeader(), "North");
        this.add((Component)panel, "North");
        this.setSelectable(this._list);
        this._project.getKnowledgeBase().addKnowledgeBaseListener(this.kbListener);
    }

    private void updateLabel() {
        BrowserSlotPattern pattern;
        Cls cls = this.getSoleAllowedCls();
        BrowserSlotPattern browserSlotPattern = pattern = cls == null ? null : cls.getBrowserSlotPattern();
        String text = pattern == null ? null : (pattern.isSimple() ? pattern.getFirstSlot().getBrowserText() : "multiple slots");
        this._labeledComponent.setHeaderLabel(text);
    }

    private HeaderComponent createHeader() {
        JLabel label = ComponentFactory.createLabel();
        String instanceBrowserLabel = LocalizedText.getText(ResourceKey.INSTANCE_BROWSER_TITLE);
        String forClassLabel = LocalizedText.getText(ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this._header = new HeaderComponent(instanceBrowserLabel, forClassLabel, label);
        this._header.setColor(Colors.getInstanceColor());
        return this._header;
    }

    private void fixRenderer() {
        FrameRenderer frameRenderer = (FrameRenderer)this._list.getCellRenderer();
        frameRenderer.setDisplayType(this._showSubclassInstances);
    }

    protected void addButtons(Action viewAction, LabeledComponent c) {
        c.addHeaderButton(viewAction);
        c.addHeaderButton(this.createReferencersAction());
        c.addHeaderButton(this.createCreateAction());
        c.addHeaderButton(this.createCopyAction());
        c.addHeaderButton(this.createDeleteAction());
        c.addHeaderButton(this.createConfigureAction());
    }

    private void addClsListeners() {
        for (Cls cls : this._clses) {
            cls.addClsListener(this._clsListener);
            cls.addFrameListener(this._clsFrameListener);
        }
    }

    protected Action createCreateAction() {
        this._createAction = new CreateAction(ResourceKey.INSTANCE_CREATE){
            private static final long serialVersionUID = -7153511943330887472L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCreate() {
                if (!DirectInstancesList.this._clses.isEmpty()) {
                    Cls newCls;
                    KnowledgeBase kb = DirectInstancesList.this._project.getKnowledgeBase();
                    Instance instance = kb.createInstance(null, DirectInstancesList.this._clses);
                    if (instance instanceof Cls && (newCls = (Cls)instance).getDirectSuperclassCount() == 0) {
                        newCls.addDirectSuperclass(kb.getRootCls());
                    }
                    DirectInstancesList directInstancesList = DirectInstancesList.this;
                    synchronized (directInstancesList) {
                        if (DirectInstancesList.this.background != null) {
                            DirectInstancesList.this.background.setDeferredSelection(instance);
                        }
                    }
                }
            }
        };
        return this._createAction;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){
            private static final long serialVersionUID = -201941911745358583L;

            public void loadPopupMenu(JPopupMenu menu) {
                menu.add(DirectInstancesList.this.createSetDisplaySlotAction());
                menu.add(DirectInstancesList.this.createShowAllInstancesAction());
            }
        };
    }

    protected JMenuItem createShowAllInstancesAction() {
        AbstractAction action = new AbstractAction("Show Subclass Instances"){
            private static final long serialVersionUID = -5993246896156508981L;

            public void actionPerformed(ActionEvent event) {
                DirectInstancesList.this.setShowAllInstances(!DirectInstancesList.this._showSubclassInstances);
            }
        };
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.setSelected(this._showSubclassInstances);
        return item;
    }

    private void setShowAllInstances(boolean b) {
        this._showSubclassInstances = b;
        this.reload();
        this.fixRenderer();
    }

    protected Cls getSoleAllowedCls() {
        Cls cls = this._clses.size() == 1 ? CollectionUtilities.getFirstItem(this._clses) : null;
        return cls;
    }

    protected JMenu createSetDisplaySlotAction() {
        JMenu menu = ComponentFactory.createMenu("Set Display Slot");
        boolean enabled = false;
        Cls cls = this.getSoleAllowedCls();
        if (cls != null) {
            BrowserSlotPattern pattern = cls.getBrowserSlotPattern();
            Slot browserSlot = pattern != null && pattern.isSimple() ? pattern.getFirstSlot() : null;
            for (Slot slot : cls.getVisibleTemplateSlots()) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.createSetDisplaySlotAction(slot));
                if (slot.equals(browserSlot)) {
                    item.setSelected(true);
                }
                menu.add(item);
                enabled = true;
            }
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.createSetDisplaySlotMultipleAction());
            if (browserSlot == null) {
                item.setSelected(true);
            }
            menu.add(item);
        }
        menu.setEnabled(enabled);
        return menu;
    }

    protected Action createSetDisplaySlotAction(final Slot slot) {
        return new AbstractAction(slot.getBrowserText(), slot.getIcon()){
            private static final long serialVersionUID = 8128282947095201947L;

            public void actionPerformed(ActionEvent event) {
                DirectInstancesList.this.getSoleAllowedCls().setDirectBrowserSlot(slot);
                DirectInstancesList.this.updateLabel();
                DirectInstancesList.this.repaint();
            }
        };
    }

    protected Action createSetDisplaySlotMultipleAction() {
        return new AbstractAction("Multiple Slots..."){
            private static final long serialVersionUID = 7430434198286882076L;

            public void actionPerformed(ActionEvent event) {
                BrowserSlotPattern pattern;
                Cls cls = DirectInstancesList.this.getSoleAllowedCls();
                BrowserSlotPattern currentPattern = DirectInstancesList.this.getSoleAllowedCls().getBrowserSlotPattern();
                MultiSlotPanel panel = new MultiSlotPanel(currentPattern, cls);
                int rval = ModalDialog.showDialog(DirectInstancesList.this, panel, "Multislot Display Pattern", 11);
                if (rval == 1 && (pattern = panel.getBrowserTextPattern()) != null) {
                    cls.setDirectBrowserSlotPattern(pattern);
                }
                DirectInstancesList.this.updateLabel();
                DirectInstancesList.this.repaint();
            }
        };
    }

    protected Action createDeleteAction() {
        this._deleteAction = new DeleteInstancesAction(this);
        return this._deleteAction;
    }

    protected Action createCopyAction() {
        this._copyAction = new MakeCopiesAction(ResourceKey.INSTANCE_COPY, (Selectable)this){
            private static final long serialVersionUID = -3162114702044458484L;

            protected Instance copy(Instance instance, boolean isDeep) {
                Instance copy = super.copy(instance, isDeep);
                DirectInstancesList.this.setSelectedInstance(copy);
                return copy;
            }
        };
        return this._copyAction;
    }

    protected Action createReferencersAction() {
        return new ReferencersAction(ResourceKey.INSTANCE_VIEW_REFERENCES, (Selectable)this);
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){
            private static final long serialVersionUID = -521270402099135685L;

            public void onView(Object o) {
                DirectInstancesList.this._project.show((Instance)o);
            }
        };
    }

    @Override
    public void dispose() {
        this.removeClsListeners();
        this._project.getKnowledgeBase().removeKnowledgeBaseListener(this.kbListener);
        if (this.background != null) {
            this.background.cancel();
            this.background = null;
        }
    }

    public JComponent getDragComponent() {
        return this._list;
    }

    private ConcurrentListModel getModel() {
        return (ConcurrentListModel)this._list.getModel();
    }

    private boolean isSelectionEditable() {
        boolean isEditable = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            isEditable = false;
            break;
        }
        return isEditable;
    }

    @Override
    public void onSelectionChange() {
        boolean editable = this.isSelectionEditable();
        ComponentUtilities.setDragAndDropEnabled(this._list, editable);
        this.updateButtons();
    }

    private void removeClsListeners() {
        for (Cls cls : this._clses) {
            cls.removeClsListener(this._clsListener);
            cls.removeFrameListener(this._clsFrameListener);
        }
    }

    public void setClses(Collection<Cls> newClses) {
        this.removeClsListeners();
        this._clses = new ArrayList<Cls>(newClses);
        this.reload();
        this.updateButtons();
        this.addClsListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        DirectInstancesList directInstancesList = this;
        synchronized (directInstancesList) {
            if (this.background != null) {
                this.background.cancel();
                this.background = null;
            }
        }
        Object selectedValue = this._list.getSelectedValue();
        LinkedHashSet<Instance> instanceSet = new LinkedHashSet<Instance>();
        for (Cls cls : this._clses) {
            instanceSet.addAll(this.getInstances(cls));
        }
        this.getModel().clear();
        DirectInstancesList directInstancesList2 = this;
        synchronized (directInstancesList2) {
            if (this.background != null) {
                this.background.cancel();
            }
            this.background = new AddInstancesRunner(new ArrayList<Instance>(instanceSet));
            Thread th = new Thread((Runnable)this.background, "Calculate Instances For Panel");
            th.start();
            if (instanceSet.contains(selectedValue) && selectedValue instanceof Instance) {
                this.background.setDeferredSelection((Instance)selectedValue);
            }
        }
        if (!instanceSet.isEmpty()) {
            this._list.setSelectedIndex(0);
        }
        this.reloadHeader(this._clses);
        this.updateLabel();
    }

    private void reloadHeader(Collection<Cls> clses) {
        StringBuffer text = new StringBuffer();
        Icon icon = null;
        for (Cls cls : clses) {
            if (icon == null) {
                icon = cls.getIcon();
            }
            if (text.length() != 0) {
                text.append(", ");
            }
            text.append(cls.getName());
        }
        JLabel label = (JLabel)this._header.getComponent();
        label.setText(text.toString());
        label.setIcon(icon);
    }

    private Collection<Instance> getInstances(Cls cls) {
        Collection<Instance> instances = this._showSubclassInstances ? cls.getInstances() : cls.getDirectInstances();
        if (!this._project.getDisplayHiddenFrames()) {
            instances = DirectInstancesList.removeHiddenInstances(instances);
        }
        return instances;
    }

    private static Collection<Instance> removeHiddenInstances(Collection<Instance> instances) {
        ArrayList<Instance> visibleInstances = new ArrayList<Instance>(instances);
        Iterator i = visibleInstances.iterator();
        while (i.hasNext()) {
            Instance instance = (Instance)i.next();
            if (instance.isVisible()) continue;
            i.remove();
        }
        return visibleInstances;
    }

    public synchronized void setSelectedInstance(Instance instance) {
        if (this.background != null && !this.getModel().contains(instance)) {
            this.background.setDeferredSelection(instance);
        } else {
            this._list.setSelectedValue(instance);
        }
    }

    private void updateButtons() {
        Cls cls = CollectionUtilities.getFirstItem(this._clses);
        this._createAction.setEnabled(cls == null ? false : cls.isConcrete());
        Instance instance = (Instance)this.getSoleSelection();
        boolean allowed = instance != null && instance instanceof SimpleInstance;
        this._copyAction.setAllowed(allowed);
    }

    public void setListRenderer(ListCellRenderer renderer) {
        this._list.setCellRenderer(renderer);
        if (renderer instanceof FrameRenderer) {
            ((FrameRenderer)renderer).setDisplayType(this._showSubclassInstances);
        }
    }

    @Deprecated
    public void setShowDisplaySlotPanel(boolean b) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddInstancesRunner
    implements Runnable {
        private List<Instance> instances;
        private List<AbstractEvent> changes = new ArrayList<AbstractEvent>();
        private Instance deferredSelection;
        private boolean sorted;
        private boolean cancelled = false;

        public AddInstancesRunner(List<Instance> instances) {
            this.instances = instances;
            this.sorted = SORT_LIMIT < 0 || instances.size() < SORT_LIMIT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                this.waitToProcessEvents();
                this.addOneInstance(this.getNextInstance());
                AddInstancesRunner addInstancesRunner = this;
                synchronized (addInstancesRunner) {
                    if (this.cancelled) {
                        return;
                    }
                }
                this.handleChanges();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitToProcessEvents() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (InterruptedException e) {
                Log.getLogger().log(Level.SEVERE, "Interrupt caught - why?", e);
            }
            catch (InvocationTargetException e) {
                Log.getLogger().log(Level.SEVERE, "Programmer error", e);
            }
            AddInstancesRunner addInstancesRunner = this;
            synchronized (addInstancesRunner) {
                if (this.instances.isEmpty() && !this.cancelled && this.changes.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Log.getLogger().log(Level.SEVERE, "Interrupted thread - why?", e);
                    }
                }
            }
        }

        private void addOneInstance(final Instance instance) {
            if (instance == null) {
                return;
            }
            if (!DirectInstancesList.this.getModel().contains(instance)) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (!AddInstancesRunner.this.cancelled) {
                                AddInstancesRunner.this.insertInstanceInList(instance);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught talking to swing", e);
                }
                catch (InvocationTargetException e) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught talking to swing", e);
                }
            }
        }

        private synchronized Instance getNextInstance() {
            if (this.instances.isEmpty() || this.cancelled) {
                return null;
            }
            Instance instance = this.instances.get(0);
            this.instances.remove(0);
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleChanges() {
            Instance localDeferredSelection;
            boolean noChanges;
            final ArrayList<AbstractEvent> localChanges = new ArrayList<AbstractEvent>();
            AddInstancesRunner addInstancesRunner = this;
            synchronized (addInstancesRunner) {
                noChanges = this.changes.isEmpty();
                localChanges.addAll(this.changes);
                this.changes.clear();
                localDeferredSelection = this.deferredSelection;
                this.deferredSelection = null;
            }
            if (!noChanges || localDeferredSelection != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (AddInstancesRunner.this.cancelled) {
                                return;
                            }
                            for (AbstractEvent event : localChanges) {
                                KnowledgeBaseEvent kbEvent;
                                if (event instanceof ClsEvent) {
                                    ClsEvent clsEvent = (ClsEvent)event;
                                    if (clsEvent.getEventType() == 305) {
                                        Instance instance = clsEvent.getInstance();
                                        AddInstancesRunner.this.insertInstanceInList(instance);
                                        AddInstancesRunner.this.instances.remove(instance);
                                        continue;
                                    }
                                    if (clsEvent.getEventType() != 306) continue;
                                    Instance instance = clsEvent.getInstance();
                                    DirectInstancesList.this.getModel().removeValue(instance);
                                    AddInstancesRunner.this.instances.remove(instance);
                                    continue;
                                }
                                if (event instanceof FrameEvent) {
                                    FrameEvent frameEvent = (FrameEvent)event;
                                    Frame frame = frameEvent.getFrame();
                                    if (frameEvent.getEventType() != 110 || !DirectInstancesList.this.getModel().contains(frame) || !(frame instanceof Instance)) continue;
                                    DirectInstancesList.this.getModel().removeValue(frame);
                                    DirectInstancesList.this.updateButtons();
                                    continue;
                                }
                                if (!(event instanceof KnowledgeBaseEvent) || (kbEvent = (KnowledgeBaseEvent)event).getEventType() != 101) continue;
                                boolean selected = DirectInstancesList.this._list.getSelection().contains(kbEvent.getFrame()) && localDeferredSelection == null;
                                AddInstancesRunner.this.instances.remove(kbEvent.getFrame());
                                DirectInstancesList.this.getModel().removeValue(kbEvent.getFrame());
                                AddInstancesRunner.this.insertInstanceInList((Instance)kbEvent.getNewFrame());
                                if (!selected) continue;
                                DirectInstancesList.this._list.setSelectedValue(kbEvent.getNewFrame());
                            }
                            if (localDeferredSelection != null) {
                                if (AddInstancesRunner.this.instances.contains(localDeferredSelection)) {
                                    AddInstancesRunner.this.insertInstanceInList(localDeferredSelection);
                                    AddInstancesRunner.this.instances.remove(localDeferredSelection);
                                }
                                DirectInstancesList.this._list.setSelectedValue(localDeferredSelection, true);
                                DirectInstancesList.this.updateButtons();
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    Log.getLogger().log(Level.SEVERE, "Interrupted Thread - why?", e);
                }
                catch (InvocationTargetException e) {
                    Log.getLogger().log(Level.WARNING, "Exception processing updates to instance list", e);
                }
            }
        }

        private void insertInstanceInList(Instance instance) {
            if (this.sorted) {
                List list = DirectInstancesList.this.getModel().toList();
                int index = Collections.binarySearch(list, instance, new FrameComparator());
                if (index >= 0) {
                    DirectInstancesList.this.getModel().addValue(instance, index);
                } else if (index < 0) {
                    DirectInstancesList.this.getModel().addValue(instance, -index - 1);
                }
            } else {
                DirectInstancesList.this.getModel().addValue(instance);
            }
        }

        public synchronized void addChange(AbstractEvent event) {
            if (event.isReplacementEvent() && event.getEventType() != 101) {
                return;
            }
            this.changes.add(event);
            this.notifyAll();
        }

        public synchronized void setDeferredSelection(Instance instance) {
            this.deferredSelection = instance;
        }

        public synchronized void cancel() {
            this.cancelled = true;
            this.notifyAll();
        }
    }
}

