/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;

public class DirectTypesList
extends SelectableContainer {
    private static final long serialVersionUID = 3753480292661208200L;
    private SelectableList list;
    private Instance instance;
    private KnowledgeBase knowledgeBase;
    private AbstractAction addAction;
    private InstanceListener instanceListener = new InstanceListener(){

        public void directTypeAdded(InstanceEvent event) {
            ComponentUtilities.addListValue(DirectTypesList.this.list, event.getCls());
        }

        public void directTypeRemoved(InstanceEvent event) {
            ComponentUtilities.removeListValue(DirectTypesList.this.list, event.getCls());
        }
    };

    public DirectTypesList(Project project) {
        this.knowledgeBase = project.getKnowledgeBase();
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setCellRenderer(new FrameRenderer());
        this.setSelectable(this.list);
        LabeledComponent c = new LabeledComponent("Types", new JScrollPane(this.list));
        c.addHeaderButton(this.createAddTypeAction());
        c.addHeaderButton(this.createRemoteTypeAction());
        this.setLayout(new BorderLayout());
        this.add(c);
        this.setPreferredSize(new Dimension(0, 100));
        this.list.setDragEnabled(true);
        this.list.setTransferHandler(new FrameTransferHandler());
    }

    public void setInstance(Instance newInstance) {
        if (this.instance != null) {
            this.instance.removeInstanceListener(this.instanceListener);
        }
        this.instance = newInstance;
        if (this.instance != null) {
            this.instance.addInstanceListener(this.instanceListener);
        }
        this.updateModel();
        this.updateAddButton();
    }

    public void updateModel() {
        AbstractListModel model;
        if (this.instance == null) {
            model = new DefaultListModel();
        } else {
            Collection types = this.instance.getDirectTypes();
            model = new SimpleListModel(types);
        }
        this.list.setModel(model);
    }

    public void updateAddButton() {
        this.addAction.setEnabled(this.instance != null);
    }

    private Action createAddTypeAction() {
        this.addAction = new AddAction(ResourceKey.CLASS_ADD){
            private static final long serialVersionUID = -7607219183090478296L;

            public void onAdd() {
                Collection clses = DisplayUtilities.pickClses((Component)DirectTypesList.this, DirectTypesList.this.knowledgeBase);
                for (Cls cls : clses) {
                    if (DirectTypesList.this.instance.hasType(cls)) continue;
                    DirectTypesList.this.instance.addDirectType(cls);
                }
            }
        };
        return this.addAction;
    }

    private Action createRemoteTypeAction() {
        return new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this.list){
            private static final long serialVersionUID = 4441015930033207570L;

            public void onRemove(Object o) {
                Cls cls = (Cls)o;
                DirectTypesList.this.instance.removeDirectType(cls);
            }
        };
    }

    private class FrameTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 4409217176875767828L;

        private FrameTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            Collection collection = DirectTypesList.this.getSelection();
            return collection.isEmpty() ? null : new TransferableCollection(collection);
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return true;
        }

        public boolean importData(JComponent component, Transferable data) {
            return true;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                for (Cls type : DirectTypesList.this.getSelection()) {
                    int index = 0;
                    Log.getLogger().info("Move " + type + " to: " + index);
                    DirectTypesList.this.instance.moveDirectType(type, index);
                    DirectTypesList.this.updateModel();
                }
            }
        }

        public int getSourceActions(JComponent c) {
            return 2;
        }
    }
}

