/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.EditStringPanel;
import edu.stanford.smi.protege.ui.FormRenderer;
import edu.stanford.smi.protege.ui.PickSymbolPanel;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.SelectClsesPanel;
import edu.stanford.smi.protege.ui.SelectInstanceFromCollectionPanel;
import edu.stanford.smi.protege.ui.SelectInstancesFromCollectionPanel;
import edu.stanford.smi.protege.ui.SelectInstancesPanel;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validator;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ListCellRenderer;

public class DisplayUtilities {
    public static String editString(final Component component, String label, Object startValue, final Validator validator) {
        final EditStringPanel panel = new EditStringPanel(startValue, label);
        ModalDialog.CloseCallback callback = new ModalDialog.CloseCallback(){

            public boolean canClose(int result) {
                boolean canClose;
                if (result == 1 && validator != null) {
                    String text = panel.getText();
                    canClose = validator.isValid(text);
                    if (!canClose) {
                        ModalDialog.showMessageDialog(component, validator.getErrorMessage(text));
                    }
                } else {
                    canClose = true;
                }
                return canClose;
            }
        };
        String endValue = startValue == null ? null : startValue.toString();
        int result = ModalDialog.showDialog(component, panel, label, 11, callback);
        if (result == 1) {
            endValue = panel.getText();
        }
        return endValue;
    }

    private static Collection getFirstTwoConcreteClses(KnowledgeBase kb, Collection allowedClses) {
        HashSet concreteClses = new HashSet();
        if (allowedClses.isEmpty()) {
            allowedClses = kb.getRootClses();
        }
        DisplayUtilities.getFirstTwoConcreteClses(allowedClses, concreteClses);
        return concreteClses;
    }

    private static void getFirstTwoConcreteClses(Collection allowedClses, Collection concreteClses) {
        Iterator i = allowedClses.iterator();
        while (i.hasNext() && concreteClses.size() != 2) {
            Cls cls = (Cls)i.next();
            if (cls.isConcrete()) {
                concreteClses.add(cls);
                if (concreteClses.size() == 2) break;
            }
            DisplayUtilities.getFirstTwoConcreteClses(cls.getDirectSubclasses(), concreteClses);
        }
    }

    public static boolean hasMultipleConcreteClses(KnowledgeBase kb, Collection allowedClses) {
        return allowedClses.isEmpty() || DisplayUtilities.getFirstTwoConcreteClses(kb, allowedClses).size() == 2;
    }

    private static boolean hasOneClass(Collection rootClses) {
        Cls cls;
        boolean hasOneClass = rootClses.size() == 1 ? (cls = (Cls)CollectionUtilities.getFirstItem(rootClses)).getDirectSubclassCount() == 0 : false;
        return hasOneClass;
    }

    public static Cls pickCls(Component component, Collection rootClses) {
        return DisplayUtilities.pickCls(component, DisplayUtilities.getKnowledgeBase(rootClses), rootClses, "Select Class");
    }

    public static Cls pickCls(Component component, KnowledgeBase kb, Collection rootClses) {
        return DisplayUtilities.pickCls(component, kb, rootClses, "Select Class");
    }

    public static Cls pickCls(Component component, Collection rootClses, String label) {
        return DisplayUtilities.pickCls(component, DisplayUtilities.getKnowledgeBase(rootClses), rootClses, label);
    }

    public static Cls pickCls(Component component, KnowledgeBase kb, Collection rootClses, String label) {
        return (Cls)CollectionUtilities.getFirstItem(DisplayUtilities.pickClses(component, kb, rootClses, label, false));
    }

    public static Collection pickClses(Component component, KnowledgeBase kb) {
        return DisplayUtilities.pickClses(component, kb, "Select Classes");
    }

    public static Collection pickClses(Component component, KnowledgeBase kb, String label) {
        Collection<Cls> rootClses = CollectionUtilities.createCollection(kb.getRootCls());
        return DisplayUtilities.pickClses(component, kb, rootClses, label);
    }

    public static Collection pickClses(Component component, Collection rootClses) {
        return DisplayUtilities.pickClses(component, DisplayUtilities.getKnowledgeBase(rootClses), rootClses);
    }

    public static Collection pickClses(Component component, KnowledgeBase kb, Collection rootClses) {
        return DisplayUtilities.pickClses(component, kb, rootClses, "Select Classes");
    }

    public static Collection pickClses(Component component, KnowledgeBase kb, Collection rootClses, String label) {
        return DisplayUtilities.pickClses(component, kb, rootClses, label, true);
    }

    private static Collection pickClses(Component component, KnowledgeBase kb, Collection rootClses, String label, boolean multiple) {
        SelectClsesPanel p;
        int result;
        Collection clses = rootClses.isEmpty() ? Collections.EMPTY_LIST : (DisplayUtilities.hasOneClass(rootClses) ? rootClses : ((result = ModalDialog.showDialog(component, p = new SelectClsesPanel(kb, rootClses, multiple), label, 11)) == 1 ? p.getSelection() : Collections.EMPTY_LIST));
        return clses;
    }

    public static Cls pickConcreteCls(Component component, KnowledgeBase kb, String label) {
        Collection<Cls> rootClses = CollectionUtilities.createCollection(kb.getRootCls());
        return DisplayUtilities.pickConcreteCls(component, kb, rootClses, label);
    }

    public static Cls pickConcreteCls(Component component, Collection allowedClses) {
        return DisplayUtilities.pickConcreteCls(component, allowedClses, "Select Concrete Cls");
    }

    public static Cls pickConcreteCls(Component component, KnowledgeBase kb, Collection allowedClses) {
        return DisplayUtilities.pickConcreteCls(component, kb, allowedClses, "Select Concrete Cls");
    }

    public static Cls pickConcreteCls(Component component, Collection allowedClses, String label) {
        return DisplayUtilities.pickConcreteCls(component, DisplayUtilities.getKnowledgeBase(allowedClses), allowedClses, label);
    }

    public static Cls pickConcreteCls(Component component, KnowledgeBase kb, Collection allowedClses, String label) {
        Cls cls;
        Collection concreteClses = DisplayUtilities.getFirstTwoConcreteClses(kb, allowedClses);
        switch (concreteClses.size()) {
            case 0: {
                ModalDialog.showMessageDialog(component, "There are no concrete allowed classes");
                cls = null;
                break;
            }
            case 1: {
                cls = (Cls)CollectionUtilities.getFirstItem(concreteClses);
                break;
            }
            case 2: {
                cls = DisplayUtilities.promptForConcreteCls(component, kb, allowedClses, label);
                break;
            }
            default: {
                Assert.fail("bad size: " + concreteClses.size());
                cls = null;
            }
        }
        return cls;
    }

    public static Cls pickForm(Component component, Project project) {
        return DisplayUtilities.pickForm(component, project, "Select Prototype Form");
    }

    public static Cls pickForm(Component component, Project project, String label) {
        SelectClsesPanel p = new SelectClsesPanel(project.getKnowledgeBase(), new FormRenderer(project));
        int result = ModalDialog.showDialog(component, p, label, 11);
        Cls cls = result == 1 ? (Cls)CollectionUtilities.getFirstItem(p.getSelection()) : null;
        return cls;
    }

    public static Instance pickInstance(Component component, KnowledgeBase kb) {
        Set<Cls> allowedClses = Collections.singleton(kb.getRootCls());
        return DisplayUtilities.pickInstance(component, allowedClses, "Select Instance");
    }

    public static Instance pickInstance(Component component, Collection allowedClses) {
        return DisplayUtilities.pickInstance(component, allowedClses, "Select Instance");
    }

    public static Instance pickInstance(Component component, Collection allowedClses, String label) {
        return (Instance)CollectionUtilities.getFirstItem(DisplayUtilities.pickInstances(component, allowedClses, label));
    }

    public static Instance pickInstanceFromCollection(Component component, Collection collection, int initialSelection, String label) {
        return DisplayUtilities.pickInstanceFromCollection(component, collection, initialSelection, label, null);
    }

    public static Instance pickInstanceFromCollection(Component component, Collection collection, int initialSelection, String label, ListCellRenderer cellRenderer) {
        int result;
        SelectInstanceFromCollectionPanel panel = new SelectInstanceFromCollectionPanel(collection, initialSelection);
        if (cellRenderer != null) {
            panel.setCellRenderer(cellRenderer);
        }
        Instance instance = (result = ModalDialog.showDialog(component, panel, label, 11)) == 1 ? panel.getSelection() : null;
        return instance;
    }

    public static Collection pickInstances(Component component, Collection allowedClses) {
        return DisplayUtilities.pickInstances(component, allowedClses, "Select Instances");
    }

    public static Collection pickInstances(Component component, KnowledgeBase kb, Collection allowedClses) {
        return DisplayUtilities.pickInstances(component, kb, allowedClses, "Select Instances");
    }

    public static Collection pickInstances(Component component, Collection allowedClses, String label) {
        KnowledgeBase kb = DisplayUtilities.getKnowledgeBase(allowedClses);
        return DisplayUtilities.pickInstances(component, kb, allowedClses, label);
    }

    private static KnowledgeBase getKnowledgeBase(Collection allowedClses) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(allowedClses);
        KnowledgeBase kb = cls == null ? ProjectManager.getProjectManager().getCurrentProject().getKnowledgeBase() : cls.getKnowledgeBase();
        return kb;
    }

    public static Collection pickInstances(Component component, KnowledgeBase kb, Collection allowedClses, String label) {
        Collection instances = Collections.EMPTY_LIST;
        SelectInstancesPanel panel = new SelectInstancesPanel(kb, allowedClses);
        int result = ModalDialog.showDialog(component, panel, label, 11);
        if (result == 1) {
            instances = panel.getSelection();
        }
        return instances;
    }

    public static Collection pickInstancesFromCollection(Component component, Collection instances, String label) {
        Collection selectedSlots = Collections.EMPTY_LIST;
        SelectInstancesFromCollectionPanel panel = new SelectInstancesFromCollectionPanel(instances);
        int result = ModalDialog.showDialog(component, panel, label, 11);
        switch (result) {
            case 1: {
                selectedSlots = panel.getSelection();
                break;
            }
            case 4: {
                break;
            }
            default: {
                Assert.fail("bad result: " + result);
            }
        }
        return selectedSlots;
    }

    public static Slot pickSlot(Component component, Collection slots) {
        return DisplayUtilities.pickSlot(component, slots, "Select Slot");
    }

    public static Slot pickSlot(Component component, Collection slots, String label) {
        return (Slot)CollectionUtilities.getFirstItem(DisplayUtilities.pickInstancesFromCollection(component, slots, label));
    }

    public static Collection pickSlots(Component component, Collection slots) {
        return DisplayUtilities.pickInstancesFromCollection(component, slots, "Select Slots");
    }

    public static Collection pickSlots(Component component, Collection slots, String label) {
        return DisplayUtilities.pickInstancesFromCollection(component, slots, label);
    }

    public static Object pickSymbol(Component component, String label, Object initialValue, Collection allowedValues) {
        Object value = initialValue;
        PickSymbolPanel panel = new PickSymbolPanel(label, initialValue, allowedValues);
        int result = ModalDialog.showDialog(component, panel, label, 11);
        if (result == 1) {
            value = panel.getSelectedValue();
        }
        return value;
    }

    private static Cls promptForConcreteCls(final Component component, KnowledgeBase kb, Collection clses, final String label) {
        final SelectClsesPanel p = new SelectClsesPanel(kb, clses);
        ModalDialog.CloseCallback callback = new ModalDialog.CloseCallback(){

            public boolean canClose(int result) {
                boolean canClose;
                if (result == 1) {
                    Cls cls = (Cls)CollectionUtilities.getFirstItem(p.getSelection());
                    boolean bl = canClose = cls != null && cls.isConcrete();
                    if (!canClose) {
                        ModalDialog.showMessageDialog(component, label);
                    }
                } else {
                    canClose = true;
                }
                return canClose;
            }
        };
        int result = ModalDialog.showDialog(component, p, label, 11, callback);
        Cls cls = result == 1 ? (Cls)CollectionUtilities.getFirstItem(p.getSelection()) : null;
        return cls;
    }
}

