/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.ui.CharsetRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EncodingsPanel
extends JPanel {
    private static final long serialVersionUID = -8201624349440500301L;
    private JComboBox readEncodingComboBox;

    public EncodingsPanel() {
        super(new BorderLayout());
        this.add((Component)this.createEncodingsPanel(), "Center");
        this.add((Component)EncodingsPanel.createLocalePanel(), "South");
    }

    private JComponent createEncodingsPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Encodings"));
        panel.add(EncodingsPanel.createCurrentEncoding());
        panel.add(this.createReadEncodingOverride());
        return panel;
    }

    private static JComponent createCurrentEncoding() {
        JTextField textField = ComponentFactory.createTextField();
        textField.setEnabled(false);
        textField.setText(SystemUtilities.getFileEncoding());
        return new LabeledComponent("Default", textField);
    }

    private JComponent createReadEncodingOverride() {
        this.readEncodingComboBox = ComponentFactory.createComboBox();
        this.readEncodingComboBox.setModel(EncodingsPanel.getEncodingModel());
        this.readEncodingComboBox.setSelectedItem(EncodingsPanel.getCurrentReadEncodingOverride());
        this.readEncodingComboBox.setRenderer(new CharsetRenderer());
        return new LabeledComponent("Read Override", this.readEncodingComboBox);
    }

    private static String getCurrentReadEncodingOverride() {
        String override = FileUtilities.getReadEncodingOverride();
        if (override != null) {
            Charset charset = Charset.forName(override);
            override = charset.name();
        }
        return override;
    }

    private static ComboBoxModel getEncodingModel() {
        Set<String> charsets = Charset.availableCharsets().keySet();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(charsets.toArray());
        model.insertElementAt(null, 0);
        return model;
    }

    private static JComponent createLocalePanel() {
        JTextField field = ComponentFactory.createTextField();
        field.setEnabled(false);
        String text = Locale.getDefault().getDisplayName(Locale.ENGLISH);
        field.setText(text);
        return new LabeledComponent("Locale", field);
    }

    public void commitChanges() {
        String override = (String)this.readEncodingComboBox.getSelectedItem();
        FileUtilities.setReadEncodingOverride(override);
    }
}

