/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ExportToCsvUtil;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportConfigurationPanel {
    private KnowledgeBase kb;
    private JPanel configPanel;
    private JCheckBox exportTypesCheckBox;
    private JCheckBox exportHeaderCheckBox;
    private JCheckBox exportBrowserTextCheckBox;
    private JCheckBox exportMetadataCheckBox;
    private JCheckBox exportSuperclassesCheckBox;
    private FileField fileField;
    private JTextField slotDelimiterTextField;
    private JTextField slotValuesDelimiterTextField;
    private Collection<Slot> slots = new LinkedHashSet<Slot>();
    private Collection<Slot> possibleSlots = new LinkedHashSet<Slot>();
    private Collection<Cls> clses = new LinkedHashSet<Cls>();
    private String metadataString = "";
    private boolean showExportSuperclasses = false;
    private boolean showExportClasses = false;
    private static HashMap<String, String> replaceChars = new HashMap();

    public ExportConfigurationPanel(KnowledgeBase kb) {
        this.kb = kb;
    }

    public JPanel getConfigPanel() {
        this.configPanel = new JPanel();
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 1));
        this.fileField = new FileField("Exported file", this.getExportedFileName(), "csv", "Exported result files");
        this.configPanel.add(this.fileField);
        if (this.showExportClasses) {
            LabeledComponent clsesListComp = this.getClsesListComponent();
            this.configPanel.add(clsesListComp);
        }
        LabeledComponent slotsListComp = this.getSlotsListComponent();
        this.configPanel.add(slotsListComp);
        this.configPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel p1 = new JPanel(new GridLayout(2, 2));
        p1.add(new JLabel("Slot delimiter"));
        this.slotDelimiterTextField = new JTextField(ExportToCsvUtil.getSlotsDelimiter(), 10);
        p1.add(this.slotDelimiterTextField);
        p1.add(new JLabel("Slot values delimiter"));
        this.slotValuesDelimiterTextField = new JTextField(ExportToCsvUtil.getSlotValuesDelimiter(), 10);
        p1.add(this.slotValuesDelimiterTextField);
        this.configPanel.add(p1);
        this.configPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel p2 = new JPanel(new GridLayout(this.showExportSuperclasses ? 5 : 4, 1));
        this.exportHeaderCheckBox = ComponentFactory.createCheckBox("Export slots name as first line in the file");
        this.exportHeaderCheckBox.setAlignmentX(0.0f);
        this.exportHeaderCheckBox.setSelected(true);
        p2.add(this.exportHeaderCheckBox);
        this.exportTypesCheckBox = ComponentFactory.createCheckBox("Export instance type(s)");
        this.exportTypesCheckBox.setAlignmentX(0.0f);
        this.exportTypesCheckBox.setSelected(false);
        p2.add(this.exportTypesCheckBox);
        this.exportBrowserTextCheckBox = ComponentFactory.createCheckBox("Export browser text (instead of name)");
        this.exportBrowserTextCheckBox.setAlignmentX(0.0f);
        this.exportBrowserTextCheckBox.setSelected(ExportToCsvUtil.isExportBrowserTextEnabled());
        p2.add(this.exportBrowserTextCheckBox);
        if (this.showExportSuperclasses) {
            this.exportSuperclassesCheckBox = ComponentFactory.createCheckBox("Export superclasses");
            this.exportSuperclassesCheckBox.setAlignmentX(0.0f);
            this.exportSuperclassesCheckBox.setSelected(ExportToCsvUtil.isExportSuperclass());
            p2.add(this.exportSuperclassesCheckBox);
        }
        p2.add(this.getExportMetadataComponent());
        this.configPanel.add(p2);
        return this.configPanel;
    }

    private JComponent getExportMetadataComponent() {
        boolean exportMetadata = ExportToCsvUtil.isExportMetadata();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.exportMetadataCheckBox = ComponentFactory.createCheckBox("Export additional text as last line in the file");
        this.exportMetadataCheckBox.setAlignmentX(0.0f);
        this.exportMetadataCheckBox.setSelected(exportMetadata);
        p.add(this.exportMetadataCheckBox);
        p.add(Box.createRigidArea(new Dimension(10, 0)));
        final JButton editTextButton = new JButton("Edit text");
        editTextButton.setEnabled(exportMetadata);
        editTextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExportConfigurationPanel.this.onEditText();
            }
        });
        this.exportMetadataCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = ExportConfigurationPanel.this.exportMetadataCheckBox.isSelected();
                editTextButton.setEnabled(selected);
                ExportToCsvUtil.setExportMetadata(selected);
            }
        });
        p.add(editTextButton);
        return p;
    }

    protected void onEditText() {
        JTextArea _comment = ComponentFactory.createTextArea();
        _comment.setPreferredSize(new Dimension(300, 150));
        _comment.setText(this.getExportMetadataText());
        LabeledComponent lc = new LabeledComponent("Information to be exported in the last line", new JScrollPane(_comment));
        int rval = ModalDialog.showDialog(this.configPanel, lc, "Export information", 11);
        if (rval == 1) {
            this.setExportMetadata(_comment.getText());
        }
    }

    private LabeledComponent getSlotsListComponent() {
        final SelectableList slotsList = ComponentFactory.createSelectableList(null);
        slotsList.setCellRenderer(FrameRenderer.createInstance());
        ComponentUtilities.addListValues(slotsList, this.slots);
        LabeledComponent labeledComp = new LabeledComponent("Slots to export", new JScrollPane(slotsList), true);
        labeledComp.addHeaderButton(new AllowableAction("Add slots", Icons.getAddSlotIcon(), null){
            private static final long serialVersionUID = -8082099266752807423L;

            public void actionPerformed(ActionEvent e) {
                HashSet<Slot> allSlots = new HashSet<Slot>();
                for (Slot s : ExportConfigurationPanel.this.kb.getSlots()) {
                    if (s.isSystem()) continue;
                    allSlots.add(s);
                }
                allSlots.add(ExportConfigurationPanel.this.kb.getNameSlot());
                allSlots.addAll(ExportConfigurationPanel.this.possibleSlots);
                ArrayList allSlotsList = new ArrayList(allSlots);
                Collections.sort(allSlotsList, new FrameComparator());
                Collection newSlots = DisplayUtilities.pickSlots(ExportConfigurationPanel.this.configPanel, allSlotsList, "Select slots to export (multiple selection)");
                ExportConfigurationPanel.this.slots.addAll(newSlots);
                ComponentUtilities.clearListValues(slotsList);
                ComponentUtilities.addListValues(slotsList, ExportConfigurationPanel.this.slots);
            }
        });
        labeledComp.addHeaderButton(new AllowableAction("Remove slot", Icons.getRemoveSlotIcon(), slotsList){
            private static final long serialVersionUID = -1292919958871934527L;

            public void actionPerformed(ActionEvent arg0) {
                Collection selection = this.getSelection();
                if (selection != null) {
                    ExportConfigurationPanel.this.slots.removeAll(selection);
                }
                ComponentUtilities.clearListValues(slotsList);
                ComponentUtilities.addListValues(slotsList, ExportConfigurationPanel.this.slots);
            }
        });
        return labeledComp;
    }

    private LabeledComponent getClsesListComponent() {
        final SelectableList clsesList = ComponentFactory.createSelectableList(null);
        clsesList.setCellRenderer(FrameRenderer.createInstance());
        ComponentUtilities.setListValues(clsesList, this.clses);
        LabeledComponent labeledComp = new LabeledComponent("Classes to export", new JScrollPane(clsesList), true);
        labeledComp.addHeaderButton(new AllowableAction("Add classes", Icons.getAddClsIcon(), null){
            private static final long serialVersionUID = -8306176540928522503L;

            public void actionPerformed(ActionEvent e) {
                HashSet allClses = new HashSet();
                ArrayList allClsesList = new ArrayList(allClses);
                Collections.sort(allClsesList, new FrameComparator());
                Collection newClses = DisplayUtilities.pickClses((Component)ExportConfigurationPanel.this.configPanel, ExportConfigurationPanel.this.kb, ExportConfigurationPanel.this.kb.getRootClses());
                ExportConfigurationPanel.this.clses.addAll(newClses);
                ComponentUtilities.clearListValues(clsesList);
                ComponentUtilities.addListValues(clsesList, ExportConfigurationPanel.this.clses);
            }
        });
        labeledComp.addHeaderButton(new AllowableAction("Remove cls", Icons.getRemoveClsIcon(), clsesList){
            private static final long serialVersionUID = 6906830668815822195L;

            public void actionPerformed(ActionEvent arg0) {
                Collection selection = this.getSelection();
                if (selection != null) {
                    ExportConfigurationPanel.this.clses.removeAll(selection);
                }
                ComponentUtilities.clearListValues(clsesList);
                ComponentUtilities.addListValues(clsesList, ExportConfigurationPanel.this.clses);
            }
        });
        return labeledComp;
    }

    private String getExportedFileName() {
        String projPath = this.kb.getProject().getProjectFilePath();
        String projName = this.kb.getProject().getProjectName();
        if (this.kb.getProject().isMultiUserClient()) {
            projPath = ApplicationProperties.getApplicationDirectory().getAbsolutePath();
            projName = "query";
        }
        String filename = FileUtilities.replaceFileName(projPath, projName + "_exported");
        filename = filename + "." + "csv";
        return filename;
    }

    public boolean isExportTypesEnabled() {
        return this.exportTypesCheckBox.isSelected();
    }

    public Collection<Slot> getExportedSlots() {
        return this.slots;
    }

    public File getExportedFile() {
        return this.fileField.getFilePath();
    }

    public boolean isExportHeaderEnabled() {
        return this.exportHeaderCheckBox.isSelected();
    }

    public boolean isExportBrowserTextEnabled() {
        return this.exportBrowserTextCheckBox.isSelected();
    }

    public boolean isExportSuperclassEnabled() {
        return this.exportSuperclassesCheckBox != null && this.exportSuperclassesCheckBox.isSelected();
    }

    public boolean isExportMetadataEnabled() {
        return this.exportMetadataCheckBox.isSelected();
    }

    public String getSlotDelimiter() {
        return this.getDelimiterString(this.slotDelimiterTextField.getText());
    }

    public String getSlotValuesDelimiter() {
        return this.getDelimiterString(this.slotValuesDelimiterTextField.getText());
    }

    private String getDelimiterString(String string) {
        String newString = new String(string);
        Iterator<String> i$ = replaceChars.keySet().iterator();
        while (i$.hasNext()) {
            String element;
            String ch = element = i$.next();
            newString = newString.replace(ch, replaceChars.get(ch));
        }
        return newString;
    }

    public Collection<Slot> getPossibleSlots() {
        return this.possibleSlots;
    }

    public void setPossibleSlots(Collection<Slot> possibleSlots) {
        this.possibleSlots = possibleSlots;
    }

    public void setInitialExportClasses(Collection<Cls> initialExportClses) {
        this.clses.clear();
        this.clses.addAll(initialExportClses);
    }

    public Collection<Cls> getExportedClassesInPanel() {
        return this.clses;
    }

    public String getExportMetadataText() {
        return this.metadataString;
    }

    public void setExportMetadata(String text) {
        this.metadataString = text;
    }

    public void setShowExportSuperclasses(boolean showExportSuperclasses) {
        this.showExportSuperclasses = showExportSuperclasses;
    }

    public void setShowExportedClasses(boolean showExportClasses) {
        this.showExportClasses = showExportClasses;
    }

    static {
        replaceChars.put("\\t", "\t");
        replaceChars.put("\\b", "\b");
        replaceChars.put("\\n", "\n");
        replaceChars.put("\\f", "\f");
        replaceChars.put("\\r", "\r");
    }
}

