/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class Finder
extends JComponent {
    private static final long serialVersionUID = 5434797981046601159L;
    private static List searchedForStrings = new ArrayList();
    private JComboBox _comboBox;
    private Action _findButtonAction;
    private static final int MAX_MATCHES = ApplicationProperties.getIntegerProperty(Finder.class.getName() + ".max_matches", 100);
    private static final int DEFAULT_MAX_MATCHES = 100;
    private ListCellRenderer cellRenderer;

    protected Finder(String description) {
        this(description, Icons.getFindIcon());
    }

    protected Finder(String description, Icon icon) {
        this._findButtonAction = new StandardAction(description, icon){
            private static final long serialVersionUID = 8031258886171785419L;

            public void actionPerformed(ActionEvent e) {
                Finder.this.doFind();
            }
        };
        this.initialize();
    }

    protected Finder(ResourceKey key) {
        this._findButtonAction = new StandardAction(key){
            private static final long serialVersionUID = 3573450038349614433L;

            public void actionPerformed(ActionEvent e) {
                Finder.this.doFind();
            }
        };
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTextField(), "Center");
        this.add((Component)this.createFindButton(), "East");
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private JComponent createFindButton() {
        JToolBar toolBar = ComponentFactory.createToolBar();
        ComponentFactory.addToolBarButton(toolBar, this._findButtonAction);
        return toolBar;
    }

    private JComponent createTextField() {
        this._comboBox = ComponentFactory.createComboBox();
        this._comboBox.setEditable(true);
        this._comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String command = event.getActionCommand();
                int modifiers = event.getModifiers();
                if (command.equals("comboBoxChanged") && (modifiers & 0x10) != 0) {
                    Finder.this.doFind();
                }
            }
        });
        this._comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    Finder.this.doFind();
                }
            }
        });
        this._comboBox.addPopupMenuListener(this.createPopupMenuListener());
        return this._comboBox;
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Finder.this._comboBox.setModel(new DefaultComboBoxModel<Object>(searchedForStrings.toArray()));
            }
        };
    }

    private static void recordItem(String text) {
        searchedForStrings.remove(text);
        searchedForStrings.add(0, text);
    }

    private void doFind() {
        String text = (String)this._comboBox.getSelectedItem();
        if (text != null && text.length() != 0) {
            List matches = this.getMatches(text, MAX_MATCHES);
            if (matches.isEmpty()) {
                this.getToolkit().beep();
                ModalDialog.showMessageDialog(this, "No matches found");
            } else if (matches.size() == 1) {
                WaitCursor cursor = new WaitCursor(this);
                Finder.recordItem(text);
                this.select(matches.get(0));
                cursor.hide();
            } else {
                Finder.recordItem(text);
                if (matches.size() == MAX_MATCHES) {
                    ModalDialog.showMessageDialog(this, "Search results limited to " + MAX_MATCHES);
                }
                String title = "Select from search results (" + matches.size() + " matches)";
                int initialSelection = this.getBestMatch(matches, text);
                Instance o = DisplayUtilities.pickInstanceFromCollection(this, matches, initialSelection, title, this.cellRenderer);
                if (o != null) {
                    WaitCursor cursor = new WaitCursor(this);
                    this.select(o);
                    cursor.hide();
                }
            }
        }
    }

    protected abstract int getBestMatch(List var1, String var2);

    protected abstract List getMatches(String var1, int var2);

    protected abstract void select(Object var1);

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._comboBox.setEnabled(enabled);
        this._findButtonAction.setEnabled(enabled);
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.cellRenderer = cellRenderer;
    }
}

