/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.SetDisplaySlotPanel;
import edu.stanford.smi.protege.ui.WidgetClassNameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SwitchableItemListener;
import edu.stanford.smi.protege.util.SwitchableSelectionListener;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ItemEvent;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FormDisplay
extends JComponent
implements Disposable {
    private static final long serialVersionUID = -8236544923188409652L;
    private Project _project;
    private JComponent _mainPanel;
    private SetDisplaySlotPanel _setDisplaySlotPanel;
    private JComboBox _widgetSelectionBox;
    private HeaderComponent _header;
    private ClsWidget _currentWidget;
    private ProjectListener _projectListener = new ProjectAdapter(){

        public void formChanged(ProjectEvent event) {
            Cls cls = event.getCls();
            FormWidget widget = FormDisplay.this.getCurrentWidget();
            if (widget != null && FormDisplay.equals(cls, widget.getCls()) && !FormDisplay.haveFocus()) {
                FormDisplay.this.setWidgetCls(cls);
            }
        }
    };
    private SwitchableItemListener _descriptorChoiceListener = new SwitchableItemListener(){

        public void changed(ItemEvent event) {
            if (event.getStateChange() == 1) {
                FormDisplay.this._selectionListener.disable();
                String widgetClassName = (String)FormDisplay.this._widgetSelectionBox.getSelectedItem();
                if (widgetClassName.equals(WidgetClassNameRenderer.NONE)) {
                    widgetClassName = null;
                }
                FormDisplay.this.getCurrentWidget().replaceSelectedWidget(widgetClassName);
                if (widgetClassName == null) {
                    FormDisplay.this.updateWidgetsBox();
                }
                FormDisplay.this._selectionListener.enable();
            }
        }
    };
    private SwitchableSelectionListener _selectionListener = new SwitchableSelectionListener(){

        public void changed(SelectionEvent event) {
            FormDisplay.this.updateWidgetsBox();
        }
    };

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public FormDisplay(Project project) {
        this._project = project;
        this._project.addProjectListener(this._projectListener);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createNorthPanel(), "North");
        this.add((Component)this.createMainPanel(), "Center");
    }

    private void addCls(Cls cls) {
        this._currentWidget = this._project.getDesignTimeClsWidget(cls);
        JComponent c = (JComponent)((Object)this._currentWidget);
        this._mainPanel.add(new JScrollPane(c));
        c.revalidate();
        c.repaint();
        this.loadBrowserKeySlotsBox(cls);
        this.loadWidgetsBox((SlotWidget)CollectionUtilities.getFirstItem(this._currentWidget.getSelection()));
        this.updateHeader(cls);
        this._currentWidget.addSelectionListener(this._selectionListener);
    }

    private void updateHeader(Cls cls) {
        JLabel label = (JLabel)this._header.getComponent();
        label.setIcon(cls.getIcon());
        label.setText(cls.getBrowserText());
    }

    private JComponent createBrowserKeySelection() {
        this._setDisplaySlotPanel = new SetDisplaySlotPanel();
        return this._setDisplaySlotPanel;
    }

    private JComponent createMainPanel() {
        this._mainPanel = new JPanel();
        this._mainPanel.setBorder(ComponentUtilities.getAlignBorder());
        this._mainPanel.setLayout(new BorderLayout());
        return this._mainPanel;
    }

    private JComponent createNorthPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        controlPanel.add((Component)this.createBrowserKeySelection(), "West");
        controlPanel.add((Component)this.createWidgetSelection(), "East");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createHeaderPanel(), "Center");
        panel.add((Component)controlPanel, "South");
        return panel;
    }

    private JComponent createHeaderPanel() {
        String formEditorLabel = LocalizedText.getText(ResourceKey.FORM_EDITOR_TITLE);
        String forClassLabel = LocalizedText.getText(ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this._header = new HeaderComponent(formEditorLabel, forClassLabel, ComponentFactory.createLabel());
        this._header.setColor(Colors.getFormColor());
        return this._header;
    }

    private JComponent createWidgetSelection() {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        this._widgetSelectionBox = ComponentFactory.createComboBox();
        this._widgetSelectionBox.setRenderer(new WidgetClassNameRenderer());
        this._widgetSelectionBox.addItemListener(this._descriptorChoiceListener);
        Dimension d = this._widgetSelectionBox.getPreferredSize();
        d.width = 250;
        this._widgetSelectionBox.setPreferredSize(d);
        String selectedWidgetTypeLabel = LocalizedText.getText(ResourceKey.FORM_EDITOR_SELECTED_WIDGET_TYPE_LABEL);
        panel.add(ComponentFactory.createSmallFontLabel(selectedWidgetTypeLabel));
        panel.add(this._widgetSelectionBox);
        return panel;
    }

    public void dispose() {
        this._project.removeProjectListener(this._projectListener);
    }

    private FormWidget getCurrentWidget() {
        FormWidget widget;
        int count = this._mainPanel.getComponentCount();
        if (count == 0) {
            widget = null;
        } else {
            JScrollPane pane = (JScrollPane)this._mainPanel.getComponent(0);
            widget = (FormWidget)pane.getViewport().getView();
        }
        return widget;
    }

    private static boolean haveFocus() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return manager.getFocusOwner() != null;
    }

    private void loadBrowserKeySlotsBox(Cls cls) {
        this._setDisplaySlotPanel.setCls(cls);
    }

    private void loadWidgetsBox(SlotWidget widget) {
        String widgetClassName = widget == null ? (String)null : widget.getClass().getName();
        this._descriptorChoiceListener.disable();
        if (this._widgetSelectionBox.getItemCount() > 0) {
            this._widgetSelectionBox.removeAllItems();
        }
        if (widget != null) {
            Cls cls = widget.getCls();
            Slot slot = widget.getSlot();
            this._widgetSelectionBox.addItem(WidgetClassNameRenderer.NONE);
            Iterator i = this._project.getSuitableWidgetClassNames(cls, slot, null).iterator();
            while (i.hasNext()) {
                this._widgetSelectionBox.addItem(i.next());
            }
            this._widgetSelectionBox.setSelectedItem(widgetClassName);
        }
        this._descriptorChoiceListener.enable();
    }

    private void removeCurrentWidget() {
        if (this._currentWidget != null) {
            this._currentWidget.removeSelectionListener(this._selectionListener);
            this._mainPanel.removeAll();
            this._currentWidget = null;
            this._setDisplaySlotPanel.setCls(null);
            this.revalidate();
            this.repaint();
        }
    }

    public void setWidgetCls(Cls cls) {
        this.removeCurrentWidget();
        if (cls != null) {
            this.addCls(cls);
        }
    }

    private void updateWidgetsBox() {
        SlotWidget w = (SlotWidget)CollectionUtilities.getFirstItem(this.getCurrentWidget().getSelection());
        this.loadWidgetsBox(w);
    }
}

