/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FormParentChildRoot;
import edu.stanford.smi.protege.ui.FormRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.ClsWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class FormsPanel
extends SelectableContainer {
    private static final long serialVersionUID = 3289763661862548509L;
    private Project _project;
    private SelectableTree _tree;
    private LabeledComponent _labeledComponent;
    private ProjectListener _projectListener = new ProjectAdapter(){

        public void formChanged(ProjectEvent event) {
            TreePath path = FormsPanel.this._tree.getSelectionPath();
            if (path != null) {
                LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
                node.notifyNodeChanged(node);
            }
            FormsPanel.this._tree.repaint();
        }
    };

    public FormsPanel(Project p) {
        this._project = p;
        this._project.addProjectListener(this._projectListener);
        this._tree = this.createTree();
        String formsLabel = LocalizedText.getText(ResourceKey.FORM_BROWSER_FORMS_LABEL);
        this._labeledComponent = new LabeledComponent(formsLabel, ComponentFactory.createScrollPane(this._tree));
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this._labeledComponent.addHeaderButton(this.createCustomizationsAction());
        this._labeledComponent.addHeaderButton(this.createRemoveCustomizationsAction());
        this._labeledComponent.addHeaderButton(this.createRelayoutAction());
        this._labeledComponent.addHeaderButton(this.createLayoutLikeOtherFormAction());
        this._labeledComponent.setFooterComponent(this.createFinderControl());
        this._tree.setCellRenderer(new FormRenderer(this._project));
        this.add((Component)this._labeledComponent, "Center");
        this.add((Component)this.createHeader(), "North");
        this.setSelectable(this._tree);
    }

    private JComponent createHeader() {
        JLabel label = ComponentFactory.createLabel(Icons.getProjectIcon());
        label.setText(this._project.getName());
        String formBrowserLabel = LocalizedText.getText(ResourceKey.FORM_BROWSER_TITLE);
        String forProjectLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent header = new HeaderComponent(formBrowserLabel, forProjectLabel, label);
        header.setColor(Colors.getFormColor());
        return header;
    }

    private JComponent createFinderControl() {
        return new ClsTreeFinder(this.getKnowledgeBase(), (JTree)this._tree, ResourceKey.FORM_SEARCH_FOR);
    }

    private Action createLayoutLikeOtherFormAction() {
        StandardAction action = new StandardAction(ResourceKey.FORM_LAYOUT_LIKE){
            private static final long serialVersionUID = -1636987064557133407L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                Cls cls;
                Collection selection = FormsPanel.this.getSelection();
                if (!selection.isEmpty() && (cls = DisplayUtilities.pickForm(FormsPanel.this, FormsPanel.this._project)) != null) {
                    WaitCursor cursor = new WaitCursor(FormsPanel.this);
                    try {
                        for (Cls widgetCls : selection) {
                            ClsWidget widget = FormsPanel.this.getClsWidget(widgetCls);
                            widget.layoutLikeCls(cls);
                        }
                    }
                    finally {
                        cursor.hide();
                    }
                }
            }
        };
        return action;
    }

    private Action createRelayoutAction() {
        return new StandardAction(ResourceKey.FORM_RELAYOUT){
            private static final long serialVersionUID = -4676741003358911004L;

            public void actionPerformed(ActionEvent event) {
                for (Cls cls : FormsPanel.this.getSelection()) {
                    ClsWidget widget = FormsPanel.this.getClsWidget(cls);
                    widget.relayout();
                }
            }
        };
    }

    private Action createRemoveCustomizationsAction() {
        return new StandardAction(ResourceKey.FORM_REMOVE_CUSTOMIZATIONS){
            private static final long serialVersionUID = -7310842310285324524L;

            public void actionPerformed(ActionEvent event) {
                for (Cls cls : FormsPanel.this.getSelection()) {
                    ClsWidget widget = FormsPanel.this.getClsWidget(cls);
                    widget.removeCustomizations();
                }
            }
        };
    }

    private Action createCustomizationsAction() {
        return new StandardAction(ResourceKey.FORM_VIEW_CUSTOMIZATIONS){
            private static final long serialVersionUID = 6407544740933698341L;

            public void actionPerformed(ActionEvent event) {
                for (Cls cls : FormsPanel.this.getSelection()) {
                    ClsWidget widget = FormsPanel.this.getClsWidget(cls);
                    widget.configure();
                }
            }
        };
    }

    public LazyTreeRoot createRoot() {
        return new FormParentChildRoot(this.getKnowledgeBase().getRootCls());
    }

    private SelectableTree createTree() {
        Cls root = this.getKnowledgeBase().getRootCls();
        SelectableTree tree = ComponentFactory.createSelectableTree(null, new ParentChildRoot(root));
        tree.setLargeModel(true);
        tree.addMouseListener(new TreePopupMenuMouseListener(tree){

            public JPopupMenu getPopupMenu() {
                return FormsPanel.this.getPopupMenu();
            }
        });
        return tree;
    }

    public void dispose() {
        this._project.removeProjectListener(this._projectListener);
    }

    public JTree getFormsTree() {
        return this._tree;
    }

    private ClsWidget getClsWidget(Cls cls) {
        return this._project.getDesignTimeClsWidget(cls);
    }

    private KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu menu = null;
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            menu = new JPopupMenu();
            menu.add(this.getRemoveDecendentCustomizations());
        }
        return menu;
    }

    private Action getRemoveDecendentCustomizations() {
        return new AbstractAction("Remove subclass customizations"){
            private static final long serialVersionUID = -7718205365558054806L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                WaitCursor cursor = new WaitCursor(FormsPanel.this);
                try {
                    FormsPanel.this.removeCustomizations();
                }
                finally {
                    cursor.hide();
                }
            }
        };
    }

    private void removeCustomizations() {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(this.getSelection());
        for (Cls subclass : cls.getSubclasses()) {
            if (!this._project.hasCustomizedDescriptor(subclass)) continue;
            ClsWidget widget = this.getClsWidget(subclass);
            widget.removeCustomizations();
        }
    }
}

