/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.DefaultRenderer;
import javax.swing.Icon;

public class FrameRenderer
extends DefaultRenderer
implements Cloneable {
    private static final long serialVersionUID = -4816350593456856600L;
    protected InstanceCountType _instanceCountType = InstanceCountType.NONE;
    protected boolean _hasLoadedIconFlags = false;
    protected boolean _displayFrameTypeIcon = true;
    protected boolean _displayAbstractIcon = true;
    protected boolean _displayMultipleParentsIcon = true;
    protected boolean _displayDefaultMetaclassIcon = true;
    protected boolean _displayHiddenIcon = true;
    protected boolean _displayType = false;
    private static FrameRenderer _frameRendererPrototype = new FrameRenderer();

    public static FrameRenderer createInstance() {
        FrameRenderer renderer;
        try {
            renderer = (FrameRenderer)_frameRendererPrototype.clone();
        }
        catch (CloneNotSupportedException e) {
            renderer = null;
        }
        return renderer;
    }

    protected void ensureIconFlagsLoaded() {
        Project p;
        if (!this._hasLoadedIconFlags && (p = ProjectManager.getProjectManager().getCurrentProject()) != null) {
            this._displayAbstractIcon = p.getDisplayAbstractClassIcon();
            this._displayMultipleParentsIcon = p.getDisplayMultiParentClassIcon();
            this._hasLoadedIconFlags = true;
        }
    }

    protected String getInstanceCountString(Cls cls) {
        int count;
        switch (this._instanceCountType) {
            case NONE: {
                count = 0;
                break;
            }
            case DIRECT: {
                count = cls.getDirectInstanceCount();
                break;
            }
            case ALL: {
                count = cls.getInstanceCount();
                break;
            }
            default: {
                Assert.fail("bad type: " + (Object)((Object)this._instanceCountType));
                count = 0;
            }
        }
        String s = count > 0 ? "  (" + count + ")" : "";
        return s;
    }

    public void setDisplayType(boolean displayType) {
        this._displayType = displayType;
    }

    public void loadDuplicate(Object value) {
        this.load(value);
        this.appendText("   (recursive)");
    }

    public void load(Object value) {
        this.ensureIconFlagsLoaded();
        if (value instanceof Frame) {
            Frame frameValue = (Frame)value;
            if (!frameValue.isEditable()) {
                this.setGrayedText(true);
            }
            if (frameValue.isDeleted()) {
                this.setMainIcon(null);
                this.setMainText("<deleted frame>");
            } else if (frameValue instanceof Cls) {
                this.loadCls((Cls)value);
            } else if (frameValue instanceof Slot) {
                this.loadSlot((Slot)value);
            } else if (frameValue instanceof Facet) {
                this.loadFacet((Facet)value);
            } else if (frameValue instanceof SimpleInstance) {
                this.loadInstance((Instance)value);
            }
        } else {
            this.setMainIcon(null);
            this.setMainText(value.toString());
        }
    }

    protected Icon getIcon(Cls cls) {
        return cls.getIcon();
    }

    protected void loadCls(Cls cls) {
        this.setMainIcon(this.getIcon(cls));
        this.setMainText(cls.getBrowserText());
        this.appendText(this.getInstanceCountString(cls));
        this.appendType(cls);
        this.setBackgroundSelectionColor(Colors.getClsSelectionColor());
    }

    protected void loadFacet(Facet facet) {
        this.setMainIcon(facet.getIcon());
        this.setMainText(facet.getBrowserText());
        this.appendType(facet);
    }

    protected void loadInstance(Instance instance) {
        String s = instance.getBrowserText();
        this.setMainText(s);
        this.setMainIcon(instance.getIcon());
        this.appendType(instance);
        this.setBackgroundSelectionColor(Colors.getInstanceSelectionColor());
    }

    public void loadNull() {
    }

    protected void loadSlot(Slot slot) {
        this.setMainIcon(slot.getIcon());
        this.setMainText(slot.getBrowserText());
        this.appendType(slot);
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }

    private void appendType(Instance instance) {
        if (this._displayType) {
            String type = instance.getDirectType().getBrowserText();
            this.appendText("  (" + type + ")");
        }
    }

    public void setDisplayDirectInstanceCount(boolean b) {
        this._instanceCountType = b ? InstanceCountType.DIRECT : InstanceCountType.NONE;
    }

    public void setDisplayFrameTypeIcon(boolean b) {
        this._displayFrameTypeIcon = b;
    }

    public void setDisplayHiddenIcon(boolean b) {
        this._displayHiddenIcon = b;
    }

    public void setDisplayInstanceCount(boolean b) {
        this._instanceCountType = b ? InstanceCountType.ALL : InstanceCountType.NONE;
    }

    public void setDisplayTrailingIcons(boolean b) {
        this._displayAbstractIcon = b;
        this._displayMultipleParentsIcon = b;
        this._displayDefaultMetaclassIcon = b;
        this._hasLoadedIconFlags = true;
    }

    public void setMainIcon(Icon icon) {
        if (this._displayFrameTypeIcon) {
            super.setMainIcon(icon);
        }
    }

    public static void setPrototypeInstance(FrameRenderer renderer) {
        _frameRendererPrototype = renderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstanceCountType {
        NONE,
        DIRECT,
        ALL;

    }
}

