/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.BrowserComparator;
import edu.stanford.smi.protege.ui.Finder;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringMatcher;
import edu.stanford.smi.protege.util.WaitCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameTreeFinder
extends Finder {
    private static final long serialVersionUID = -1763536497711305991L;
    private JTree tree;
    private KnowledgeBase knowledgeBase;

    protected KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    protected FrameTreeFinder(KnowledgeBase knowledgeBase, JTree tree, ResourceKey key) {
        super(key);
        this.tree = tree;
        this.knowledgeBase = knowledgeBase;
    }

    protected FrameTreeFinder(KnowledgeBase knowledgeBase, JTree tree, String description) {
        super(description);
        this.tree = tree;
        this.knowledgeBase = knowledgeBase;
    }

    protected FrameTreeFinder(KnowledgeBase knowledgeBase, JTree tree, String description, Icon icon) {
        super(description, icon);
        this.tree = tree;
        this.knowledgeBase = knowledgeBase;
    }

    @Override
    protected int getBestMatch(List matches, String text) {
        Instance instance;
        String browserText;
        int index;
        int result = Collections.binarySearch(matches, text, new BrowserComparator());
        if (result < 0 && (index = -(result + 1)) < matches.size() && (browserText = (instance = (Instance)matches.get(index)).getBrowserText().toLowerCase()).startsWith(text.toLowerCase())) {
            result = index;
        }
        return result;
    }

    @Override
    protected void select(Object o) {
        WaitCursor cursor = new WaitCursor(this);
        Frame frame = (Frame)o;
        ArrayList frames = new ArrayList();
        this.getVisiblePathToRoot(frame, frames);
        Collections.reverse(frames);
        ComponentUtilities.setSelectedObjectPath(this.tree, frames);
        cursor.hide();
    }

    @Override
    protected List getMatches(String text, int maxMatches) {
        Cls kbRoot = this.knowledgeBase.getRootCls();
        Set<Frame> matches = this.getMatchingFrames(text, maxMatches);
        LazyTreeRoot root = (LazyTreeRoot)this.tree.getModel().getRoot();
        HashSet rootNodes = new HashSet((Collection)root.getUserObject());
        if (rootNodes.size() != 1 || !FrameTreeFinder.equals(CollectionUtilities.getFirstItem(rootNodes), kbRoot)) {
            Iterator<Frame> i = matches.iterator();
            while (i.hasNext()) {
                Frame frame = i.next();
                boolean isValid = rootNodes.contains(frame);
                if (!isValid) {
                    HashSet parents = new HashSet(this.getAncestors(frame));
                    isValid = parents.removeAll(rootNodes);
                }
                if (isValid) continue;
                i.remove();
            }
        }
        ArrayList<Frame> sortedMatches = new ArrayList<Frame>(matches);
        Collections.sort(sortedMatches, new FrameComparator());
        return sortedMatches;
    }

    protected StringMatcher getStringMatcher(String text) {
        return new SimpleStringMatcher(text);
    }

    protected Set<Frame> getMatchingFrames(String text, int maxMatches) {
        if (!text.endsWith("*")) {
            text = text + '*';
        }
        StringMatcher matcher = this.getStringMatcher(text);
        LinkedHashSet<Frame> matches = new LinkedHashSet<Frame>();
        Collection<Reference> matchingReferences = this.knowledgeBase.getMatchingReferences(text, maxMatches);
        for (Reference ref : matchingReferences) {
            Frame frame = ref.getFrame();
            if (!this.isCorrectType(frame) || !matcher.isMatch(frame.getBrowserText())) continue;
            matches.add(frame);
        }
        return matches;
    }

    protected void getVisiblePathToRoot(Frame frame, Collection path) {
        boolean succeeded;
        ArrayList roots = new ArrayList((Collection)((LazyTreeNode)this.tree.getModel().getRoot()).getUserObject());
        Iterator i = roots.iterator();
        while (i.hasNext()) {
            Frame root = (Frame)i.next();
            if (root.isVisible()) continue;
            i.remove();
        }
        path.add(frame);
        if (!roots.contains(frame) && !(succeeded = this.getVisiblePathToRoot(frame, roots, path))) {
            Log.getLogger().warning("No visible path found for " + frame);
        }
    }

    protected boolean getVisiblePathToRoot(Frame frame, Collection roots, Collection path) {
        boolean found = false;
        Iterator i = this.getParents(frame).iterator();
        while (i.hasNext() && !found) {
            Frame parent = (Frame)i.next();
            if (!parent.isVisible() || path.contains(parent)) continue;
            path.add(parent);
            found = roots.contains(parent) ? true : this.getVisiblePathToRoot(parent, roots, path);
            if (found) continue;
            path.remove(parent);
        }
        return found;
    }

    protected abstract Collection getParents(Frame var1);

    protected abstract Collection getAncestors(Frame var1);

    protected abstract boolean isCorrectType(Frame var1);

    protected abstract Slot getBrowserSlot(KnowledgeBase var1);
}

