/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.LocaleComparator;
import edu.stanford.smi.protege.ui.LocaleRenderer;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GeneralPreferencesPanel
extends Box
implements Validatable {
    private static final long serialVersionUID = 5026044507780193841L;
    private JTextField userNameField;
    private JRadioButton useLoginUserNameButton;
    private JRadioButton useSpecifiedUserNameButton;
    private JRadioButton protegeDefaultLocaleButton;
    private JRadioButton systemDefaultLocaleButton;
    private JRadioButton otherLocaleButton;
    private JComboBox localeComboBox;
    private JCheckBox showWelcomeDialogCheckBox;
    private JCheckBox prettyPrintLabelsCheckBox;
    private JCheckBox sortClassTreeCheckBox;
    private JCheckBox sortSlotTreeCheckBox;

    public GeneralPreferencesPanel() {
        super(1);
        this.add(this.createShowWelcomeDialogCheckBox());
        this.add(this.createPrettyPrintLabelsCheckBox());
        this.add(this.createSortClassTreeCheckBox());
        this.add(this.createSortSlotTreeCheckBox());
        this.add(this.createUsernamePanel());
        this.add(this.createLocalePanel());
    }

    private JComponent createUsernamePanel() {
        String applicationUserName = ApplicationProperties.getUserName();
        String systemUserName = SystemUtilities.getUserName();
        Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        box.setBorder(BorderFactory.createTitledBorder("User Name"));
        Box useSpecifiedPanel = Box.createHorizontalBox();
        useSpecifiedPanel.setAlignmentX(0.0f);
        useSpecifiedPanel.setBackground(Color.RED);
        useSpecifiedPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.userNameField = ComponentFactory.createTextField();
        this.userNameField.setColumns(15);
        StandardAction action = new StandardAction("Use Specified Name: "){
            private static final long serialVersionUID = -3953329470167238831L;

            public void actionPerformed(ActionEvent event) {
                if (GeneralPreferencesPanel.this.useSpecifiedUserNameButton.isSelected()) {
                    GeneralPreferencesPanel.this.userNameField.setEnabled(true);
                } else {
                    GeneralPreferencesPanel.this.userNameField.setText(null);
                    GeneralPreferencesPanel.this.userNameField.setEnabled(false);
                }
            }
        };
        this.useSpecifiedUserNameButton = new JRadioButton(action);
        useSpecifiedPanel.add(this.useSpecifiedUserNameButton);
        useSpecifiedPanel.add(this.userNameField);
        this.useLoginUserNameButton = new JRadioButton("Use Login Name: " + systemUserName);
        ButtonGroup group = new ButtonGroup();
        group.add(this.useSpecifiedUserNameButton);
        group.add(this.useLoginUserNameButton);
        if (applicationUserName == null || applicationUserName.length() == 0 || systemUserName.equals(applicationUserName)) {
            this.useLoginUserNameButton.setSelected(true);
        } else {
            this.useSpecifiedUserNameButton.setSelected(true);
            this.userNameField.setText(applicationUserName);
        }
        box.add(this.useLoginUserNameButton);
        box.add(useSpecifiedPanel);
        return box;
    }

    private JComponent createLocalePanel() {
        Box box = Box.createVerticalBox();
        Locale defaultLocale = ApplicationProperties.getLocale();
        Locale systemLocale = SystemUtilities.getSystemLocale();
        Locale protegeDefaultLocale = SystemUtilities.getProtegeSystemDefaultLocale();
        box.setBorder(BorderFactory.createTitledBorder("Locale"));
        this.protegeDefaultLocaleButton = new JRadioButton(Text.getProgramName() + " Default:   " + protegeDefaultLocale.getDisplayName());
        this.systemDefaultLocaleButton = new JRadioButton("System Default:   " + systemLocale.getDisplayName());
        this.otherLocaleButton = new JRadioButton("Other:   ");
        this.localeComboBox = ComponentFactory.createComboBox();
        this.localeComboBox.setModel(new DefaultComboBoxModel<Locale>(GeneralPreferencesPanel.getSortedLocales()));
        this.localeComboBox.setRenderer(new LocaleRenderer());
        this.localeComboBox.setEnabled(false);
        if (defaultLocale.equals(protegeDefaultLocale)) {
            this.protegeDefaultLocaleButton.setSelected(true);
        } else if (defaultLocale.equals(systemLocale)) {
            this.systemDefaultLocaleButton.setSelected(true);
        } else {
            this.otherLocaleButton.setSelected(true);
            this.localeComboBox.setSelectedItem(defaultLocale);
            this.localeComboBox.setEnabled(true);
        }
        if (systemLocale.equals(protegeDefaultLocale)) {
            this.systemDefaultLocaleButton.setEnabled(false);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GeneralPreferencesPanel.this.localeComboBox.setEnabled(GeneralPreferencesPanel.this.otherLocaleButton.isSelected());
            }
        };
        this.protegeDefaultLocaleButton.addActionListener(actionListener);
        this.systemDefaultLocaleButton.addActionListener(actionListener);
        this.otherLocaleButton.addActionListener(actionListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.protegeDefaultLocaleButton);
        group.add(this.systemDefaultLocaleButton);
        group.add(this.otherLocaleButton);
        Box otherLocalePanel = Box.createHorizontalBox();
        otherLocalePanel.add(this.otherLocaleButton);
        otherLocalePanel.add(this.localeComboBox);
        otherLocalePanel.setAlignmentX(0.0f);
        box.add(this.protegeDefaultLocaleButton);
        box.add(this.systemDefaultLocaleButton);
        box.add(otherLocalePanel);
        box.setVisible(SystemUtilities.showAlphaFeatures());
        return box;
    }

    private static Locale[] getSortedLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, new LocaleComparator());
        return locales;
    }

    private JComponent createShowWelcomeDialogCheckBox() {
        this.showWelcomeDialogCheckBox = ComponentFactory.createCheckBox("Show Welcome Dialog on Start-up");
        this.showWelcomeDialogCheckBox.setSelected(ApplicationProperties.getWelcomeDialogShow());
        return this.showWelcomeDialogCheckBox;
    }

    private JComponent createPrettyPrintLabelsCheckBox() {
        this.prettyPrintLabelsCheckBox = ComponentFactory.createCheckBox("Capitalize Slot Widget Labels");
        this.prettyPrintLabelsCheckBox.setSelected(ApplicationProperties.getPrettyPrintSlotWidgetLabels());
        return this.prettyPrintLabelsCheckBox;
    }

    private Component createSortSlotTreeCheckBox() {
        this.sortSlotTreeCheckBox = ComponentFactory.createCheckBox("Sort slot tree (Slots Tab)");
        this.sortSlotTreeCheckBox.setSelected(ApplicationProperties.getSortSlotTreeOption());
        return this.sortSlotTreeCheckBox;
    }

    private Component createSortClassTreeCheckBox() {
        this.sortClassTreeCheckBox = ComponentFactory.createCheckBox("Sort class tree (Classes Tab)");
        this.sortClassTreeCheckBox.setSelected(ApplicationProperties.getSortClassTreeOption());
        return this.sortClassTreeCheckBox;
    }

    public void saveContents() {
        ApplicationProperties.setUserName(this.userNameField.getText());
        ApplicationProperties.setWelcomeDialogShow(this.showWelcomeDialogCheckBox.isSelected());
        ApplicationProperties.setPrettyPrintSlotWidgetLabels(this.prettyPrintLabelsCheckBox.isSelected());
        ApplicationProperties.setSortClassTreeOption(this.sortClassTreeCheckBox.isSelected());
        ApplicationProperties.setSortSlotTreeOption(this.sortSlotTreeCheckBox.isSelected());
        Locale locale = this.protegeDefaultLocaleButton.isSelected() ? SystemUtilities.getProtegeSystemDefaultLocale() : (this.systemDefaultLocaleButton.isSelected() ? SystemUtilities.getSystemLocale() : (Locale)this.localeComboBox.getSelectedItem());
        ApplicationProperties.setLocale(locale);
    }

    public boolean validateContents() {
        return true;
    }
}

