/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class IconDialog
extends JDialog {
    private static final long serialVersionUID = -6319120373860753057L;
    Icon[] icons = new Icon[]{null, Icons.getAddIcon(), Icons.getRemoveIcon(), Icons.getCreateIcon(), Icons.getDeleteIcon(), Icons.getViewIcon(), Icons.getViewInstanceReferencersIcon(), Icons.getUpIcon(), Icons.getDownIcon(), Icons.getCreateInstanceNoteIcon(), Icons.getDeleteInstanceNoteIcon(), null, Icons.getClsIcon(), Icons.getClsIcon(false, true, false, false), Icons.getClsIcon(true, false, false, false), Icons.getClsIcon(true, true, false, false), Icons.getFacetIcon(), Icons.getInstanceIcon(), Icons.getSlotIcon(), Icons.getSlotIcon(true, false, false, false), Icons.getSlotIcon(false, true, false, false), Icons.getSlotIcon(true, true, false, false), Icons.getViewSlotIcon(), Icons.getViewSlotAtClassIcon(), Icons.getRemoveSlotOverrideIcon(), null, Icons.getFormIcon(), Icons.getRelayoutIcon(), Icons.getLayoutLikeOtherFormIcon(), Icons.getFormIcon(true), Icons.getRemoveCustomizationsIcon()};
    String[] iconText = new String[]{"General Icons", "Add, attach, or select", "Remove selected object from view but not from the knowledge base", "Create a class, slot, or instance", "Delete selected class, slot, or instance from the knowledge base", "View selected class, slot, or instance", "Display references to selected class, slot, or instance", "Move selected item up in list", "Move selected item down in list", "Create note", "Delete note", "Frame Icons", "Class", "Abstract class (a class with no instances)", "Metaclass", "Abstract metaclass", "Facet", "Instance", "Slot", "Inherited slot", "Overridden slot", "Overridden inherited slot", "View selected slots", "View selected slots at class", "Remove slot override", "Form Icons", "Form", "Default layout with current widgets", "Layout like form...", "Customized Form", "Remove all customizations"};

    public IconDialog() {
        this((Frame)null, "", false);
    }

    public IconDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.init();
            this.pack();
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
    }

    public void closeButton_actionPerformed(ActionEvent ae) {
        this.setVisible(false);
    }

    private int getMaxHeight() {
        int maxHeight = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            int height;
            if (this.icons[i] == null || (height = this.icons[i].getIconHeight()) <= maxHeight) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    private int getMaxWidth() {
        int maxWidth = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            int width;
            if (this.icons[i] == null || (width = this.icons[i].getIconWidth()) <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private JTextField getTextHeader(String text) {
        JTextField textField = new JTextField(text);
        textField.setEnabled(false);
        textField.setBackground(this.getBackground());
        textField.setDisabledTextColor(this.getForeground());
        textField.setBorder(null);
        textField.setFont(new Font("Dialog", 1, 14));
        return textField;
    }

    private void init() {
        JPanel iconPanel = new JPanel(new GridLayout(this.icons.length, 1));
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        Dimension d = new Dimension(maxWidth, maxHeight);
        for (int i = 0; i < this.icons.length; ++i) {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.icons[i] == null) {
                JTextField header = this.getTextHeader(this.iconText[i]);
                panel.add((Component)header, "Center");
            } else {
                JLabel icon = ComponentFactory.createLabel(this.icons[i], 0);
                icon.setPreferredSize(d);
                panel.add((Component)icon, "West");
                JLabel iconDescription = ComponentFactory.createLabel(this.iconText[i], 2);
                panel.add((Component)iconDescription, "Center");
            }
            iconPanel.add(panel);
        }
        JScrollPane scrollPane = new JScrollPane(iconPanel);
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                IconDialog.this.closeButton_actionPerformed(ae);
            }
        });
        buttonPanel.add(closeButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
    }
}

