/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.event.WidgetAdapter;
import edu.stanford.smi.protege.event.WidgetEvent;
import edu.stanford.smi.protege.event.WidgetListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.StandardDateFormat;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceDisplay
extends JDesktopPane
implements Disposable {
    private static final long serialVersionUID = 4777948146986438293L;
    private Project _project;
    private JScrollPane _scrollPane;
    private Collection<ClsWidget> _currentWidgets = new ArrayList<ClsWidget>();
    private Instance _currentInstance;
    private Cls _currentAssociatedCls;
    private HeaderComponent _header;
    private JComponent _child;
    private Point _lastYellowStickyPosition = new Point();
    private Slot _templateSlotsSlot;
    private AbstractButton _hideNotesButton;
    private AbstractButton _createNoteButton;
    private AbstractButton _deleteNoteButton;
    private boolean resizeVertically;
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSuperclassAdded(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            InstanceDisplay.this.reloadForm();
        }

        public void directSuperclassRemoved(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            InstanceDisplay.this.reloadForm();
        }

        public void templateSlotAdded(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (InstanceDisplay.this.shouldDisplaySlot(event.getCls(), event.getSlot())) {
                InstanceDisplay.this.reloadForm();
            }
        }

        public void templateSlotRemoved(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (InstanceDisplay.this.isDisplayingSlot(event.getCls(), event.getSlot())) {
                InstanceDisplay.this.reloadForm();
            }
        }

        public void templateFacetValueChanged(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (InstanceDisplay.this.isDisplayingSlot(event.getCls(), event.getSlot())) {
                InstanceDisplay.this.reloadForm();
            }
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            Slot slot = event.getSlot();
            if (slot.hasSuperslot(InstanceDisplay.this._templateSlotsSlot)) {
                InstanceDisplay.this.reloadForm();
            }
        }
    };
    private KnowledgeBaseListener _kbListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent event) {
            Frame oldFrame = event.getFrame();
            Frame newFrame = event.getNewFrame();
            if (InstanceDisplay.this._currentInstance != null && InstanceDisplay.this._currentInstance.equals(oldFrame)) {
                InstanceDisplay.this.setInstance((Instance)newFrame);
            }
            if (InstanceDisplay.this._currentAssociatedCls != null && InstanceDisplay.this._currentAssociatedCls.equals(oldFrame)) {
                InstanceDisplay.this.setInstance(InstanceDisplay.this._currentInstance);
            }
        }
    };
    private WidgetListener _widgetListener = new WidgetAdapter(){

        public void labelChanged(WidgetEvent event) {
            if (InstanceDisplay.this._header != null) {
                InstanceDisplay.this.loadHeader();
            }
        }
    };
    private ProjectListener _projectListener = new ProjectAdapter(){

        public void formChanged(ProjectEvent event) {
            Cls cls = event.getCls();
            if (InstanceDisplay.this.isDisplayingCls(cls)) {
                InstanceDisplay.this.reloadForm();
            }
        }
    };
    private InstanceListener _instanceListener = new InstanceListener(){

        public void directTypeAdded(InstanceEvent event) {
            InstanceDisplay.this.onDirectTypeAdded(event.getCls());
        }

        public void directTypeRemoved(InstanceEvent event) {
            InstanceDisplay.this.onDirectTypeRemoved(event.getCls());
        }
    };

    protected boolean shouldDisplaySlot(Cls cls, Slot slot) {
        return true;
    }

    protected boolean isDisplayingSlot(Cls cls, Slot slot) {
        ClsWidget widget = this.getClsWidget(cls);
        return widget.getSlotWidget(slot) != null;
    }

    private boolean isDisplayingCls(Cls cls) {
        return this.getClsWidget(cls) != null;
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    protected void onDirectTypeAdded(Cls type) {
        this.reloadForm();
    }

    protected void onDirectTypeRemoved(Cls type) {
        this.reloadForm();
    }

    public InstanceDisplay(Project project) {
        this(project, true, true);
    }

    public InstanceDisplay(Project project, boolean showHeader, boolean showHeaderLabel) {
        this._child = new JPanel(new BorderLayout());
        if (showHeader) {
            this._child.add((Component)this.createHeaderComponent(), "North");
            if (!showHeaderLabel) {
                this._header.setVisible(false);
            }
        }
        this._project = project;
        this._templateSlotsSlot = project.getKnowledgeBase().getSlot(":DIRECT-TEMPLATE-SLOTS");
        project.getKnowledgeBase().addKnowledgeBaseListener(this._kbListener);
        project.addProjectListener(this._projectListener);
        this._scrollPane = this.makeInstanceScrollPane();
        this._child.add((Component)this._scrollPane, "Center");
        this.add(this._child);
        if (showHeader) {
            this.loadHeader();
        }
    }

    @Override
    public void setBorder(Border border) {
        if (this._child != null) {
            this._child.setBorder(border);
        }
    }

    public HeaderComponent getHeaderComponent() {
        return this._header;
    }

    protected JLabel getHeaderLabel() {
        return (JLabel)this._header.getComponent();
    }

    protected JScrollPane makeInstanceScrollPane() {
        JScrollPane pane = ComponentFactory.createScrollPane();
        pane.setBorder(null);
        return pane;
    }

    protected void addRuntimeWidgets(Instance instance, Cls associatedCls) {
        Collection types = instance.getDirectTypes();
        this._currentWidgets.clear();
        for (Cls type : types) {
            ClsWidget widget = this.getWidget(type, instance, associatedCls);
            if (widget == null) continue;
            type.addClsListener(this._clsListener);
            type.addFrameListener(this._frameListener);
            widget.addWidgetListener(this._widgetListener);
            this._currentWidgets.add(widget);
        }
        JComponent component = this.createWidgetContainer(this._currentWidgets);
        this._scrollPane.setViewportView(component);
        this.update();
    }

    protected ClsWidget getWidget(Cls type, Instance instance, Cls associatedCls) {
        return this._project.createRuntimeClsWidget(type, instance, associatedCls);
    }

    protected JComponent createWidgetContainer(Collection widgets) {
        JComponent container;
        if (widgets.size() == 1) {
            FormWidget widget = (FormWidget)CollectionUtilities.getFirstItem(widgets);
            widget.setResizeVertically(this.resizeVertically);
            container = widget;
        } else {
            container = this.doTabbedFormLayout() ? this.createTabbedWidgetLayout(widgets) : this.createSingleFormWidgetLayout(widgets);
        }
        return container;
    }

    protected boolean doTabbedFormLayout() {
        return this._project.getTabbedInstanceFormLayout();
    }

    protected JComponent createTabbedWidgetLayout(Collection widgets) {
        JTabbedPane tabbedPane = ComponentFactory.createTabbedPane(false);
        for (ClsWidget widget : widgets) {
            tabbedPane.addTab(widget.getCls().getBrowserText(), (JComponent)((Object)widget));
        }
        tabbedPane.setBorder(ComponentUtilities.getAlignBorder());
        return tabbedPane;
    }

    protected JComponent createSingleFormWidgetLayout(Collection widgets) {
        Box boxPanel = Box.createVerticalBox();
        for (FormWidget widget : widgets) {
            widget.setResizeVertically(this.resizeVertically);
            JPanel componentToAdd = widget;
            JPanel body = new JPanel(new BorderLayout());
            body.add(widget);
            String text = "as " + widget.getCls().getBrowserText();
            JLabel header = ComponentFactory.createSmallFontLabel(text);
            header.setPreferredSize(ComponentFactory.STANDARD_BUTTON_SIZE);
            body.setBorder(BorderFactory.createEtchedBorder());
            componentToAdd = new JPanel(new BorderLayout());
            componentToAdd.add((Component)header, "North");
            componentToAdd.add((Component)body, "Center");
            componentToAdd.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            boxPanel.add(componentToAdd);
        }
        JPanel container = new JPanel(new BorderLayout());
        String position = this.resizeVertically ? "Center" : "North";
        container.add((Component)boxPanel, position);
        return container;
    }

    private AbstractAction createCreateYellowStickiesAction() {
        return new StandardAction(ResourceKey.INSTANCE_NOTE_CREATE){
            private static final long serialVersionUID = -693378347365867392L;

            public void actionPerformed(ActionEvent event) {
                InstanceDisplay.this.createYellowSticky();
            }
        };
    }

    private AbstractAction createDeleteYellowStickiesAction() {
        return new StandardAction(ResourceKey.INSTANCE_NOTE_DELETE){
            private static final long serialVersionUID = 4056875859826717485L;

            public void actionPerformed(ActionEvent event) {
                InstanceDisplay.this.deleteYellowSticky();
            }
        };
    }

    private AbstractAction createHideYellowStickiesAction() {
        return new StandardAction(ResourceKey.INSTANCE_NOTE_HIDE){
            private static final long serialVersionUID = 4169231408766745704L;

            public void actionPerformed(ActionEvent event) {
                InstanceDisplay.this.updateYellowStickiesView();
            }
        };
    }

    protected JComponent createHeaderComponent() {
        this._header = new HeaderComponent(ComponentFactory.createLabel());
        this._hideNotesButton = this._header.addToggleButton(this.createHideYellowStickiesAction());
        this._createNoteButton = this._header.addButton(this.createCreateYellowStickiesAction());
        this._deleteNoteButton = this._header.addButton(this.createDeleteYellowStickiesAction());
        return this._header;
    }

    private void createYellowSticky() {
        this.ensureYellowStickiesAreVisible();
        KnowledgeBase kb = this._project.getKnowledgeBase();
        Instance instance = kb.createInstance(null, kb.getCls(":INSTANCE-ANNOTATION"));
        ModelUtilities.setOwnSlotValue(instance, ":CREATOR", this._project.getUserName());
        StandardDateFormat formatter = new StandardDateFormat();
        String date = formatter.format(new Date());
        ModelUtilities.setOwnSlotValue(instance, ":CREATION-TIMESTAMP", date);
        ModelUtilities.setOwnSlotValue(instance, ":ANNOTATED-INSTANCE", this._currentInstance);
        this.showYellowSticky(instance);
    }

    private void deleteYellowSticky() {
        Collection stickyInstances = this.getStickyInstances();
        int count = stickyInstances.size();
        if (count == 1) {
            String text = "Are you sure that you want to delete this note";
            int result = ModalDialog.showMessageDialog((Component)this, text, 13);
            if (result == 2) {
                Instance instance = (Instance)CollectionUtilities.getFirstItem(stickyInstances);
                this.removeSticky(instance);
                instance.delete();
            }
        } else if (count > 1) {
            Collection c = DisplayUtilities.pickInstancesFromCollection(this, stickyInstances, "Select a note to delete");
            for (Instance instance : c) {
                this.removeSticky(instance);
                instance.delete();
            }
        }
    }

    private void updateYellowStickiesView() {
        boolean hide = this._hideNotesButton.isSelected();
        if (hide) {
            this.removeAllStickies();
        } else {
            this.showAllStickies();
        }
    }

    @Override
    public void dispose() {
        if (this._project == null) {
            return;
        }
        this._project.getKnowledgeBase().removeKnowledgeBaseListener(this._kbListener);
        this._project.removeProjectListener(this._projectListener);
        if (this._currentInstance != null) {
            this._currentInstance.removeInstanceListener(this._instanceListener);
        }
        for (ClsWidget widget : this._currentWidgets) {
            widget.removeWidgetListener(this._widgetListener);
            widget.getCls().removeClsListener(this._clsListener);
            widget.getCls().removeFrameListener(this._frameListener);
        }
        this._currentWidgets.clear();
        this._project = null;
    }

    private void ensureYellowStickiesAreVisible() {
    }

    @Deprecated
    public ClsWidget getCurrentClsWidget() {
        return this.getFirstClsWidget();
    }

    public ClsWidget getFirstClsWidget() {
        return CollectionUtilities.getFirstItem(this._currentWidgets);
    }

    private ClsWidget getClsWidget(Cls cls) {
        ClsWidget widget = null;
        for (ClsWidget clsWidget : this._currentWidgets) {
            if (!clsWidget.getCls().equals(cls)) continue;
            widget = clsWidget;
            break;
        }
        return widget;
    }

    public Instance getCurrentInstance() {
        return this._currentInstance;
    }

    public void setResizeVertically(boolean b) {
        this.resizeVertically = b;
        this.reloadForm();
    }

    private Point getNextYellowStickyPosition() {
        int OFFSET = 25;
        int MAX_OFFSET = 100;
        this._lastYellowStickyPosition.x += OFFSET;
        this._lastYellowStickyPosition.x %= MAX_OFFSET;
        this._lastYellowStickyPosition.y += OFFSET;
        this._lastYellowStickyPosition.y %= MAX_OFFSET;
        return this._lastYellowStickyPosition;
    }

    @Override
    public Dimension getPreferredSize() {
        return this._child.getPreferredSize();
    }

    private Collection getStickyInstances() {
        ArrayList<Instance> stickyInstances = new ArrayList<Instance>();
        if (this._currentInstance != null) {
            KnowledgeBase kb = this._project.getKnowledgeBase();
            Slot annotationSlot = kb.getSlot(":ANNOTATED-INSTANCE");
            for (Instance annotationInstance : kb.getCls(":INSTANCE-ANNOTATION").getInstances()) {
                Instance pointedAtInstance = (Instance)annotationInstance.getOwnSlotValue(annotationSlot);
                if (!InstanceDisplay.equals(pointedAtInstance, this._currentInstance)) continue;
                stickyInstances.add(annotationInstance);
            }
        }
        return stickyInstances;
    }

    private Map<Instance, Rectangle> getYellowStickyMap() {
        String mapName = "InstanceDisplay.yellow_stickies";
        HashMap map = (HashMap)this._project.getClientInformation(mapName);
        if (map == null) {
            map = new HashMap();
            this._project.setClientInformation(mapName, map);
        }
        return map;
    }

    protected void loadHeader() {
        if (this._currentInstance instanceof Cls) {
            this.loadHeaderWithCls((Cls)this._currentInstance);
        } else if (this._currentInstance instanceof Slot) {
            this.loadHeaderWithSlot((Slot)this._currentInstance);
        } else {
            this.loadHeaderWithSimpleInstance(this._currentInstance);
        }
    }

    protected void loadHeaderWithCls(Cls cls) {
        this.loadHeaderLabel(cls);
        this._header.setColor(Colors.getClsColor());
        this._header.setTitle(LocalizedText.getText(ResourceKey.CLASS_EDITOR_TITLE));
        this._header.setComponentLabel(LocalizedText.getText(ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL));
        InstanceDisplay.setResource(this._hideNotesButton, ResourceKey.CLASS_NOTE_HIDE_ALL);
        InstanceDisplay.setResource(this._createNoteButton, ResourceKey.CLASS_NOTE_CREATE);
        InstanceDisplay.setResource(this._deleteNoteButton, ResourceKey.CLASS_NOTE_DELETE);
    }

    private static void setResource(AbstractButton button, ResourceKey key) {
        button.setIcon(Icons.getIcon(key));
        button.setToolTipText(LocalizedText.getText(key));
    }

    protected void loadHeaderWithSlot(Slot slot) {
        this.loadHeaderLabel(slot);
        this._header.setColor(Colors.getSlotColor());
        this._header.setTitle(LocalizedText.getText(ResourceKey.SLOT_EDITOR_TITLE));
        this._header.setComponentLabel(LocalizedText.getText(ResourceKey.SLOT_EDITOR_FOR_SLOT_LABEL));
        InstanceDisplay.setResource(this._hideNotesButton, ResourceKey.SLOT_NOTE_HIDE);
        InstanceDisplay.setResource(this._createNoteButton, ResourceKey.SLOT_NOTE_CREATE);
        InstanceDisplay.setResource(this._deleteNoteButton, ResourceKey.SLOT_NOTE_DELETE);
    }

    protected void loadHeaderLabel(Instance instance) {
        JLabel label = this.getHeaderLabel();
        if (instance != null) {
            label.setIcon(instance.getIcon());
            String browserText = instance.getBrowserText();
            StringBuffer buffer = new StringBuffer(browserText);
            buffer.append("     ");
            String typeText = this.getTypeText(instance);
            String name = instance.getName();
            String text = name.equals(browserText) ? LocalizedText.getText(ResourceKey.FRAME_EDITOR_FRAME_TYPE, typeText) : LocalizedText.getText(ResourceKey.FRAME_EDITOR_FRAME_TYPE_AND_NAME, typeText, name);
            buffer.append(text);
            label.setText(buffer.toString());
        } else {
            label.setIcon(null);
            label.setText("");
        }
    }

    protected String getTypeText(Instance instance) {
        StringBuffer typeText = new StringBuffer();
        Iterator i = instance.getDirectTypes().iterator();
        while (i.hasNext()) {
            Cls type = (Cls)i.next();
            typeText.append(type.getBrowserText());
            if (!i.hasNext()) continue;
            typeText.append(", ");
        }
        return typeText.toString();
    }

    protected void loadHeaderWithSimpleInstance(Instance instance) {
        this.loadHeaderLabel(instance);
        this._header.setColor(Colors.getInstanceColor());
        this._header.setTitle(LocalizedText.getText(ResourceKey.INSTANCE_EDITOR_TITLE));
        this._header.setComponentLabel(LocalizedText.getText(ResourceKey.INSTANCE_EDITOR_FOR_INSTANCE_LABEL));
        InstanceDisplay.setResource(this._hideNotesButton, ResourceKey.INSTANCE_NOTE_HIDE);
        InstanceDisplay.setResource(this._createNoteButton, ResourceKey.INSTANCE_NOTE_CREATE);
        InstanceDisplay.setResource(this._deleteNoteButton, ResourceKey.INSTANCE_NOTE_DELETE);
    }

    private JInternalFrame loadIntoFrame(final Instance instance) {
        JInternalFrame frame = this._project.showInInternalFrame(instance);
        Map<Instance, Rectangle> propertyMap = this.getYellowStickyMap();
        Rectangle r = propertyMap.get(instance);
        if (r == null) {
            frame.setLocation(this.getNextYellowStickyPosition());
            propertyMap.put(instance, frame.getBounds());
        } else {
            frame.setBounds(r);
        }
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                InstanceDisplay.this.getYellowStickyMap().put(instance, event.getComponent().getBounds());
            }

            public void componentMoved(ComponentEvent event) {
                InstanceDisplay.this.getYellowStickyMap().put(instance, event.getComponent().getBounds());
            }
        });
        frame.setFrameIcon(this.getNoteIcon());
        return frame;
    }

    private Icon getNoteIcon() {
        Icon icon = this._currentInstance instanceof Cls ? Icons.getIcon(ResourceKey.CLASS_NOTE) : (this._currentInstance instanceof Slot ? Icons.getIcon(ResourceKey.SLOT_NOTE) : Icons.getIcon(ResourceKey.INSTANCE_NOTE));
        return icon;
    }

    private void reloadForm() {
        Instance instance = this._currentInstance;
        Cls cls = this._currentAssociatedCls;
        this.removeCurrentWidgets();
        this.setInstance(instance, cls);
    }

    private void removeAllStickies() {
        for (Component c : new ArrayList<Component>(Arrays.asList(this.getComponents()))) {
            if (!(c instanceof JInternalFrame)) continue;
            JInternalFrame frame = (JInternalFrame)c;
            frame.setVisible(false);
            frame.dispose();
            this.remove(frame);
        }
    }

    protected void removeCurrentWidgets() {
        for (ClsWidget widget : this._currentWidgets) {
            widget.getCls().removeClsListener(this._clsListener);
            widget.getCls().removeFrameListener(this._frameListener);
            widget.removeWidgetListener(this._widgetListener);
        }
        Component c = this._scrollPane.getViewport().getView();
        this._scrollPane.setViewportView(null);
        ComponentUtilities.dispose(c);
        this._currentWidgets.clear();
        if (this._currentInstance != null) {
            this._currentInstance.removeInstanceListener(this._instanceListener);
        }
        this._currentInstance = null;
        this._currentAssociatedCls = null;
        this.update();
    }

    private void removeSticky(Instance instance) {
        for (Component c : new ArrayList<Component>(Arrays.asList(this.getComponents()))) {
            JInternalFrame frame;
            InstanceDisplay display;
            if (!(c instanceof JInternalFrame) || !InstanceDisplay.equals((display = (InstanceDisplay)(frame = (JInternalFrame)c).getContentPane().getComponent(0)).getCurrentInstance(), instance)) continue;
            frame.setVisible(false);
            frame.dispose();
            this.remove(frame);
            break;
        }
    }

    @Override
    @Deprecated
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this._child.setBounds(0, 0, w, h);
    }

    public void setInstance(Instance instance) {
        this.setInstance(instance, null);
    }

    public void setInstance(Instance instance, Cls associatedCls) {
        if (this._currentInstance != null) {
            this._currentInstance.removeInstanceListener(this._instanceListener);
        }
        if (instance == null) {
            this.removeCurrentWidgets();
        } else {
            if (this._currentWidgets.isEmpty()) {
                this.addRuntimeWidgets(instance, associatedCls);
            } else if (this.typesMatchCurrentWidgets(instance)) {
                for (ClsWidget clsWidget : this._currentWidgets) {
                    clsWidget.setInstance(instance);
                    clsWidget.setAssociatedCls(associatedCls);
                }
            } else {
                this.removeCurrentWidgets();
                this.addRuntimeWidgets(instance, associatedCls);
            }
            instance.addInstanceListener(this._instanceListener);
        }
        this._currentInstance = instance;
        this._currentAssociatedCls = associatedCls;
        if (this._header != null) {
            this.loadHeader();
        }
        this.updateStickies();
    }

    private boolean typesMatchCurrentWidgets(Instance instance) {
        boolean typesMatch = false;
        HashSet types = new HashSet(instance.getDirectTypes());
        if (types.size() == this._currentWidgets.size()) {
            typesMatch = true;
            for (ClsWidget widget : this._currentWidgets) {
                if (types.contains(widget.getCls())) continue;
                typesMatch = false;
                break;
            }
        }
        return typesMatch;
    }

    private void showAllStickies() {
        if (this._currentInstance != null) {
            for (Instance instance : this.getStickyInstances()) {
                this.showYellowSticky(instance);
            }
        }
    }

    private void showYellowSticky(Instance instance) {
        JInternalFrame frame = this.loadIntoFrame(instance);
        String author = (String)ModelUtilities.getDirectOwnSlotValue(instance, ":CREATOR");
        if (author == null || author.length() == 0) {
            author = "<unknown author>";
        }
        String timeString = InstanceDisplay.getTimeString(instance);
        String title = author;
        if (timeString != null) {
            title = title + ", " + timeString;
        }
        frame.setTitle(title);
        frame.setVisible(true);
        this.add(frame);
        frame.toFront();
        try {
            frame.setSelected(true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static String getTimeString(Instance instance) {
        String timeString = null;
        String timestamp = (String)ModelUtilities.getDirectOwnSlotValue(instance, ":CREATION-TIMESTAMP");
        if (timestamp != null) {
            StandardDateFormat formatter = new StandardDateFormat();
            try {
                Date date = ((DateFormat)formatter).parse(timestamp);
                GregorianCalendar calendar = new GregorianCalendar();
                int thisYear = calendar.get(1);
                calendar.setTime(date);
                int stickyYear = calendar.get(1);
                String pattern = "MMM dd " + (thisYear == stickyYear ? "" : "yyyy ") + "HH:mm";
                formatter.applyPattern(pattern);
                timeString = formatter.format(date);
            }
            catch (ParseException e) {
                Log.getLogger().warning(e.toString());
                timeString = timestamp;
            }
        }
        return timeString;
    }

    private void update() {
        this.revalidate();
        this.repaint();
    }

    private void updateStickies() {
        this.removeAllStickies();
        if (this._hideNotesButton != null && !this._hideNotesButton.isSelected()) {
            this.showAllStickies();
        }
    }
}

