/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.Finder;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListFinder
extends Finder {
    private static final long serialVersionUID = 220635605280533214L;
    protected JList _list;

    public ListFinder(JList list, ResourceKey key) {
        super(key);
        this._list = list;
    }

    public ListFinder(JList list, String description, Icon icon) {
        super(description, icon);
        this._list = list;
    }

    public ListFinder(JList list, String description) {
        this(list, description, Icons.getFindIcon());
    }

    protected int getBestMatch(List matches, String text) {
        return 0;
    }

    protected List getMatches(String text, int maxMatches) {
        if (!text.endsWith("*")) {
            text = text + "*";
        }
        SimpleStringMatcher matcher = new SimpleStringMatcher(text);
        ArrayList<Instance> matchingInstances = new ArrayList<Instance>();
        ListModel model = this._list.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Instance instance = (Instance)model.getElementAt(i);
            String browserText = instance.getBrowserText().toLowerCase();
            if (!matcher.isMatch(browserText)) continue;
            matchingInstances.add(instance);
        }
        return matchingInstances;
    }

    protected void select(Object o) {
        this._list.setSelectedValue(o, true);
    }
}

