/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MultiSlotPanel
extends JPanel {
    private static final long serialVersionUID = -2423974591715847895L;
    private Cls cls;
    private BrowserSlotPattern pattern;
    private List panels = new ArrayList();

    MultiSlotPanel(BrowserSlotPattern pattern, Cls cls) {
        this.cls = cls;
        this.pattern = pattern;
        this.createUI();
        this.loadUI();
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        ArrayList<Slot> slots = new ArrayList<Slot>(this.cls.getVisibleTemplateSlots());
        Slot nameSlot = this.cls.getKnowledgeBase().getNameSlot();
        if (!slots.contains(nameSlot)) {
            slots.add(nameSlot);
        }
        Collections.sort(slots, new FrameComparator());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        c.insets = new Insets(2, 2, 8, 2);
        c.anchor = 23;
        this.add((Component)ComponentFactory.createLabel("Set display slots and optional text:"), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.5;
        this.add((Component)this.createTextPanel(), c);
        int i = 1;
        while (i <= 4) {
            c.gridy = i++;
            this.addComponentRow(c, slots);
        }
    }

    private JComponent createTextPanel() {
        JTextField textField = ComponentFactory.createTextField();
        textField.setColumns(2);
        this.panels.add(textField);
        return textField;
    }

    private JComponent createSlotPanel(Collection slots) {
        JComboBox slotBox = ComponentFactory.createComboBox();
        slotBox.setRenderer(new FrameRenderer());
        ArrayList values = new ArrayList(slots);
        values.add(0, null);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(values.toArray());
        slotBox.setModel(model);
        slotBox.setSelectedItem(null);
        this.panels.add(slotBox);
        return slotBox;
    }

    private void addComponentRow(GridBagConstraints c, Collection slots) {
        c.gridx = 1;
        c.weightx = 1.0;
        this.add((Component)this.createSlotPanel(slots), c);
        c.gridx = 2;
        c.weightx = 0.5;
        this.add((Component)this.createTextPanel(), c);
        c.gridx = 3;
        c.weightx = 1.0;
        this.add((Component)this.createSlotPanel(slots), c);
        c.gridx = 4;
        c.weightx = 0.5;
        this.add((Component)this.createTextPanel(), c);
    }

    private void loadUI() {
        if (this.pattern != null) {
            Iterator j = this.panels.iterator();
            Iterator i = this.pattern.getElements().iterator();
            while (i.hasNext() && j.hasNext()) {
                Object o = i.next();
                Object panel = j.next();
                if (o instanceof String) {
                    if (!(panel instanceof JTextField)) {
                        panel = j.next();
                    }
                    JTextField field = (JTextField)panel;
                    field.setText((String)o);
                    continue;
                }
                if (!(panel instanceof JComboBox)) {
                    panel = j.next();
                }
                JComboBox box = (JComboBox)panel;
                box.setSelectedItem(o);
            }
        }
    }

    public BrowserSlotPattern getBrowserTextPattern() {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object o : this.panels) {
            if (o instanceof JTextField) {
                JTextField textField = (JTextField)o;
                String text = textField.getText();
                if (text == null || text.length() <= 0) continue;
                elements.add(text);
                continue;
            }
            JComboBox box = (JComboBox)o;
            Object slot = box.getSelectedItem();
            if (slot == null) continue;
            elements.add(slot);
        }
        return new BrowserSlotPattern(elements);
    }
}

