/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.ui.TabbedPaneInterface;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MyCardPanel
extends JPanel
implements TabbedPaneInterface {
    private static final long serialVersionUID = 3550023384666732594L;
    private CardLayout layout = new CardLayout();
    private ChangeListener changeListener;

    MyCardPanel() {
        this.setLayout(this.layout);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener = null;
    }

    public void setSelectedComponent(Component component) {
        this.layout.show(this, component.getName());
    }

    public Component getSelectedComponent() {
        Component component = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component child = this.getComponent(i);
            if (!child.isVisible()) continue;
            component = child;
            break;
        }
        return component;
    }

    public void removeTabAt(int index) {
        this.remove(index);
    }

    public int indexOfComponent(Component component) {
        int index = -1;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component child = this.getComponent(i);
            if (child != component) continue;
            index = i;
            break;
        }
        return index;
    }

    public int getSelectedIndex() {
        return this.indexOfComponent(this.getSelectedComponent());
    }

    public void setSelectedIndex(int index) {
        this.setSelectedComponent(this.getComponent(index));
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void addTab(String title, Icon icon, Component c, String helpText) {
        c.setName(title);
        this.add(c, title);
    }

    public void insertTab(String title, Icon icon, Component c, String helpText, int index) {
        c.setName(title);
        this.add(c, title, index);
    }
}

