/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.util.DefaultRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class OtherFacetsRenderer
extends DefaultRenderer {
    private static final long serialVersionUID = 2666897368349118508L;

    private static void addAllowedValuesText(StringBuffer s, Cls cls, Slot slot) {
        if (OtherFacetsRenderer.equals(cls.getTemplateSlotValueType(slot), ValueType.SYMBOL)) {
            Collection values = cls.getTemplateSlotAllowedValues(slot);
            OtherFacetsRenderer.appendValues(s, "allowed-values", values);
        }
    }

    private static void addDefaultValuesText(StringBuffer s, Cls cls, Slot slot) {
        Collection defaults = cls.getTemplateSlotDefaultValues(slot);
        if (!defaults.isEmpty()) {
            OtherFacetsRenderer.addObjects(s, "default", defaults);
        }
    }

    private static void addObjects(StringBuffer s, String text, Collection objects) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object o : objects) {
            String name = o instanceof Frame ? ((Frame)o).getBrowserText() : o.toString();
            strings.add(name);
        }
        OtherFacetsRenderer.appendValues(s, text, strings);
    }

    private static void addRangeText(StringBuffer s, Cls cls, Slot slot, ValueType type) {
        Number min = cls.getTemplateSlotMinimumValue(slot);
        Number max = cls.getTemplateSlotMaximumValue(slot);
        if (OtherFacetsRenderer.equals(type, ValueType.INTEGER)) {
            if (min != null) {
                min = new Integer(min.intValue());
            }
            if (max != null) {
                max = new Integer(max.intValue());
            }
        }
        if (min != null) {
            s.append("minimum=");
            s.append(min);
        }
        if (min != null && max != null) {
            s.append(", ");
        }
        if (max != null) {
            s.append("maximum=");
            s.append(max);
        }
        if (min != null || max != null) {
            s.append(' ');
        }
    }

    private static void addValuesText(StringBuffer s, Cls cls, Slot slot) {
        Collection values = cls.getTemplateSlotValues(slot);
        if (!values.isEmpty()) {
            OtherFacetsRenderer.addObjects(s, "value", values);
        }
    }

    private static void appendValues(StringBuffer s, String text, Collection values) {
        boolean first = true;
        s.append(text);
        s.append("=");
        if (values.size() > 1) {
            s.append("{");
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                s.append(',');
            }
            s.append(i.next());
        }
        if (values.size() > 1) {
            s.append("}");
        }
        s.append(" ");
    }

    private static void addInverseSlotText(StringBuffer buffer, Slot slot) {
        Slot inverseSlot = slot.getInverseSlot();
        if (inverseSlot != null) {
            buffer.append("inverse-slot=");
            buffer.append(inverseSlot.getBrowserText());
            buffer.append(" ");
        }
    }

    public void load(Object o) {
        FrameSlotCombination combination = (FrameSlotCombination)o;
        Cls cls = (Cls)combination.getFrame();
        Slot slot = combination.getSlot();
        ValueType type = cls.getTemplateSlotValueType(slot);
        StringBuffer text = new StringBuffer();
        if (OtherFacetsRenderer.equals(type, ValueType.INTEGER) || OtherFacetsRenderer.equals(type, ValueType.FLOAT)) {
            OtherFacetsRenderer.addRangeText(text, cls, slot, type);
        } else if (OtherFacetsRenderer.equals(type, ValueType.SYMBOL)) {
            OtherFacetsRenderer.addAllowedValuesText(text, cls, slot);
        }
        OtherFacetsRenderer.addValuesText(text, cls, slot);
        OtherFacetsRenderer.addDefaultValuesText(text, cls, slot);
        OtherFacetsRenderer.addInverseSlotText(text, slot);
        if (!cls.isEditable()) {
            this.setGrayedText(true);
        }
        this.setMainText(text.toString());
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }
}

