/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.ParentChildNodeComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class ParentChildNode
extends LazyTreeNode {
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSubclassAdded(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (event.getSubclass().isVisible()) {
                ParentChildNode.this.childAdded(event.getSubclass());
            }
        }

        public void directSubclassRemoved(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (event.getSubclass().isVisible()) {
                ParentChildNode.this.childRemoved(event.getSubclass());
            }
        }

        public void directSubclassMoved(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            Cls subclass = event.getSubclass();
            int index = new ArrayList(ParentChildNode.this.getChildObjects()).indexOf(subclass);
            if (index != -1) {
                ParentChildNode.this.childRemoved(subclass);
                ParentChildNode.this.childAdded(subclass, index);
            }
        }

        public void directInstanceAdded(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void directInstanceRemoved(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void templateFacetValueChanged(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void directSuperclassAdded(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void frameReplaced(FrameEvent event) {
            Frame oldFrame = event.getFrame();
            Frame newFrame = event.getNewFrame();
            Cls cls = ParentChildNode.this.getCls();
            if (cls != null && cls.equals(oldFrame)) {
                ParentChildNode.this.reload(newFrame);
            }
        }

        public void browserTextChanged(FrameEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (event.getSlot().getName().equals(":DIRECT-TYPE")) {
                Cls cls = ParentChildNode.this.getCls().getKnowledgeBase().getCls(ParentChildNode.this.getCls().getName());
                ParentChildNode.this.reload(cls);
            } else {
                ParentChildNode.this.notifyNodeChanged();
            }
        }

        public void visibilityChanged(FrameEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }
    };

    public ParentChildNode(LazyTreeNode parentNode, Cls parentCls) {
        super(parentNode, parentCls, parentNode.isSorted());
        parentCls.addClsListener(this._clsListener);
        parentCls.addFrameListener(this._frameListener);
    }

    protected LazyTreeNode createNode(Object o) {
        return new ParentChildNode((LazyTreeNode)this, (Cls)o);
    }

    protected void dispose() {
        super.dispose();
        this.getCls().removeClsListener(this._clsListener);
        this.getCls().removeFrameListener(this._frameListener);
    }

    protected int getChildObjectCount() {
        return this.showHidden() ? this.getCls().getDirectSubclassCount() : this.getCls().getVisibleDirectSubclassCount();
    }

    protected Collection getChildObjects() {
        return this.showHidden() ? this.getCls().getDirectSubclasses() : this.getCls().getVisibleDirectSubclasses();
    }

    protected Cls getCls() {
        return (Cls)this.getUserObject();
    }

    protected Comparator getComparator() {
        return new ParentChildNodeComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    private boolean showHidden() {
        return this.getCls().getProject().getDisplayHiddenClasses();
    }

    public String toString() {
        return "ParentChildNode(" + this.getCls() + ")";
    }
}

