/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.StringUtilities;
import java.util.Comparator;

public class ParentChildNodeComparator
implements Comparator {
    private static final char SPECIAL_NAME_CHAR_1 = ':';
    private static final char SPECIAL_NAME_CHAR_2 = '\'';

    public int compare(Object o1, Object o2) {
        if (o1 instanceof LazyTreeNode) {
            o1 = ((LazyTreeNode)o1).getUserObject();
        }
        if (o2 instanceof LazyTreeNode) {
            o2 = ((LazyTreeNode)o2).getUserObject();
        }
        Frame f1 = (Frame)o1;
        Frame f2 = (Frame)o2;
        String t1 = f1.getBrowserText();
        String t2 = f2.getBrowserText();
        int result = ParentChildNodeComparator.isSpecialName(t1) ? (ParentChildNodeComparator.isSpecialName(t2) ? ParentChildNodeComparator.compareStrings(t1, t2) : -1) : (ParentChildNodeComparator.isSpecialName(t2) ? 1 : ParentChildNodeComparator.compareStrings(t1, t2));
        return result;
    }

    private static boolean isSpecialName(String s) {
        return s.length() > 0 && s.charAt(0) == ':';
    }

    private static int compareStrings(String s1, String s2) {
        int result = (s1 = StringUtilities.unquote(s1)).compareToIgnoreCase(s2 = StringUtilities.unquote(s2));
        if (result == 0) {
            result = s1.compareTo(s2);
        }
        return result;
    }
}

