/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory2;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.plugin.ImportPlugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.plugin.ProjectPluginManager;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.util.RemoteProjectUtil;
import edu.stanford.smi.protege.storage.clips.ParseErrorPanel;
import edu.stanford.smi.protege.ui.ArchivePanel;
import edu.stanford.smi.protege.ui.ConfigureProjectPanel;
import edu.stanford.smi.protege.ui.FactoryRenderer;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.RevertProjectPanel;
import edu.stanford.smi.protege.ui.ViewSelector;
import edu.stanford.smi.protege.ui.WindowComparator;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.ModalDialogCloseDoubleClickAdapter;
import edu.stanford.smi.protege.util.ProjectChooser;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ProjectManager {
    private static ProjectManager _projectManager = new ProjectManager();
    private ProjectPluginManager _projectPluginManager = new ProjectPluginManager();
    private Project _currentProject;
    private JRootPane _rootPane;
    private ProjectMenuBar _menuBar;
    private ProjectToolBar _mainToolBar;
    private ProjectView _projectView;
    private ViewSelector _viewSelector;
    private JPanel _headerPanel;
    private boolean _doExitVM = true;
    private JFrame _errorFrame;
    private JComponent _toolBarHolder;

    private ProjectManager() {
    }

    private static void advance(Point p) {
        p.x += 25;
        p.y += 25;
    }

    public void buildProjectRequest() {
        KnowledgeBaseFactory factory;
        if (this.closeProjectRequest() && (factory = this.promptForFactory()) != null) {
            this.importSources(factory);
        }
    }

    public boolean buildProject(KnowledgeBaseFactory factory) {
        boolean succeeded = true;
        if (factory != null) {
            succeeded = this.importSources(factory);
        }
        return succeeded;
    }

    public void importProjectRequest(ImportPlugin plugin) {
        if (this.closeProjectRequest()) {
            this._currentProject = plugin.handleImportRequest();
            if (this._currentProject != null) {
                this.displayCurrentProject();
            }
        }
    }

    public void exportProjectRequest(ExportPlugin plugin) {
        plugin.handleExportRequest(this._currentProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importSources(KnowledgeBaseFactory factory) {
        Project p;
        boolean succeeded = false;
        ArrayList errors = new ArrayList();
        if (factory != null && (succeeded = this.loadNewSources(p = Project.createBuildProject(factory, errors), factory, false))) {
            WaitCursor waitCursor = new WaitCursor(this._rootPane);
            try {
                p.createDomainKnowledgeBase(factory, errors, true);
                this._currentProject = p;
                this._projectPluginManager.afterLoad(p);
                this.displayCurrentProject();
            }
            finally {
                waitCursor.hide();
            }
            this.displayErrors("Build Project Errors", errors);
        }
        return succeeded;
    }

    public void cascadeWindows(Point p, Collection w) {
        ArrayList windows = new ArrayList(w);
        Collections.sort(windows, new WindowComparator());
        for (Window window : windows) {
            window.setLocation(p);
            window.toFront();
            window.requestFocus();
            ProjectManager.advance(p);
        }
    }

    public void cascadeWindowsRequest() {
        Project project = this.getCurrentProject();
        if (project != null) {
            Point startPoint = SwingUtilities.windowForComponent(this._rootPane).getLocation();
            startPoint.x += 25;
            startPoint.y += 110;
            this.cascadeWindows(startPoint, project.getOpenWindows());
        }
    }

    public void changeProjectStorageFormatRequest() {
        if (this.hasLoadedProject()) {
            boolean succeeded;
            KnowledgeBaseFactory oldFactory = this._currentProject.getKnowledgeBase().getKnowledgeBaseFactory();
            KnowledgeBaseFactory factory = this.promptForFactory();
            boolean bl = succeeded = factory != null && factory != oldFactory;
            if (succeeded) {
                succeeded = this.loadNewSources(this._currentProject, factory, true);
            }
            if (succeeded) {
                if (this._currentProject.hasCompleteSources()) {
                    if (succeeded) {
                        succeeded = this.prepareToSave(oldFactory, factory);
                    }
                    boolean oldIsReadonly = this._currentProject.isReadonly();
                    if (succeeded) {
                        this._currentProject.setIsReadonly(false);
                        succeeded = this.save();
                    }
                    if (succeeded) {
                        URI uri = this._currentProject.getProjectURI();
                        this.closeCurrentProject();
                        this.loadProject(uri);
                    } else {
                        this._currentProject.setIsReadonly(oldIsReadonly);
                    }
                } else {
                    Log.getLogger().warning("Sources are not complete");
                }
            }
        }
    }

    public boolean closeProjectRequest() {
        boolean succeeded = true;
        if (this.hasLoadedProject()) {
            ProjectManager.commitChanges();
            if (this._currentProject.isDirty()) {
                succeeded = this.confirmSave();
            }
            if (succeeded) {
                succeeded = this.closeCurrentProject();
            }
        }
        return succeeded;
    }

    public boolean closeCurrentProject() {
        ProjectView prjView = this.getCurrentProjectView();
        if (prjView == null) {
            return true;
        }
        boolean succeeded = prjView.canClose();
        if (succeeded) {
            this._projectPluginManager.beforeHide(this._projectView, this._mainToolBar, this._menuBar);
            this._projectView.setVisible(false);
            this._projectView.close();
            ComponentUtilities.closeAllWindows();
            this._rootPane.getContentPane().remove(this._projectView);
            ComponentUtilities.dispose(this._projectView);
            this._projectView = null;
            this._viewSelector = null;
            this._projectPluginManager.beforeClose(this._currentProject);
            this._currentProject.dispose();
            this._currentProject = null;
            this.updateFrameTitle();
            this.createMenuAndToolBar();
            this._rootPane.revalidate();
            this._rootPane.repaint();
        }
        return succeeded;
    }

    public void configureProjectRequest() {
        String title;
        ConfigureProjectPanel panel;
        int result;
        Project p = this.getCurrentProject();
        boolean displayHidden = p.getDisplayHiddenClasses();
        boolean displayTabbedInstanceForm = p.getTabbedInstanceFormLayout();
        boolean addNameOnInstanceForm = p.getAddNameOnInstanceForm();
        boolean supressInstancesCountDisplay = p.getSuppressInstanceCounting();
        if (p != null && (result = ModalDialog.showDialog(this._rootPane, panel = new ConfigureProjectPanel(p), title = "Configure " + p.getProjectURI(), 11)) == 1) {
            boolean needToRegenerate = displayHidden != p.getDisplayHiddenClasses() || displayTabbedInstanceForm != p.getTabbedInstanceFormLayout() || addNameOnInstanceForm != p.getAddNameOnInstanceForm() || supressInstancesCountDisplay != p.getSuppressInstanceCounting();
            this.reloadUI(needToRegenerate);
        }
    }

    private boolean confirmSave() {
        boolean succeeded;
        JLabel c = ComponentFactory.createLabel("Do you want to save changes to the current project?");
        int result = ModalDialog.showDialog(this._rootPane, c, "Save?", 12);
        switch (result) {
            case 2: {
                succeeded = this.saveProjectRequest();
                break;
            }
            case 3: {
                succeeded = true;
                break;
            }
            case 4: 
            case 5: {
                succeeded = false;
                break;
            }
            default: {
                Assert.fail("bad result: " + result);
                succeeded = false;
            }
        }
        return succeeded;
    }

    private void displayCurrentProject() {
        this.displayCurrentProject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayCurrentProject(boolean remote) {
        WaitCursor waitCursor = new WaitCursor(this._rootPane);
        try {
            this.createMenuAndToolBar();
            this._projectView = new ProjectView(this._currentProject);
            if (remote) {
                RemoteProjectUtil.configure(this._projectView);
            }
            this.addViewSelector(this._projectView);
            this._rootPane.getContentPane().add((Component)this._projectView, "Center");
            this._projectView.revalidate();
            this._projectView.repaint();
            this._projectPluginManager.afterShow(this._projectView, this._mainToolBar, this._menuBar);
            this._rootPane.revalidate();
        }
        finally {
            waitCursor.hide();
        }
        this.updateFrameTitle();
    }

    public JMenuBar getCurrentProjectMenuBar() {
        return this._menuBar;
    }

    @Deprecated
    public JToolBar getCurrentProjectToolBar() {
        return this.getCurrentProjectMainToolBar();
    }

    public JToolBar getCurrentProjectMainToolBar() {
        return this._mainToolBar;
    }

    public void displayErrors(String label, Collection errors) {
        if (!errors.isEmpty() && ProjectManager.getProjectManager().getMainPanel() != null) {
            ParseErrorPanel panel = new ParseErrorPanel(errors);
            this._errorFrame = ComponentFactory.showInFrame(panel, label);
            this.bringErrorFrameToFront();
        } else {
            Log.handleErrors(Log.getLogger(), Level.WARNING, errors);
        }
    }

    public void bringErrorFrameToFront() {
        if (this._errorFrame != null && this._errorFrame.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectManager.this._errorFrame.toFront();
                }
            });
        }
    }

    public void exitApplicationRequest() {
        boolean succeeded = this.closeProjectRequest();
        if (succeeded) {
            try {
                Frame mainFrame = ComponentUtilities.getFrame(this._rootPane);
                ApplicationProperties.recordMainFrameProperties(mainFrame);
                ApplicationProperties.flush();
                ComponentUtilities.dispose(mainFrame);
            }
            catch (Throwable e) {
                Log.getLogger().warning("Errors at saving protege.properties");
            }
            if (this._doExitVM) {
                SystemUtilities.exit();
            }
        }
    }

    public Project getCurrentProject() {
        return this._currentProject;
    }

    public ProjectView getCurrentProjectView() {
        return this._projectView;
    }

    public JComponent getMainPanel() {
        return this._rootPane;
    }

    public static ProjectManager getProjectManager() {
        return _projectManager;
    }

    private static Project getRequestedProject(Component parent) {
        Project project = null;
        ProjectChooser chooser = new ProjectChooser();
        int rval = chooser.showOpenDialog(parent);
        if (rval == 0) {
            project = chooser.getProject();
        }
        return project;
    }

    private boolean hasLoadedProject() {
        return this._currentProject != null && this._currentProject.getProjectInstance() != null && this._currentProject.getKnowledgeBase() != null;
    }

    public void changeIncludedProjectURIsRequest(Collection includedProjectURIs) {
        if (this.canChangeIncludedProjectURIs(includedProjectURIs)) {
            this._currentProject.setDirectIncludedProjectURIs(includedProjectURIs);
            boolean succeeded = this.saveProjectRequest();
            if (succeeded) {
                this.reload();
            }
        }
    }

    public void setActiveProjectURI(URI projectURI) {
        this._currentProject.setActiveRootURI(projectURI);
        this.reloadUI(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        URI uri = this.getCurrentProject().getProjectURI();
        WaitCursor waitCursor = new WaitCursor(this._rootPane);
        try {
            this.closeProjectRequest();
            this.loadProject(uri);
        }
        finally {
            waitCursor.hide();
        }
    }

    private boolean canChangeIncludedProjectURIs(Collection newIncludedProjectURIs) {
        boolean canChange;
        HashSet newIncludedProjectURISet;
        Project p = this.getCurrentProject();
        boolean needsProjectName = p.getProjectURI() == null;
        HashSet<URI> currentIncludedProjectURISet = new HashSet<URI>(p.getDirectIncludedProjectURIs());
        if (CollectionUtilities.equalsSet(currentIncludedProjectURISet, newIncludedProjectURISet = new HashSet(newIncludedProjectURIs))) {
            canChange = false;
        } else {
            int rval;
            String text = "Changing the included projects will cause the current project to\nbe saved and reloaded. ";
            if (needsProjectName) {
                text = text + "You will need to first specify a name for your project.";
            }
            canChange = (rval = ModalDialog.showMessageDialog((Component)this._rootPane, text, 11)) == 1;
        }
        return canChange;
    }

    private boolean loadNewSources(Project project, KnowledgeBaseFactory factory, boolean showProject) {
        if (factory == null) {
            factory = project.getKnowledgeBaseFactory();
        }
        PropertyList sources = project.getSources();
        URI projectURI = project.getProjectURI();
        String s = projectURI == null ? null : projectURI.toString();
        KnowledgeBaseSourcesEditor editor = factory.createKnowledgeBaseSourcesEditor(s, sources);
        editor.setShowProject(showProject);
        String title = factory.getDescription();
        int result = ModalDialog.showDialog(this._rootPane, editor, title, 11);
        if (result == 1) {
            sources.setString("factory_class_name", factory.getClass().getName());
            project.setProjectURI(URIUtilities.createURI(editor.getProjectPath()));
            for (URI uri : editor.getIncludedProjects()) {
                project.includeProject(uri, false, null);
            }
        }
        return result == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject(URI uri) {
        long t1 = System.currentTimeMillis();
        ArrayList<MessageError> errors = new ArrayList<MessageError>();
        WaitCursor waitCursor = new WaitCursor(this._rootPane);
        try {
            if (uri == null) {
                KnowledgeBaseFactory factory = this.promptForFactory();
                t1 = System.currentTimeMillis();
                if (factory != null) {
                    this._currentProject = this.createNewProject(factory, errors);
                }
            } else {
                this._currentProject = this.loadProjectFromURI(uri, errors);
            }
        }
        finally {
            waitCursor.hide();
        }
        long t2 = System.currentTimeMillis();
        if (this._currentProject != null && this._currentProject.getProjectInstance() == null) {
            String errorMsg = "Unable to load file: " + uri + "\nPossible reasons:\n- The file has an unsupported file format\n- The file is not well-formed\n- The project file is corrupt";
            Log.getLogger().severe(errorMsg);
            errors.add(new MessageError(null, errorMsg));
        }
        this.displayErrors("Load Project Errors", errors);
        if (this._currentProject != null && this._currentProject.getProjectInstance() != null && this._currentProject.getKnowledgeBase() != null) {
            this.displayCurrentProject();
            this.printLoadTimes(t1, t2);
        }
    }

    private Project createNewProject(KnowledgeBaseFactory factory, Collection errors) {
        Project project = Project.createNewProject(factory, errors);
        this._projectPluginManager.afterCreate(project);
        return project;
    }

    public Project loadProjectFromURI(URI uri, Collection errors) {
        Project project = null;
        try {
            project = Project.loadProjectFromURI(uri, errors);
            this._projectPluginManager.afterLoad(project);
        }
        catch (Exception e) {
            errors.add(new MessageError(e));
            Log.getLogger().log(Level.FINE, "Error loading project", e);
        }
        return project;
    }

    public void loadProject(URI uri, KnowledgeBaseFactory factory) {
        ArrayList errors = new ArrayList();
        long t0 = System.currentTimeMillis();
        long t1 = 0L;
        if (factory != null) {
            this._currentProject = uri == null ? this.createNewProject(factory, errors) : this.loadProjectFromURI(uri, errors);
            t1 = System.currentTimeMillis();
        }
        if (this._currentProject != null) {
            this.displayErrors("Load Project Errors", errors);
            this.displayCurrentProject();
            this.printLoadTimes(t0, t1);
        }
    }

    public void mergeIncludedProjectsRequest() {
        if (this.hasLoadedProject() && this._currentProject.hasIncludedProjects()) {
            String text = "This action will make all included frames in the knowledge base direct members of the current project.";
            String title = " " + Text.getProgramName() + ": " + LocalizedText.getText(ResourceKey.PROJECT_MERGE_INCLUDED);
            JComponent parent = ProjectManager.getProjectManager().getMainPanel();
            int rval = ModalDialog.showMessageDialog(parent, text, title, 11);
            if (rval == 1) {
                this._currentProject.mergeIncludedProjects();
            }
        }
    }

    public boolean createNewProjectRequest() {
        CreateProjectWizard wizard;
        int result;
        boolean succeeded = false;
        if (this.closeProjectRequest() && (result = (wizard = new CreateProjectWizard(this.getMainPanel())).execute()) == 1) {
            this._currentProject = wizard.getProject();
            this._projectPluginManager.afterCreate(this._currentProject);
            ProjectManager.getProjectManager().displayCurrentProject();
            succeeded = true;
        }
        return succeeded;
    }

    public void saveToFormatRequest() {
        Project newProject;
        ExportWizard wizard;
        int result;
        if (this.hasLoadedProject() && (result = (wizard = new ExportWizard(this.getMainPanel(), this._currentProject)).execute()) == 1 && (newProject = wizard.getNewProject()) != null) {
            this.closeCurrentProject();
            this._currentProject = newProject;
            this._projectPluginManager.afterCreate(newProject);
            ProjectManager.getProjectManager().displayCurrentProject();
        }
    }

    public void newProjectRequest() {
        if (this.closeProjectRequest()) {
            this.loadProject(null);
        }
    }

    public void openProjectRequest() {
        this.openProjectRequest(this._rootPane);
    }

    public boolean openProjectRequest(Component parent) {
        if (this.closeProjectRequest()) {
            this._currentProject = ProjectManager.getRequestedProject(parent);
            if (this._currentProject != null && this._currentProject.getProjectInstance() != null && this._currentProject.getKnowledgeBase() != null) {
                ApplicationProperties.addProjectToMRUList(this._currentProject.getProjectURI());
                long t1 = System.currentTimeMillis();
                this._projectPluginManager.afterLoad(this._currentProject);
                this.displayCurrentProject();
                ProjectManager.printDisplayTime(t1);
            }
            this.bringErrorFrameToFront();
        }
        return this._currentProject != null;
    }

    public void setCurrentProject(Project project) {
        this.setCurrentProject(project, true);
    }

    public void setCurrentProject(Project project, boolean remote) {
        this.setCurrentProject(project, remote, false);
    }

    public void setCurrentProject(Project project, boolean remote, boolean suppressDisplay) {
        if (this.closeProjectRequest()) {
            this._currentProject = project;
            if (this._currentProject != null) {
                this._projectPluginManager.afterLoad(this._currentProject);
                if (!suppressDisplay) {
                    this.displayCurrentProject(remote);
                }
            }
        }
    }

    private static void printDisplayTime(final long t1) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                long t2 = System.currentTimeMillis();
                Log.getLogger().info("UI display time = " + (t2 - t1) / 1000L + " sec");
            }
        });
    }

    private static Project getRequestedRemoteProject() {
        return RemoteProjectManager.getInstance().getRemoteProject();
    }

    public void openRemoteProjectRequest() {
        if (this.closeProjectRequest()) {
            long t1 = System.currentTimeMillis();
            this._currentProject = ProjectManager.getRequestedRemoteProject();
            long t2 = System.currentTimeMillis();
            if (this._currentProject != null) {
                this._projectPluginManager.afterLoad(this._currentProject);
                this.displayCurrentProject(true);
                this.printLoadTimes(t1, t2);
            }
        }
    }

    public Project openRemoteProjectRequest(String serverName, String username, String password, String projectName) {
        if (this.closeProjectRequest()) {
            long t1 = System.currentTimeMillis();
            this._currentProject = RemoteProjectManager.getInstance().getProject(serverName, username, password, projectName, true);
            long t2 = System.currentTimeMillis();
            if (this._currentProject != null) {
                this._projectPluginManager.afterLoad(this._currentProject);
                this.displayCurrentProject(true);
                this.printLoadTimes(t1, t2);
            }
        }
        return this._currentProject;
    }

    private void printLoadTimes(final long start, final long stopProject) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                long stopUI = System.currentTimeMillis();
                StringBuffer buffer = new StringBuffer();
                buffer.append("Load time for ");
                buffer.append(URIUtilities.getDisplayText(ProjectManager.this._currentProject.getProjectURI()));
                buffer.append(" = ");
                buffer.append((stopProject - start) / 1000L);
                buffer.append(" sec (project) + ");
                buffer.append((stopUI - stopProject) / 1000L);
                buffer.append(" sec (ui)");
                Log.getLogger().info(buffer.toString());
            }
        });
    }

    private KnowledgeBaseFactory promptForFactory() {
        FactoryPanel panel = new FactoryPanel();
        int rval = ModalDialog.showDialog(this._rootPane, panel, "Select Format", 11);
        return rval == 1 ? panel.getSelectedFactory() : null;
    }

    public void reloadUI(boolean regenerate) {
        ProjectView view = this.getCurrentProjectView();
        if (view != null) {
            view.reload(regenerate);
        }
        if (this._viewSelector != null) {
            this._viewSelector.reload();
        }
        this._menuBar.updateUI();
        Application.repaint();
    }

    private static void commitChanges() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        TextComponentWidget widget = (TextComponentWidget)SwingUtilities.getAncestorOfClass(TextComponentWidget.class, c);
        if (widget != null) {
            widget.commitChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save() {
        ArrayList<MessageError> errors = new ArrayList<MessageError>();
        ProjectManager.commitChanges();
        boolean save = this.getCurrentProjectView().attemptSave();
        if (save) {
            this._projectPluginManager.beforeSave(this._currentProject);
            WaitCursor waitCursor = new WaitCursor(this._rootPane);
            try {
                this._currentProject.save(errors);
            }
            catch (Exception e) {
                errors.add(new MessageError(e));
                Log.getLogger().log(Level.WARNING, "Errors at save", e);
            }
            finally {
                this._projectPluginManager.afterSave(this._currentProject);
                waitCursor.hide();
            }
            this.displayErrors("Save Project Errors", errors);
        }
        return save && errors.isEmpty();
    }

    public boolean saveProjectAsRequest() {
        return this.saveProjectAsRequest(null);
    }

    public boolean saveProjectAsRequest(KnowledgeBaseFactory factory) {
        boolean succeeded = true;
        if (this.hasLoadedProject() && (succeeded = this.loadNewSources(this._currentProject, factory, true))) {
            if (this._currentProject.hasCompleteSources()) {
                succeeded = this.save();
                if (succeeded) {
                    this.updateFrameTitle();
                    ApplicationProperties.addProjectToMRUList(this._currentProject.getProjectURI());
                }
            } else {
                Log.getLogger().warning("Sources are not complete");
            }
        }
        return succeeded;
    }

    private boolean prepareToSave(KnowledgeBaseFactory oldFactory, KnowledgeBaseFactory newFactory) {
        boolean succeeded = true;
        if (newFactory != null && newFactory != oldFactory && oldFactory instanceof KnowledgeBaseFactory2) {
            KnowledgeBaseFactory2 oldFactory2 = (KnowledgeBaseFactory2)oldFactory;
            ArrayList errors = new ArrayList();
            KnowledgeBase kb = this._currentProject.getKnowledgeBase();
            oldFactory2.prepareToSaveInFormat(kb, newFactory, errors);
            succeeded = errors.isEmpty();
        }
        return succeeded;
    }

    public boolean saveProjectRequest() {
        boolean succeeded = true;
        if (this.hasLoadedProject()) {
            succeeded = this._currentProject.hasCompleteSources() ? this.save() : this.saveProjectAsRequest(this._currentProject.getKnowledgeBaseFactory());
        }
        return succeeded;
    }

    public void setLookAndFeel(String lookAndFeelName) {
        try {
            SystemUtilities.setLookAndFeel(lookAndFeelName);
            ApplicationProperties.setLookAndFeel(lookAndFeelName);
            this.updateUI();
        }
        catch (Exception e) {
            Log.getLogger().warning(e.toString());
        }
    }

    public void setRootPane(JRootPane rootPane) {
        this._rootPane = rootPane;
        this.setupRootPane();
    }

    private void setupRootPane() {
        this.createMenuAndToolBar();
        this.updateFrameTitle();
    }

    private void createMenuAndToolBar() {
        Container contentPane = this._rootPane.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (this._headerPanel != null) {
            contentPane.remove(this._headerPanel);
        }
        this._headerPanel = new JPanel(new BorderLayout());
        this._headerPanel.setBackground(Color.WHITE);
        this._mainToolBar = new ProjectToolBar();
        Box panel = Box.createHorizontalBox();
        panel.setOpaque(false);
        panel.add(this._mainToolBar);
        this._headerPanel.add((Component)panel, "West");
        this._menuBar = new ProjectMenuBar();
        Box panel2 = Box.createHorizontalBox();
        panel2.setOpaque(false);
        JLabel icon = ComponentFactory.createLabel(Icons.getLogo());
        icon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        panel2.add(icon);
        this._headerPanel.add((Component)panel2, "East");
        this._toolBarHolder = Box.createHorizontalBox();
        this._toolBarHolder.setOpaque(false);
        this._headerPanel.add((Component)this._toolBarHolder, "South");
        this._rootPane.setJMenuBar(this._menuBar);
        contentPane.add((Component)this._headerPanel, "North");
    }

    private void addViewSelector(ProjectView view) {
        if (SystemUtilities.showAlphaFeatures()) {
            this._viewSelector = new ViewSelector(view);
            this._headerPanel.add((Component)this._viewSelector, "Center");
        }
    }

    public void addUserToolBar(JToolBar toolBar) {
        this._toolBarHolder.add(toolBar);
        this._toolBarHolder.revalidate();
    }

    public void removeUserToolBar(JToolBar toolBar) {
        this._toolBarHolder.remove(toolBar);
        this._toolBarHolder.revalidate();
    }

    public JToolBar getUserToolBar(String name) {
        JToolBar userToolBar = null;
        Component[] components = this._toolBarHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (!c.getName().equals(name)) continue;
            userToolBar = (JToolBar)c;
            break;
        }
        return userToolBar;
    }

    public String toString() {
        return "ProjectManager";
    }

    private void updateFrameTitle() {
        String text;
        String programName = Text.getProgramNameAndVersion();
        if (this._currentProject == null) {
            text = programName;
        } else {
            URI uri = this._currentProject.getProjectURI();
            if (uri == null) {
                text = "<new>  " + programName;
            } else {
                String shortname = URIUtilities.getBaseName(uri);
                String longname = URIUtilities.getDisplayText(uri);
                KnowledgeBaseFactory factory = this._currentProject.getKnowledgeBaseFactory();
                String backend = "";
                if (factory != null) {
                    backend = ", " + factory.getDescription();
                }
                text = shortname + "  " + programName + "    (" + longname + backend + (this._currentProject.isReadonly() ? " - Read-Only)" : ")");
            }
        }
        ComponentUtilities.setFrameTitle(this._rootPane, text);
    }

    public void updateLookAndFeel(Collection windows) {
        for (Window window : windows) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public void updateUI() {
        Window window = SwingUtilities.getWindowAncestor(this._rootPane);
        SwingUtilities.updateComponentTreeUI(window);
        this.reloadUI(true);
    }

    public void setExitVMOnApplicationExit(boolean exit) {
        this._doExitVM = exit;
    }

    public void requestRevertProject() {
        if (this._currentProject != null) {
            RevertProjectPanel panel = new RevertProjectPanel(this._currentProject);
            int rval = ModalDialog.showDialog(this.getMainPanel(), panel, "Revert to Archived Version", 11);
            Date timestamp = panel.getSelectedTimestamp();
            if (rval == 1 && timestamp != null) {
                Project newProject;
                ArchiveManager manager = ArchiveManager.getArchiveManager();
                boolean archive = panel.getArchiveCurrentVersion();
                if (archive) {
                    manager.archive(this._currentProject, "Automatic archive before revert");
                }
                if ((newProject = manager.revertToVersion(this._currentProject, timestamp)) != null) {
                    this.closeCurrentProject();
                    this._currentProject = newProject;
                    this.displayCurrentProject();
                } else {
                    ModalDialog.showMessageDialog(this.getMainPanel(), "Could not revert to archived project version.\nSee console for details.", "Revert to version", 14);
                }
            }
        }
    }

    public void archiveProjectRequest() {
        if (this._currentProject != null) {
            if (ArchivePanel.displayPanel()) {
                ArchivePanel panel = new ArchivePanel();
                int rval = ModalDialog.showDialog(this._rootPane, panel, "Archive Project", 11);
                if (rval == 1) {
                    String comment = panel.getComment();
                    this.archive(comment);
                }
            } else {
                this.archive(null);
            }
        }
    }

    private void archive(String comment) {
        ArchiveManager manager = ArchiveManager.getArchiveManager();
        manager.archive(this._currentProject, comment);
    }

    private static class FactoryPanel
    extends JPanel {
        private static final long serialVersionUID = 4971171312817011752L;
        private JList _list = ComponentFactory.createList(null);

        FactoryPanel() {
            this._list.addMouseListener(new ModalDialogCloseDoubleClickAdapter());
            this._list.setCellRenderer(new FactoryRenderer());
            ComponentUtilities.setListValues(this._list, PluginUtilities.getAvailableFactories());
            this._list.setSelectedIndex(0);
            this.setLayout(new BorderLayout());
            this.add(ComponentFactory.createScrollPane(this._list));
            this.setPreferredSize(new Dimension(300, 100));
        }

        public KnowledgeBaseFactory getSelectedFactory() {
            return (KnowledgeBaseFactory)this._list.getSelectedValue();
        }
    }
}

