/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ArchiveProject;
import edu.stanford.smi.protege.action.AutosynchronizeTrees;
import edu.stanford.smi.protege.action.CascadeWindows;
import edu.stanford.smi.protege.action.ChangeProjectStorageFormat;
import edu.stanford.smi.protege.action.Clear;
import edu.stanford.smi.protege.action.CloseAllWindows;
import edu.stanford.smi.protege.action.CloseCurrentView;
import edu.stanford.smi.protege.action.CloseProject;
import edu.stanford.smi.protege.action.ConfigureProject;
import edu.stanford.smi.protege.action.Copy;
import edu.stanford.smi.protege.action.CreateProject;
import edu.stanford.smi.protege.action.Cut;
import edu.stanford.smi.protege.action.DecreaseFontSize;
import edu.stanford.smi.protege.action.DetachCurrentView;
import edu.stanford.smi.protege.action.DisplayHtml;
import edu.stanford.smi.protege.action.ExitApplication;
import edu.stanford.smi.protege.action.ExportPluginAction;
import edu.stanford.smi.protege.action.IncreaseFontSize;
import edu.stanford.smi.protege.action.InsertUnicodeCharacterAction;
import edu.stanford.smi.protege.action.JFrameToFront;
import edu.stanford.smi.protege.action.LookAndFeelAction;
import edu.stanford.smi.protege.action.ManageIncludedProjectsAction;
import edu.stanford.smi.protege.action.MergeIncludedProjects;
import edu.stanford.smi.protege.action.OpenProject;
import edu.stanford.smi.protege.action.Paste;
import edu.stanford.smi.protege.action.PlasticLookAndFeelAction;
import edu.stanford.smi.protege.action.RedoAction;
import edu.stanford.smi.protege.action.RevertProject;
import edu.stanford.smi.protege.action.SaveProject;
import edu.stanford.smi.protege.action.SaveProjectAs;
import edu.stanford.smi.protege.action.SaveProjectToFormat;
import edu.stanford.smi.protege.action.SetPreferences;
import edu.stanford.smi.protege.action.ShowAboutBox;
import edu.stanford.smi.protege.action.ShowAboutPluginsBox;
import edu.stanford.smi.protege.action.ShowCommandHistoryAction;
import edu.stanford.smi.protege.action.ShowEncodingAndLocales;
import edu.stanford.smi.protege.action.ShowIconDialog;
import edu.stanford.smi.protege.action.ShowMetrics;
import edu.stanford.smi.protege.action.SynchronizeTrees;
import edu.stanford.smi.protege.action.UndoAction;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.plugin.Plugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.PluginComparator;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ProjectMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 4169911089158397522L;
    private ButtonGroup _group = new ButtonGroup();
    private Map uris = new HashMap();
    private static final int MAX_LENGTH = 50;
    private JMenu helpMenu;

    public ProjectMenuBar() {
        this.createFileMenu();
        this.createEditMenu();
        this.createProjectMenu();
        this.createWindowMenu();
        this.createHelpMenu();
    }

    private void createEditMenu() {
        JMenu menu = ComponentFactory.createMenu(ResourceKey.MENUBAR_EDIT);
        ProjectMenuBar.createItem(menu, new UndoAction(false));
        ProjectMenuBar.createItem(menu, new RedoAction(false));
        ProjectMenuBar.createItem(menu, new ShowCommandHistoryAction());
        menu.addSeparator();
        ProjectMenuBar.createItem(menu, new Cut(false));
        ProjectMenuBar.createItem(menu, new Copy(false));
        ProjectMenuBar.createItem(menu, new Paste(false));
        ProjectMenuBar.createItem(menu, new Clear(false));
        menu.addSeparator();
        ProjectMenuBar.createItem(menu, new InsertUnicodeCharacterAction());
        this.add(menu);
    }

    public JMenu add(JMenu menu) {
        if (this.helpMenu == null) {
            super.add(menu);
        } else {
            int last = this.getComponentCount() - 1;
            this.add((Component)menu, last);
        }
        return menu;
    }

    private void createHelpMenu() {
        JMenu menu = ComponentFactory.createMenu(ResourceKey.MENUBAR_HELP);
        this.add(menu);
        this.helpMenu = menu;
        ComponentFactory.addMenuItemNoIcon(menu, new DisplayHtml(ResourceKey.HELP_MENU_GETTING_STARTED, ApplicationProperties.getGettingStartedURLString()));
        ComponentFactory.addMenuItemNoIcon(menu, new DisplayHtml(ResourceKey.HELP_MENU_FAQ, ApplicationProperties.getFAQURLString()));
        ComponentFactory.addMenuItemNoIcon(menu, new DisplayHtml(ResourceKey.HELP_MENU_USERS_GUIDE, ApplicationProperties.getUsersGuideURLString()));
        ComponentFactory.addMenuItemNoIcon(menu, new DisplayHtml(ResourceKey.HELP_MENU_ONTOLOGIES_101, ApplicationProperties.getOntology101URLString()));
        this.addPluginDocSubmenu();
        menu.addSeparator();
        ComponentFactory.addMenuItemNoIcon(menu, new ShowIconDialog());
        menu.addSeparator();
        ComponentFactory.addMenuItemNoIcon(menu, new ShowAboutBox());
        ComponentFactory.addMenuItemNoIcon(menu, new ShowAboutPluginsBox());
        ComponentFactory.addMenuItemNoIcon(menu, new DisplayHtml(ResourceKey.HELP_MENU_CITE_PROTEGE, ApplicationProperties.getHowToCiteProtegeURLString()));
    }

    private void addPluginDocSubmenu() {
        JMenu menu = ComponentFactory.createMenu(ResourceKey.HELP_MENU_PLUGINS);
        ComponentFactory.addSubmenu(this.helpMenu, menu);
        for (String name : PluginUtilities.getPluginComponentNames()) {
            URL url = PluginUtilities.getPluginComponentDocURL(name);
            if (url == null) continue;
            ComponentFactory.addMenuItemNoIcon(menu, new DisplayHtml(name, url.toString()));
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
    }

    private static void createItem(JMenu menu, Action action) {
        ComponentFactory.addMenuItem(menu, action);
    }

    private static void createCheckBoxItem(JMenu menu, Action action, boolean selected) {
        ComponentFactory.addCheckBoxMenuItem(menu, action, selected);
    }

    private void addLookAndFeel(JMenu menu, LookAndFeelAction action) {
        JRadioButtonMenuItem item = ComponentFactory.createRadioButtonMenuItem(action);
        this._group.add(item);
        if (action.isCurrent()) {
            this._group.setSelected(item.getModel(), true);
        }
        menu.add(item);
    }

    private JMenu createLAFMenu() {
        JMenu menu = ComponentFactory.createMenu(ResourceKey.LOOK_AND_FEEL);
        this.addLookAndFeel(menu, new PlasticLookAndFeelAction());
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeels.length; ++i) {
            String name = lookAndFeels[i].getName();
            String className = lookAndFeels[i].getClassName();
            this.addLookAndFeel(menu, new LookAndFeelAction(name, className));
        }
        return menu;
    }

    private void createProjectMenu() {
        JMenu menu = ComponentFactory.createMenu(ResourceKey.MENUBAR_PROJECT);
        ProjectMenuBar.loadProjectMenu(menu);
        this.add(menu);
    }

    private void createFileMenu() {
        JMenu menu = ComponentFactory.createMenu(ResourceKey.MENUBAR_FILE);
        this.loadFileMenu(menu);
        this.add(menu);
    }

    private void loadFileMenu(JMenu menu) {
        ProjectMenuBar.createItem(menu, new CreateProject(false));
        ProjectMenuBar.createItem(menu, new OpenProject(false));
        this.loadOpenRecent(menu);
        ProjectMenuBar.createItem(menu, new CloseProject());
        menu.addSeparator();
        ProjectMenuBar.createItem(menu, new SaveProject(false));
        ProjectMenuBar.createItem(menu, new SaveProjectAs());
        if (SystemUtilities.showAlphaFeatures()) {
            ProjectMenuBar.createItem(menu, new SaveProjectToFormat());
        } else {
            menu.addSeparator();
            ComponentFactory.addSubmenu(menu, ProjectMenuBar.createExportSubmenu());
            ProjectMenuBar.createItem(menu, new ChangeProjectStorageFormat());
        }
        menu.addSeparator();
        ProjectMenuBar.createItem(menu, new SetPreferences());
        menu.addSeparator();
        ProjectMenuBar.createItem(menu, new ExitApplication());
    }

    private static void loadProjectMenu(JMenu menu) {
        ProjectMenuBar.createItem(menu, new ArchiveProject(false));
        ProjectMenuBar.createItem(menu, new RevertProject(false));
        menu.addSeparator();
        ProjectMenuBar.createItem(menu, new ManageIncludedProjectsAction());
        ProjectMenuBar.createItem(menu, new MergeIncludedProjects());
        menu.addSeparator();
        ProjectMenuBar.createItem(menu, new ConfigureProject());
        ProjectMenuBar.createItem(menu, new ShowMetrics());
        menu.addSeparator();
        ComponentFactory.addMenuItemNoIcon(menu, new ShowEncodingAndLocales());
    }

    private static JMenu createExportSubmenu() {
        JMenu menu = ComponentFactory.createMenu(ResourceKey.PROJECT_EXPORT_TO_FORMAT);
        Project prj = ProjectManager.getProjectManager().getCurrentProject();
        menu.setEnabled(prj != null);
        Collection<String> classNames = PluginUtilities.getAvailableExportPluginClassNames();
        for (ExportPlugin plugin : ProjectMenuBar.getSortedPlugins(classNames)) {
            ExportPluginAction exportAction = new ExportPluginAction(plugin);
            exportAction.setEnabled(WidgetUtilities.isSuitableExport(prj, plugin));
            ProjectMenuBar.createItem(menu, exportAction);
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    private static List getSortedPlugins(Collection classNames) {
        List plugins = ProjectMenuBar.getPlugins(classNames);
        Collections.sort(plugins, new PluginComparator());
        return plugins;
    }

    private static List getPlugins(Collection classNames) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (String name : classNames) {
            Plugin plugin = (Plugin)SystemUtilities.newInstance(name);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    private static boolean exists(URI uri) {
        return true;
    }

    private void loadOpenRecent(JMenu menu) {
        JMenu subMenu = ComponentFactory.createMenu(ResourceKey.PROJECT_OPEN_RECENT);
        this.uris.clear();
        List projectURIList = ApplicationProperties.getMRUProjectList();
        subMenu.setEnabled(!projectURIList.isEmpty());
        for (int i = 0; i < projectURIList.size(); ++i) {
            URI uri = (URI)projectURIList.get(i);
            boolean exists = ProjectMenuBar.exists(uri);
            if (!exists) continue;
            String text = uri.toString();
            if (text.length() > 50) {
                ArrayList list = ProjectMenuBar.buildList(text);
                list = this.reduce(list);
                text = ProjectMenuBar.rebuildPath(list);
            }
            this.uris.put(text, uri);
            JMenuItem menuItem = ComponentFactory.createMenuItem(text);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JMenuItem source = (JMenuItem)e.getSource();
                    String sourcetext = source.getText();
                    boolean closed = ProjectManager.getProjectManager().closeProjectRequest();
                    if (closed) {
                        URI projecturi = (URI)ProjectMenuBar.this.uris.get(sourcetext);
                        ProjectManager.getProjectManager().loadProject(projecturi);
                        ApplicationProperties.addProjectToMRUList(projecturi);
                    }
                }
            });
            subMenu.add(menuItem);
        }
        ComponentFactory.addSubmenu(menu, subMenu);
    }

    private static ArrayList buildList(String path) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer st = new StringTokenizer(path, "/");
        int i = 0;
        while (st.hasMoreElements()) {
            list.add(i, st.nextElement());
            ++i;
        }
        return list;
    }

    private ArrayList reduce(ArrayList list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return list;
        }
        if (ProjectMenuBar.getLength(list) <= 50) {
            return list;
        }
        if (list.size() == 1) {
            String fname = (String)list.get(0);
            fname = fname.substring(0, 47) + "...";
            list.set(0, fname);
        } else if (list.size() == 2) {
            if (list.get(0).equals("...")) {
                list.remove(0);
            } else {
                list.set(0, "...");
            }
        } else if (!list.contains("...")) {
            int mid = list.size() / 2;
            list.set(mid, "...");
        } else {
            int after;
            int idxDot = list.indexOf("...");
            int before = idxDot;
            if (before > (after = list.size() - 2 - idxDot)) {
                list.remove(idxDot - 1);
            } else {
                list.remove(idxDot + 1);
            }
        }
        if (ProjectMenuBar.getLength(list) <= 50) {
            return list;
        }
        return this.reduce(list);
    }

    private static int getLength(ArrayList list) {
        String path = "";
        String sep = "/";
        for (int i = 0; i < list.size(); ++i) {
            path = path + list.get(i) + sep;
        }
        return path.length() - 1;
    }

    private static String rebuildPath(ArrayList list) {
        String path = "";
        String sep = "/";
        for (int i = 0; i < list.size(); ++i) {
            path = path + list.get(i) + sep;
        }
        path = path.substring(0, path.length() - 1);
        return path;
    }

    private void createWindowMenu() {
        final JMenu menu = ComponentFactory.createMenu(ResourceKey.MENUBAR_WINDOW);
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent event) {
                ProjectMenuBar.this.loadWindowMenu(menu);
            }

            public void menuCanceled(MenuEvent event) {
            }

            public void menuDeselected(MenuEvent event) {
            }
        });
        this.add(menu);
    }

    private void loadWindowMenu(JMenu windowMenu) {
        Collection<JFrame> openWindows;
        windowMenu.removeAll();
        ProjectMenuBar.createItem(windowMenu, new IncreaseFontSize());
        ProjectMenuBar.createItem(windowMenu, new DecreaseFontSize());
        windowMenu.addSeparator();
        ProjectMenuBar.createItem(windowMenu, new CascadeWindows(false));
        ProjectMenuBar.createItem(windowMenu, new CloseAllWindows(false));
        windowMenu.addSeparator();
        ProjectMenuBar.createItem(windowMenu, new SynchronizeTrees());
        boolean autosync = ApplicationProperties.isAutosynchronizingClsTrees();
        ProjectMenuBar.createCheckBoxItem(windowMenu, new AutosynchronizeTrees(), autosync);
        windowMenu.addSeparator();
        ProjectMenuBar.createItem(windowMenu, new DetachCurrentView());
        ProjectMenuBar.createItem(windowMenu, new CloseCurrentView());
        windowMenu.addSeparator();
        ComponentFactory.addSubmenu(windowMenu, this.createLAFMenu());
        Project project = ProjectManager.getProjectManager().getCurrentProject();
        if (project != null && !(openWindows = project.getOpenWindows()).isEmpty()) {
            windowMenu.addSeparator();
            for (JFrame jframe : openWindows) {
                ProjectMenuBar.createItem(windowMenu, new JFrameToFront(jframe));
            }
        }
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    public void paint(Graphics g) {
        ComponentUtilities.enableTextAntialiasing(g);
        super.paint(g);
    }
}

