/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.event.ServerProjectAdapter;
import edu.stanford.smi.protege.event.ServerProjectListener;
import edu.stanford.smi.protege.event.ServerProjectNotificationEvent;
import edu.stanford.smi.protege.event.ServerProjectSessionClosedEvent;
import edu.stanford.smi.protege.event.ServerProjectStatusChangeEvent;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.ui.MyCardPanel;
import edu.stanford.smi.protege.ui.MyJTabbedPane;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.TabbedPaneInterface;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.ProjectViewDispatcher;
import edu.stanford.smi.protege.util.ProjectViewEvent;
import edu.stanford.smi.protege.util.ProjectViewListener;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectView
extends JComponent {
    private static final long serialVersionUID = -9143509906295036183L;
    private static Logger log = Log.getLogger(ProjectView.class);
    private ListenerCollection projectViewListeners = new ListenerList(new ProjectViewDispatcher());
    private Project _project;
    private TabbedPaneInterface _viewHolder;
    private Collection _currentClsPath;
    private Collection<Instance> _currentInstances;
    private Collection<JComponent> _detachedTabs = new HashSet<JComponent>();
    private ServerProjectListener _shutdownListener;
    private ProjectListener _projectListener;

    public ProjectView(Project project) {
        this._project = project;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createTabbedPane());
        if (!project.isMultiUserClient()) {
            project.getKnowledgeBase().setUndoEnabled(project.isUndoOptionEnabled());
        }
        if (project.isMultiUserClient()) {
            this._projectListener = this.createProjectListener();
            project.addProjectListener(this._projectListener);
            this._shutdownListener = this.createRemoteProjectShutdownListener();
            project.getKnowledgeBase().addServerProjectListener(this._shutdownListener);
        }
    }

    protected ServerProjectListener createRemoteProjectShutdownListener() {
        return new ServerProjectAdapter(){

            public void projectNotificationReceived(ServerProjectNotificationEvent event) {
                String project = event.getProjectName();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Server project notification received: " + event.getMessage());
                }
                ComponentFactory.showMessageInFrame(event.getMessage(), "Message from server");
            }

            public void projectStatusChanged(ServerProjectStatusChangeEvent event) {
                ServerProject.ProjectStatus newStatus = event.getNewStatus();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Project status changed: " + newStatus);
                }
                if (newStatus.equals(ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE)) {
                    ComponentFactory.showMessageInFrame("Shutting down NOW!", "Message from server");
                    ProjectManager.getProjectManager().closeCurrentProject();
                }
            }

            public void beforeProjectSessionClosed(ServerProjectSessionClosedEvent event) {
                if (RemoteClientFrameStore.getCurrentSession(ProjectView.this.getProject().getKnowledgeBase()).equals(event.getSessionToKill())) {
                    ProjectManager.getProjectManager().closeCurrentProject();
                    ModalDialog.showMessageDialog((Component)ProjectManager.getProjectManager().getMainPanel(), "An administrator has closed your\nremote working session on project " + event.getProjectName(), "Session killed");
                }
            }
        };
    }

    protected ProjectListener createProjectListener() {
        return new ProjectAdapter(){

            public void serverSessionLost(ProjectEvent event) {
                try {
                    ProjectManager.getProjectManager().closeCurrentProject();
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, "Could not close current project cleanly", t);
                }
                ModalDialog.showMessageDialog((Component)ProjectManager.getProjectManager().getMainPanel(), "The connection to the server has been broken and Protege is closing\nthe session. Possible causes are poor network connectivity, a server\ncrash or an administrator who has closed your session.", "Session killed");
            }
        };
    }

    public TabWidget addTab(WidgetDescriptor widgetDescriptor, int index) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding tab " + widgetDescriptor);
        }
        TabWidget widget = WidgetUtilities.createTabWidget(widgetDescriptor, this._project);
        this.addTab(widget, index);
        this.projectViewListeners.postEvent(this, ProjectViewEvent.Type.addTab.ordinal(), widget);
        return widget;
    }

    public TabWidget addTab(WidgetDescriptor widgetDescriptor) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding tab " + widgetDescriptor);
        }
        TabWidget widget = WidgetUtilities.createTabWidget(widgetDescriptor, this._project);
        this.addTab(widget);
        this.projectViewListeners.postEvent(this, ProjectViewEvent.Type.addTab.ordinal(), widget);
        return widget;
    }

    private void addTab(TabWidget widget) {
        this.addTab(widget, -1);
    }

    private void addTab(String title, Icon icon, JComponent component, String helpText, int index) {
        if (index < 0) {
            this._viewHolder.addTab(title, icon, component, helpText);
        } else {
            this._viewHolder.insertTab(title, icon, component, helpText, index);
        }
    }

    private boolean isSuitable(TabWidget widget) {
        String className = widget.getClass().getName();
        return WidgetUtilities.isSuitableTab(className, this._project, new ArrayList());
    }

    private void addTab(final TabWidget widget, int index) {
        if (this.isSuitable(widget)) {
            JComponent component = (JComponent)((Object)widget);
            Icon icon = widget.getIcon();
            String title = widget.getLabel();
            String help = widget.getShortDescription();
            this.addTab(title, icon, component, help, index);
            widget.addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent event) {
                    ArrayList list = new ArrayList(widget.getSelection());
                    if (!list.isEmpty() && list.get(0) instanceof Collection) {
                        list.remove(0);
                    }
                    ProjectView.this.setCurrentClsPath(list);
                    ProjectView.this.setCurrentInstances(widget.getSelectedInstances());
                }
            });
        }
    }

    public boolean canClose() {
        boolean canClose = true;
        Iterator i = this.getTabs().iterator();
        while (canClose && i.hasNext()) {
            TabWidget tab = (TabWidget)i.next();
            canClose = tab.canClose();
        }
        return canClose;
    }

    public boolean attemptSave() {
        boolean canSave = true;
        Iterator i = this.getTabs().iterator();
        while (canSave && i.hasNext()) {
            TabWidget tab = (TabWidget)i.next();
            canSave = tab.canSave();
        }
        if (canSave) {
            this.save();
        }
        this.projectViewListeners.postEvent(this, ProjectViewEvent.Type.save.ordinal());
        return canSave;
    }

    public void close() {
        for (TabWidget tab : this.getTabs()) {
            tab.close();
        }
        if (this._projectListener != null) {
            this._project.removeProjectListener(this._projectListener);
        }
        try {
            if (this._shutdownListener != null) {
                this._project.getKnowledgeBase().removeServerProjectListener(this._shutdownListener);
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Could not remove server project listener", t);
        }
        this._project = null;
        this.projectViewListeners.postEvent(this, ProjectViewEvent.Type.close.ordinal());
    }

    private JComponent createTabbedPane() {
        this._viewHolder = SystemUtilities.showAlphaFeatures() ? new MyCardPanel() : new MyJTabbedPane();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Added view holder " + this._viewHolder + " for project " + this);
        }
        this._viewHolder.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("project view tabbed pane received change event " + e);
                }
                if (ProjectView.this.isAutosynchronizingClsTrees()) {
                    ProjectView.this.synchronizeClsTree();
                    ProjectView.this.synchronizeInstances();
                }
            }
        });
        for (WidgetDescriptor d : this._project.getTabWidgetDescriptors()) {
            if (!d.isVisible()) continue;
            try {
                this.addTab(d);
            }
            catch (Throwable t) {
                Log.getLogger().log(Level.WARNING, "Errors at adding tab " + d.getWidgetClassName(), t);
            }
        }
        if (this._viewHolder.getComponentCount() > 0) {
            this._viewHolder.setSelectedIndex(0);
        }
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        return (JComponent)((Object)this._viewHolder);
    }

    public void addChangeListener(ChangeListener listener) {
        this._viewHolder.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._viewHolder.removeChangeListener(listener);
    }

    public void addProjectViewListener(ProjectViewListener pvl) {
        this.projectViewListeners.add(this, pvl);
    }

    public void removeProjectViewListener(ProjectViewListener pvl) {
        this.projectViewListeners.remove(this, pvl);
    }

    public Project getProject() {
        return this._project;
    }

    @Deprecated
    public TabWidget getTab(String className) {
        return this.getTabByClassName(className);
    }

    public TabWidget getTabByClassName(String className) {
        TabWidget result = null;
        Component[] components = this._viewHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (!c.getClass().getName().equals(className)) continue;
            result = (TabWidget)((Object)c);
            break;
        }
        return result;
    }

    public Collection getTabs() {
        return Arrays.asList(this._viewHolder.getComponents());
    }

    public void setSelectedTab(TabWidget tab) {
        this._viewHolder.setSelectedComponent((Component)((Object)tab));
    }

    public TabWidget getSelectedTab() {
        return (TabWidget)((Object)this._viewHolder.getSelectedComponent());
    }

    @Deprecated
    public JTabbedPane getTabbedPane() {
        return this._viewHolder instanceof JTabbedPane ? (JTabbedPane)((Object)this._viewHolder) : null;
    }

    public void reload(boolean regenerate) {
        if (regenerate) {
            this.reloadAll();
        } else {
            this.reloadPartial();
        }
    }

    private void reloadPartial() {
        this.closeDetachedDisabledTabs();
        this.synchronizeTabbedPane();
    }

    public void reload(TabWidget tabWidget) {
        if (tabWidget == null) {
            return;
        }
        WidgetDescriptor widgetDescriptor = tabWidget.getDescriptor();
        try {
            int index = this.getTabIndex(widgetDescriptor);
            if (index < 0) {
                return;
            }
            this._viewHolder.remove((Component)((Object)tabWidget));
            ComponentUtilities.dispose((Component)((Object)tabWidget));
            this.addTab(widgetDescriptor, index);
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Errors at reloading tab " + widgetDescriptor, e);
        }
    }

    public void reloadAllTabsExcept(TabWidget exceptionTab) {
        TabWidget newTabWidget;
        TabWidget selTabWidget = this.getSelectedTab();
        String selectedTabClassName = null;
        if (selTabWidget != null) {
            selectedTabClassName = selTabWidget.getDescriptor().getWidgetClassName();
        }
        WidgetDescriptor exceptTabDescr = exceptionTab.getDescriptor();
        for (WidgetDescriptor d : this._project.getTabWidgetDescriptors()) {
            String className;
            TabWidget tabWidget;
            if (!d.isVisible() || d.equals(exceptTabDescr) || (tabWidget = this.getTabByClassName(className = d.getWidgetClassName())) == null || !d.isVisible()) continue;
            this.reload(tabWidget);
        }
        if (selectedTabClassName != null && (newTabWidget = this.getTabByClassName(selectedTabClassName)) != null) {
            this.setSelectedTab(newTabWidget);
        }
        this.revalidate();
        this.repaint();
    }

    private void synchronizeTabbedPane() {
        this.removeDisabledTabs();
        this.addEnabledTabs();
        this.reorderTabs();
    }

    private void removeDisabledTabs() {
        for (TabWidget tab : this.getTabs()) {
            if (ProjectView.isEnabled(tab)) continue;
            this._viewHolder.remove((Component)((Object)tab));
            tab.dispose();
        }
    }

    private void addEnabledTabs() {
        for (WidgetDescriptor d : this._project.getTabWidgetDescriptors()) {
            String className;
            if (!d.isVisible() || this.getTabByClassName(className = d.getWidgetClassName()) != null) continue;
            this.addTab(d);
        }
    }

    private void reorderTabs() {
        int index = 0;
        for (WidgetDescriptor d : this._project.getTabWidgetDescriptors()) {
            if (!d.isVisible()) continue;
            int currentIndex = this.getTabIndex(d);
            if (currentIndex != index && currentIndex != -1) {
                TabWidget tab = (TabWidget)((Object)this._viewHolder.getComponent(currentIndex));
                this.addTab(tab, index);
            }
            ++index;
        }
    }

    private int getTabIndex(WidgetDescriptor d) {
        return this._viewHolder.indexOfComponent((Component)((Object)this.getTabByClassName(d.getWidgetClassName())));
    }

    public void reloadAll() {
        TabWidget newTabWidget;
        TabWidget tabWidget = this.getSelectedTab();
        String selectedTabClassName = null;
        if (tabWidget != null) {
            selectedTabClassName = tabWidget.getDescriptor().getWidgetClassName();
        }
        this.closeDetachedTabs();
        if (this._viewHolder != null) {
            ComponentUtilities.dispose((Component)((Object)this._viewHolder));
        }
        this.removeAll();
        this._project.clearCachedWidgets();
        this.add(this.createTabbedPane());
        if (selectedTabClassName != null && (newTabWidget = this.getTabByClassName(selectedTabClassName)) != null) {
            this.setSelectedTab(newTabWidget);
        }
        this.revalidate();
        this.repaint();
    }

    private void closeDetachedTabs() {
        Iterator<JComponent> i = this._detachedTabs.iterator();
        while (i.hasNext()) {
            TabWidget tab = (TabWidget)((Object)i.next());
            i.remove();
            ProjectView.closeDetachedTab(tab);
        }
    }

    private static void closeDetachedTab(TabWidget tab) {
        Component c = (Component)((Object)tab);
        JFrame frame = (JFrame)SwingUtilities.getRoot(c);
        frame.dispose();
    }

    private void closeDetachedDisabledTabs() {
        Iterator<JComponent> i = this._detachedTabs.iterator();
        while (i.hasNext()) {
            TabWidget tab = (TabWidget)((Object)i.next());
            if (ProjectView.isEnabled(tab)) continue;
            i.remove();
            ProjectView.closeDetachedTab(tab);
        }
    }

    private static boolean isEnabled(TabWidget tab) {
        return tab.getDescriptor().isVisible();
    }

    private void save() {
        for (TabWidget tab : this.getTabs()) {
            tab.save();
        }
    }

    @Override
    public String toString() {
        return "ProjectView";
    }

    public void closeCurrentView() {
        int index = this._viewHolder.getSelectedIndex();
        Component c = this._viewHolder.getSelectedComponent();
        this._viewHolder.removeTabAt(index);
        TabWidget widget = (TabWidget)((Object)c);
        widget.getDescriptor().setVisible(false);
        ComponentUtilities.dispose(c);
    }

    public void detachCurrentView() {
        JComponent c = (JComponent)this._viewHolder.getSelectedComponent();
        int index = this._viewHolder.getSelectedIndex();
        this._viewHolder.removeTabAt(index);
        final JFrame frame = ComponentFactory.createFrame();
        c.setPreferredSize(c.getSize());
        frame.getContentPane().add(c);
        frame.pack();
        String title = ((TabWidget)((Object)c)).getLabel() + " Tab - " + Text.getProgramName();
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Component tab = frame.getContentPane().getComponent(0);
                ProjectView.this.reattachTab(tab);
                frame.setVisible(false);
                frame.dispose();
            }
        });
        frame.setVisible(true);
        this._detachedTabs.add(c);
    }

    private void reattachTab(Component c) {
        if (this._project == null) {
            return;
        }
        int index = this.getInsertionPoint(c);
        this.addTab((TabWidget)((Object)c), index);
        this._viewHolder.setSelectedIndex(index);
        this._detachedTabs.remove(c);
    }

    private int getInsertionPoint(Component c) {
        WidgetDescriptor desc;
        String className;
        String classNameToMatch = c.getClass().getName();
        int insertionPoint = 0;
        Iterator<WidgetDescriptor> i = this._project.getTabWidgetDescriptors().iterator();
        while (i.hasNext() && insertionPoint < this._viewHolder.getComponentCount() && !(className = (desc = i.next()).getWidgetClassName()).equals(classNameToMatch)) {
            if (!className.equals(this._viewHolder.getComponent(insertionPoint).getClass().getName())) continue;
            ++insertionPoint;
        }
        return insertionPoint;
    }

    public void setAutosynchronizeClsTrees(boolean b) {
        ApplicationProperties.setAutosynchronizingClsTrees(b);
        this.synchronizeClsTree();
    }

    public boolean isAutosynchronizingClsTrees() {
        return ApplicationProperties.isAutosynchronizingClsTrees();
    }

    private void setCurrentClsPath(Collection c) {
        this._currentClsPath = new ArrayList(c);
    }

    private void setCurrentInstances(Collection<? extends Instance> instances) {
        this._currentInstances = instances == null ? null : new ArrayList<Instance>(instances);
    }

    public void synchronizeClsTree() {
        TabWidget currentWidget;
        if (this._currentClsPath != null && (currentWidget = (TabWidget)((Object)this._viewHolder.getSelectedComponent())) != null) {
            currentWidget.synchronizeClsTree(this._currentClsPath);
        }
    }

    public void synchronizeInstances() {
        TabWidget currentWidget;
        if (this._currentInstances != null && (currentWidget = (TabWidget)((Object)this._viewHolder.getSelectedComponent())) != null) {
            currentWidget.synchronizeToInstances(this._currentInstances);
        }
    }
}

