/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class ReferenceNode
extends LazyTreeNode {
    private Slot _slot;
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent event) {
            ReferenceNode.this.reload();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void replaceFrame(FrameEvent event) {
            ReferenceNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent event) {
            ReferenceNode.this.reload();
        }

        public void visibilityChanged(FrameEvent event) {
            ReferenceNode.this.notifyNodeChanged();
        }
    };

    public ReferenceNode(LazyTreeNode parent, Frame frame, Slot slot) {
        super(parent, frame);
        this._slot = slot;
        frame.addFrameListener(this._frameListener);
        if (frame instanceof Cls) {
            ((Cls)frame).addClsListener(this._clsListener);
        }
    }

    private static void addOwnSlotReferences(Frame frame, Slot slot, Collection references) {
        ValueType type;
        if (frame.hasOwnSlot(slot) && ((type = frame.getOwnSlotValueType(slot)).equals(ValueType.INSTANCE) || type.equals(ValueType.CLS))) {
            references.addAll(frame.getOwnSlotValues(slot));
        }
    }

    private static void addReferences(Frame frame, Slot slot, Collection references) {
        if (frame instanceof Cls) {
            Cls cls = (Cls)frame;
            ReferenceNode.addTemplateSlotReferences(cls, slot, references);
        }
        ReferenceNode.addOwnSlotReferences(frame, slot, references);
    }

    private static void addTemplateSlotReferences(Cls cls, Slot slot, Collection references) {
        if (cls.hasTemplateSlot(slot)) {
            ValueType type = cls.getTemplateSlotValueType(slot);
            if (type.equals(ValueType.INSTANCE)) {
                references.addAll(cls.getTemplateSlotAllowedClses(slot));
            } else if (type.equals(ValueType.CLS)) {
                references.addAll(cls.getTemplateSlotAllowedParents(slot));
            }
        }
    }

    public LazyTreeNode createNode(Object o) {
        return new ReferenceNode((LazyTreeNode)this, (Frame)o, this._slot);
    }

    public int getChildObjectCount() {
        return this.getChildObjects().size();
    }

    public Collection getChildObjects() {
        ArrayList references = new ArrayList();
        Frame frame = (Frame)this.getUserObject();
        if (this._slot == null) {
            if (frame instanceof Cls) {
                Cls cls = (Cls)frame;
                for (Slot slot : cls.getTemplateSlots()) {
                    ReferenceNode.addTemplateSlotReferences(cls, slot, references);
                }
            }
            for (Slot slot : frame.getOwnSlots()) {
                if (slot.isSystem()) continue;
                ReferenceNode.addOwnSlotReferences(frame, slot, references);
            }
        } else {
            ReferenceNode.addReferences(frame, this._slot, references);
        }
        return references;
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }
}

