/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ReferenceComparator;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ReferencersPanel
extends SelectableContainer {
    private static final long serialVersionUID = -3053088272109571777L;
    private SelectableTable _table;

    public ReferencersPanel(Instance instance) {
        this.createTable(instance);
        this.setSelectable(this._table);
        this.setPreferredSize(new Dimension(700, 300));
    }

    public ReferencersPanel(Project project, Instance instance) {
        this(instance);
    }

    private void addColumn(int width, TableCellRenderer renderer) {
        this._table.addColumn(new TableColumn(this._table.getColumnCount(), width, renderer, null));
    }

    private void createColumns() {
        this.addColumn(250, FrameRenderer.createInstance());
        this.addColumn(250, FrameRenderer.createInstance());
        DefaultRenderer facetsRenderer = new DefaultRenderer(){
            private static final long serialVersionUID = -5008610693872505393L;

            public void load(Object o) {
                Reference ref = (Reference)o;
                Facet facet = ref.getFacet();
                if (facet != null && facet.getName().equals(":VALUE-TYPE")) {
                    this.setMainIcon(Icons.getFacetIcon());
                    Cls cls = (Cls)ref.getFrame();
                    Slot slot = ref.getSlot();
                    ValueType type = cls.getTemplateSlotValueType(slot);
                    if (1.equals(type, ValueType.INSTANCE)) {
                        this.setMainText("allowed-classes");
                    } else if (1.equals(type, ValueType.CLS)) {
                        this.setMainText("allowed-parents");
                    }
                }
            }
        };
        this.addColumn(125, facetsRenderer);
    }

    private void createTable(Instance instance) {
        Action viewAction = this.createViewAction();
        this._table = ComponentFactory.createSelectableTable(viewAction);
        this.setLayout(new BorderLayout());
        JScrollPane t = ComponentFactory.createScrollPane(this._table);
        String text = "References to " + instance.getName();
        LabeledComponent c = new LabeledComponent(text, (Component)t);
        c.addHeaderButton(viewAction);
        c.addHeaderButton(new ReferencersAction(this));
        this.add(c);
        this._table.setModel(ReferencersPanel.createTableModel(instance));
        this.createColumns();
    }

    private static TableModel createTableModel(Instance instance) {
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = -1289987049965852246L;

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        model.addColumn("Frame");
        model.addColumn("Slot");
        model.addColumn("Facet");
        KnowledgeBase kb = instance.getKnowledgeBase();
        ArrayList<Reference> references = new ArrayList<Reference>(kb.getReferences(instance, 1000));
        Collections.sort(references, new ReferenceComparator());
        for (Reference ref : references) {
            model.addRow(new Object[]{ref.getFrame(), ref.getSlot(), ref});
        }
        return model;
    }

    private Action createViewAction() {
        return new AbstractAction("View Reference", Icons.getViewIcon()){
            private static final long serialVersionUID = -9110036539380008551L;

            public void actionPerformed(ActionEvent event) {
                for (Reference ref : ReferencersPanel.this.getSelectedReferences()) {
                    Project project = ref.getFrame().getProject();
                    if (ref.isTemplate()) {
                        project.show((Cls)ref.getFrame(), ref.getSlot());
                        continue;
                    }
                    project.show((Instance)ref.getFrame());
                }
            }
        };
    }

    public int getReferencerCount() {
        return this._table.getRowCount();
    }

    private Collection getSelectedReferences() {
        ArrayList<Object> references = new ArrayList<Object>();
        TableModel model = this._table.getModel();
        int[] rows = this._table.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            references.add(model.getValueAt(rows[i], 2));
        }
        return references;
    }
}

