/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ReferenceRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import java.awt.Component;
import javax.swing.Action;

public class RelationshipPane
extends SelectableContainer {
    private static final long serialVersionUID = -6177511814335102076L;
    private Frame _frame;
    private Slot _slot;

    public RelationshipPane(Action doubleClickAction) {
        SelectableTree tree = ComponentFactory.createSelectableTree(doubleClickAction);
        tree.setCellRenderer(FrameRenderer.createInstance());
        this.setSelectable(tree);
        this.add((Component)ComponentFactory.createScrollPane(tree), "Center");
    }

    public Frame getFrame() {
        return this._frame;
    }

    public Slot getSlot() {
        return this._slot;
    }

    protected SelectableTree getTree() {
        return (SelectableTree)this.getSelectable();
    }

    public void load(Frame frame, Slot slot) {
        if (frame != this._frame || slot != this._slot) {
            this._frame = frame;
            this._slot = slot;
            this.rebuild();
        }
    }

    protected void rebuild() {
        this.getTree().setRoot(new ReferenceRoot(this._frame.getKnowledgeBase(), this._frame, this._slot));
        this.getTree().setSelectionRow(0);
    }
}

