/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.ArchiveRecord;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialogCloseDoubleClickAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

class RevertProjectPanel
extends JPanel {
    private static final long serialVersionUID = 8202074349453422106L;
    private static boolean _lastArchiveCurrentValue;
    private Project _currentProject;
    private JCheckBox _archiveCurrentCheckBox;
    private JTable _table;

    RevertProjectPanel(Project p) {
        super(new BorderLayout());
        this._currentProject = p;
        this.add((Component)this.createVersionsTable(), "Center");
        this.add((Component)this.createOptionsPanel(), "South");
    }

    private JComponent createVersionsTable() {
        this._table = ComponentFactory.createTable(null);
        this._table.setAutoCreateColumnsFromModel(true);
        this._table.setModel(this.createTableModel());
        this._table.addMouseListener(new ModalDialogCloseDoubleClickAdapter());
        int selectedRow = this._table.getRowCount() - 1;
        if (selectedRow >= 0) {
            this._table.setRowSelectionInterval(selectedRow, selectedRow);
        }
        return new LabeledComponent("Archived Versions", ComponentFactory.createScrollPane(this._table));
    }

    private JComponent createOptionsPanel() {
        this._archiveCurrentCheckBox = new JCheckBox("Archive current version before revert");
        this._archiveCurrentCheckBox.setSelected(_lastArchiveCurrentValue);
        return this._archiveCurrentCheckBox;
    }

    public Date getSelectedTimestamp() {
        Date date = null;
        int row = this._table.getSelectedRow();
        if (row != -1) {
            date = (Date)this._table.getValueAt(row, 0);
        }
        return date;
    }

    public boolean getArchiveCurrentVersion() {
        _lastArchiveCurrentValue = this._archiveCurrentCheckBox.isSelected();
        return _lastArchiveCurrentValue;
    }

    private TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Date and Time");
        model.addColumn("Comment");
        for (ArchiveRecord record : ArchiveManager.getArchiveManager().getArchiveRecords(this._currentProject)) {
            Date timestamp = record.getTimestamp();
            String comment = record.getComment();
            model.addRow(new Object[]{timestamp, comment});
        }
        return model;
    }
}

