/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class SelectClsesPanel
extends JComponent
implements Validatable {
    private static final long serialVersionUID = 4752775085919596616L;
    private JTree _tree;
    private boolean _allowsMultiple;

    public SelectClsesPanel(KnowledgeBase kb) {
        this(kb, Collections.EMPTY_SET);
    }

    public SelectClsesPanel(KnowledgeBase kb, DefaultRenderer renderer) {
        this(kb, Collections.EMPTY_SET);
        this._tree.setCellRenderer(renderer);
    }

    public SelectClsesPanel(KnowledgeBase kb, Collection clses) {
        this(kb, clses, true);
    }

    public SelectClsesPanel(KnowledgeBase kb, Collection clses, boolean allowsMultiple) {
        this._allowsMultiple = allowsMultiple;
        if (clses.isEmpty()) {
            clses = kb.getRootClses();
        }
        this._tree = ComponentFactory.createSelectableTree(ModalDialog.getCloseAction(this), new ParentChildRoot(clses));
        this._tree.setCellRenderer(FrameRenderer.createInstance());
        int rows = this._tree.getRowCount();
        int diff = rows - clses.size();
        for (int i = rows - 1; i > diff; --i) {
            this._tree.expandRow(i);
        }
        this._tree.setSelectionRow(0);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this._tree), "Center");
        this.add((Component)new ClsTreeFinder(kb, this._tree), "South");
        this.setPreferredSize(new Dimension(300, 300));
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._tree);
    }

    public boolean validateContents() {
        boolean isValid;
        boolean bl = isValid = this._allowsMultiple || this.getSelection().size() <= 1;
        if (!isValid) {
            ModalDialog.showMessageDialog((Component)this, "Only 1 class can be selected", 14);
        }
        return isValid;
    }

    public void saveContents() {
    }
}

