/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class SelectInstanceFromCollectionPanel
extends JComponent {
    private static final long serialVersionUID = 1189735912135124770L;
    private JList _list;
    private Icon _clsIcon;

    public SelectInstanceFromCollectionPanel(Collection c, int initialSelection) {
        this.setLayout(new BorderLayout());
        this._list = ComponentFactory.createList(ModalDialog.getCloseAction(this));
        c = SelectInstanceFromCollectionPanel.removeHidden(c);
        this._list.setListData(c.toArray());
        this.configureRenderer();
        if (initialSelection >= 0) {
            this.setSelection(initialSelection);
        }
        JScrollPane pane = ComponentFactory.createScrollPane(this._list);
        this.add(pane);
        this.setPreferredSize(new Dimension(300, 150));
    }

    private boolean isMultiUserClient() {
        Object o;
        boolean isMultiUserClient = false;
        if (this._list.getModel().getSize() > 0 && (o = this._list.getModel().getElementAt(0)) instanceof Frame) {
            Frame frame = (Frame)o;
            Project p = frame.getProject();
            isMultiUserClient = p.isMultiUserClient();
        }
        return isMultiUserClient;
    }

    private void configureRenderer() {
        FrameRenderer renderer;
        if (this.isMultiUserClient()) {
            renderer = new FrameRenderer(){
                private static final long serialVersionUID = -4327868983862509964L;

                protected Icon getIcon(Cls cls) {
                    Icon icon;
                    if (SelectInstanceFromCollectionPanel.this._clsIcon == null) {
                        icon = cls.getIcon();
                        if (!cls.isMetaCls()) {
                            SelectInstanceFromCollectionPanel.this._clsIcon = icon;
                        }
                    } else {
                        icon = SelectInstanceFromCollectionPanel.this._clsIcon;
                    }
                    return icon;
                }
            };
        } else {
            renderer = FrameRenderer.createInstance();
            renderer.setDisplayTrailingIcons(false);
        }
        this._list.setCellRenderer(renderer);
    }

    public Instance getSelection() {
        return (Instance)this._list.getSelectedValue();
    }

    private static Collection removeHidden(Collection instances) {
        ArrayList<Instance> result;
        Project p = ((Instance)CollectionUtilities.getFirstItem(instances)).getProject();
        if (p.getDisplayHiddenClasses()) {
            result = instances;
        } else {
            result = new ArrayList<Instance>();
            for (Instance instance : instances) {
                if (!instance.isVisible()) continue;
                result.add(instance);
            }
        }
        return result;
    }

    private void setSelection(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectInstanceFromCollectionPanel.this._list.setSelectedIndex(index);
                SelectInstanceFromCollectionPanel.this._list.ensureIndexIsVisible(index);
            }
        });
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        if (cellRenderer != null) {
            this._list.setCellRenderer(cellRenderer);
        }
    }
}

