/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.Finder;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialogCloseDoubleClickAdapter;
import edu.stanford.smi.protege.util.SimpleListModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectInstancesPanel
extends JComponent {
    private static final long serialVersionUID = 2899081089163151972L;
    protected JTree _clsTree;
    protected JList _instanceList;
    protected JComboBox _directAllInstanceComboBox;
    private static String DIRECT_INSTANCES_TEXT = "Direct Instances";
    private static String ALL_INSTANCES_TEXT = "All Instances";
    private static Object _oldDirectAllInstancesState = DIRECT_INSTANCES_TEXT;

    protected SelectInstancesPanel(KnowledgeBase kb, Collection clses) {
        this.setPreferredSize(new Dimension(500, 300));
        if (clses.isEmpty()) {
            clses = kb.getRootClses();
        }
        this.createWidgets(kb, clses);
        this.fixRenderer();
    }

    protected LabeledComponent createClsesLabeledComponent(KnowledgeBase kb, Collection clses) {
        LabeledComponent clsesComponent = new LabeledComponent("Allowed Classes", new JScrollPane(this._clsTree));
        clsesComponent.setFooterComponent(new ClsTreeFinder(kb, this._clsTree));
        return clsesComponent;
    }

    protected JComponent createClsTree(Collection clses) {
        ParentChildRoot root = new ParentChildRoot(clses);
        this._clsTree = ComponentFactory.createSelectableTree(null, root);
        this._clsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                SelectInstancesPanel.this.loadInstances();
            }
        });
        FrameRenderer renderer = FrameRenderer.createInstance();
        renderer.setDisplayDirectInstanceCount(true);
        this._clsTree.setCellRenderer(renderer);
        int rows = this._clsTree.getRowCount();
        int diff = rows - clses.size();
        for (int i = rows - 1; i > diff; --i) {
            this._clsTree.expandRow(i);
        }
        this._clsTree.setSelectionRow(0);
        return this._clsTree;
    }

    private void fixRenderer() {
        boolean displayType = this._directAllInstanceComboBox.getSelectedItem().equals(ALL_INSTANCES_TEXT);
        FrameRenderer frameRenderer = (FrameRenderer)this._instanceList.getCellRenderer();
        frameRenderer.setDisplayType(displayType);
    }

    protected LabeledComponent createInstanceLabeledComponent() {
        LabeledComponent c = new LabeledComponent(null, new JScrollPane(this._instanceList));
        c.setHeaderComponent(this.createDirectAllInstanceComboBox(), "West");
        c.setFooterComponent(this.createListFinder());
        return c;
    }

    protected Finder createListFinder() {
        return new ListFinder(this._instanceList, "Find Instance");
    }

    protected JComboBox createDirectAllInstanceComboBox() {
        this._directAllInstanceComboBox = ComponentFactory.createComboBox();
        this._directAllInstanceComboBox.addItem(DIRECT_INSTANCES_TEXT);
        this._directAllInstanceComboBox.addItem(ALL_INSTANCES_TEXT);
        this.loadState();
        this._directAllInstanceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectInstancesPanel.this.loadInstances();
                SelectInstancesPanel.this.fixRenderer();
                SelectInstancesPanel.this.saveState();
            }
        });
        return this._directAllInstanceComboBox;
    }

    private void saveState() {
        _oldDirectAllInstancesState = this._directAllInstanceComboBox.getSelectedItem();
    }

    private void loadState() {
        this._directAllInstanceComboBox.setSelectedItem(_oldDirectAllInstancesState);
    }

    protected JComponent createInstanceList() {
        this._instanceList = ComponentFactory.createList(null);
        this._instanceList.setCellRenderer(FrameRenderer.createInstance());
        this._instanceList.addMouseListener(new ModalDialogCloseDoubleClickAdapter());
        return this._instanceList;
    }

    protected void createWidgets(KnowledgeBase kb, Collection clses) {
        this.createInstanceList();
        LabeledComponent instancesComponent = this.createInstanceLabeledComponent();
        this.createClsTree(clses);
        LabeledComponent clsesComponent = this.createClsesLabeledComponent(kb, clses);
        JSplitPane main = ComponentFactory.createLeftRightSplitPane(clsesComponent, instancesComponent);
        main.setDividerLocation(0);
        this.setLayout(new BorderLayout());
        this.add(main);
    }

    protected SimpleListModel getInstanceModel() {
        return (SimpleListModel)this._instanceList.getModel();
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._instanceList);
    }

    protected void loadInstances() {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (Cls cls : ComponentUtilities.getSelection(this._clsTree)) {
            instances.addAll(this.getInstances(cls));
        }
        Collections.sort(instances, this.getInstancesComparator());
        this.getInstanceModel().setValues(instances);
        if (!instances.isEmpty()) {
            this._instanceList.setSelectedIndex(0);
        }
    }

    protected Comparator<Instance> getInstancesComparator() {
        return new FrameComparator<Instance>();
    }

    protected Collection<Instance> getInstances(Cls cls) {
        boolean direct = this._directAllInstanceComboBox.getSelectedItem().equals(DIRECT_INSTANCES_TEXT);
        return direct ? cls.getDirectInstances() : cls.getInstances();
    }
}

