/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplaySlotRenderer;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.MultiSlotPanel;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SetDisplaySlotPanel
extends JComponent
implements Disposable {
    private static final long serialVersionUID = -5802235885558570599L;
    private static final String MULTISLOT = "Multiple Slots";
    private JComboBox _displaySlotComboBox;
    private Cls _cls;
    private BrowserSlotPattern _currentPattern;
    private ActionListener _actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            if (SetDisplaySlotPanel.this._cls != null) {
                Object o = SetDisplaySlotPanel.this._displaySlotComboBox.getSelectedItem();
                if (SetDisplaySlotPanel.MULTISLOT.equals(o)) {
                    SetDisplaySlotPanel.this.setMultiSlotPattern();
                } else {
                    BrowserSlotPattern pattern = (BrowserSlotPattern)SetDisplaySlotPanel.this._displaySlotComboBox.getSelectedItem();
                    SetDisplaySlotPanel.this._cls.setDirectBrowserSlotPattern(pattern);
                }
            }
        }
    };
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSuperclassAdded(ClsEvent event) {
            SetDisplaySlotPanel.this.reload();
        }

        public void directSuperclassRemoved(ClsEvent event) {
            SetDisplaySlotPanel.this.reload();
        }

        public void templateSlotAdded(ClsEvent event) {
            SetDisplaySlotPanel.this.reload();
        }

        public void templateSlotRemoved(ClsEvent event) {
            SetDisplaySlotPanel.this.reload();
        }
    };

    public SetDisplaySlotPanel() {
        this.createComponents();
        this.layoutComponents();
    }

    public void setCls(Cls cls) {
        if (this._cls != null) {
            this._cls.removeClsListener(this._clsListener);
        }
        this._cls = cls;
        if (this._cls != null) {
            this._cls.addClsListener(this._clsListener);
        }
        this._displaySlotComboBox.setRenderer(new DisplaySlotRenderer(cls));
        this.reload();
    }

    public void dispose() {
        if (this._cls != null) {
            this._cls.removeClsListener(this._clsListener);
        }
    }

    private void layoutComponents() {
        this.setLayout(new FlowLayout(0, 3, 0));
        String displaySlotLabel = LocalizedText.getText(ResourceKey.FORM_EDITOR_DISPLAY_SLOT_LABEL);
        this.add(ComponentFactory.createSmallFontLabel(displaySlotLabel));
        this.add(this._displaySlotComboBox);
        Dimension d = this._displaySlotComboBox.getPreferredSize();
        d.width = 250;
        this._displaySlotComboBox.setPreferredSize(d);
    }

    private void createComponents() {
        this.createDisplaySlotComboBox();
    }

    private void createDisplaySlotComboBox() {
        this._displaySlotComboBox = ComponentFactory.createComboBox();
        this._displaySlotComboBox.addActionListener(this._actionListener);
    }

    private void reload() {
        this._currentPattern = null;
        boolean shouldEnable = this._cls != null;
        BrowserSlotPattern selection = this._cls == null ? null : this._cls.getBrowserSlotPattern();
        ArrayList<Object> values = new ArrayList<Object>();
        if (shouldEnable) {
            Slot nameSlot;
            Collection slots = this._cls.getVisibleTemplateSlots();
            if (!slots.contains(nameSlot = this._cls.getKnowledgeBase().getNameSlot())) {
                slots.add(nameSlot);
            }
            Collections.sort((List)slots, new FrameComparator());
            for (Slot slot : slots) {
                BrowserSlotPattern pattern = new BrowserSlotPattern(slot);
                values.add(pattern);
            }
            if (selection != null && !values.contains(selection)) {
                values.add(selection);
            }
            if (slots.size() > 0) {
                values.add(MULTISLOT);
            }
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(values.toArray());
        this._displaySlotComboBox.removeActionListener(this._actionListener);
        this._displaySlotComboBox.setModel(model);
        this._displaySlotComboBox.setSelectedItem(selection);
        this._displaySlotComboBox.addActionListener(this._actionListener);
        this.setEnabled(shouldEnable);
    }

    public void setEnabled(boolean b) {
        this._displaySlotComboBox.setEnabled(b);
    }

    private void setMultiSlotPattern() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SetDisplaySlotPanel.this.acquireMultiSlotPattern();
            }
        });
    }

    private void acquireMultiSlotPattern() {
        BrowserSlotPattern pattern;
        MultiSlotPanel panel = new MultiSlotPanel(this._currentPattern, this._cls);
        int rval = ModalDialog.showDialog(this, panel, "Multislot Display Pattern", 11);
        if (rval == 1 && (pattern = panel.getBrowserTextPattern()) != null) {
            this._cls.setDirectBrowserSlotPattern(pattern);
            this.reload();
            this._currentPattern = pattern;
            this._displaySlotComboBox.setSelectedItem(pattern);
        }
    }
}

